/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceStarter;
import com.sun.jini.start.SharedActivatableServiceDescriptor;
import com.sun.jini.start.SharedGroup;
import com.sun.jini.system.FileSystem;
import java.io.File;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;

public class DestroySharedGroup {
    private static final Logger logger = ServiceStarter.logger;

    private DestroySharedGroup() {
    }

    public static void main(String[] args) {
        ServiceStarter.ensureSecurityManager();
        logger.entering(DestroySharedGroup.class.getName(), "main", args);
        try {
            Configuration config = ConfigurationProvider.getInstance(args);
            ServiceDescriptor[] srvArray = (ServiceDescriptor[])config.getEntry("com.sun.jini.start", "serviceDestructors", ServiceDescriptor[].class, null);
            if (srvArray == null || srvArray.length == 0) {
                logger.log(Level.WARNING, "service.config.empty");
                return;
            }
            LoginContext loginContext = (LoginContext)config.getEntry("com.sun.jini.start", "loginContext", LoginContext.class, null);
            if (loginContext != null) {
                DestroySharedGroup.destroyWithLogin(srvArray, config, loginContext);
            } else {
                DestroySharedGroup.destroy(srvArray, config);
            }
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "destroy.config.exception", ce);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "destroy.unexpected.exception", e);
        }
        logger.exiting(DestroySharedGroup.class.getName(), "main");
    }

    private static void destroy(ServiceDescriptor[] srvArray, Configuration config) throws Exception {
        logger.entering(DestroySharedGroup.class.getName(), "destroy", new Object[]{Arrays.asList(srvArray), config});
        SharedActivatableServiceDescriptor.Created created = null;
        SharedActivatableServiceDescriptor desc = null;
        ActivationSystem activationSystem = null;
        for (int i = 0; i < srvArray.length; ++i) {
            if (srvArray[i] instanceof SharedActivatableServiceDescriptor) {
                desc = (SharedActivatableServiceDescriptor)srvArray[i];
                activationSystem = ServiceStarter.getActivationSystem(desc.getActivationSystemHost(), desc.getActivationSystemPort(), config);
                try {
                    created = (SharedActivatableServiceDescriptor.Created)desc.create(config);
                    if (created != null && created.proxy instanceof SharedGroup) {
                        SharedGroup sg = (SharedGroup)created.proxy;
                        try {
                            sg.destroyVM();
                            try {
                                File log = new File(desc.getSharedGroupLog());
                                FileSystem.destroy(log, true);
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "destroy.group.deletion", e);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "destroy.group.exception", e);
                        }
                        continue;
                    }
                    logger.log(Level.WARNING, "destroy.unexpected.proxy", created == null ? null : created.proxy);
                    if (created == null || created.aid == null) continue;
                    try {
                        activationSystem.unregisterObject(created.aid);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "destroy.unregister.exception", e);
                    }
                }
                catch (Exception ee) {
                    logger.log(Level.SEVERE, "destroy.creation.exception", ee);
                    if (created == null || created.aid == null) continue;
                    try {
                        activationSystem.unregisterObject(created.aid);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "destroy.unregister.exception", ee);
                    }
                }
                continue;
            }
            logger.log(Level.WARNING, "destroy.unexpected.type", srvArray[i]);
        }
        logger.exiting(DestroySharedGroup.class.getName(), "destroy");
    }

    private static void destroyWithLogin(final ServiceDescriptor[] descs, final Configuration config, LoginContext loginContext) throws Exception {
        logger.entering(DestroySharedGroup.class.getName(), "destroyWithLogin", new Object[]{descs, config, loginContext});
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DestroySharedGroup.destroy(descs, config);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        finally {
            try {
                loginContext.logout();
            }
            catch (LoginException le) {
                logger.log(Level.FINE, "service.logout.exception", le);
            }
        }
        logger.exiting(DestroySharedGroup.class.getName(), "destroyWithLogin");
    }
}

