/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import com.sun.jini.system.CommandLine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;

public class MultiCommandLine
extends CommandLine {
    private String[] args;
    private BitSet used;
    private boolean allUsed;
    private boolean usedUp;
    private ArrayList options;
    private String prog;
    private int str;
    private String opt;

    public MultiCommandLine(String[] args) {
        this(null, args);
    }

    public MultiCommandLine(String prog, String[] args) {
        this.prog = prog;
        this.args = args;
        this.used = new BitSet(args.length);
        this.options = new ArrayList();
    }

    public synchronized boolean getBoolean(String opt) {
        this.addOpt(opt, null);
        boolean retval = false;
        while (this.findOpt(opt)) {
            retval = true;
        }
        return retval;
    }

    private String getArgument(String opt) throws CommandLine.BadInvocationException {
        if (this.findOpt(opt)) {
            return this.optArg();
        }
        return null;
    }

    public synchronized String getString(String opt, String defaultValue) throws CommandLine.BadInvocationException {
        this.addOpt(opt, "str");
        return MultiCommandLine.parseString(this.getArgument(opt), defaultValue);
    }

    public synchronized int getInt(String opt, int defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "int");
        return MultiCommandLine.parseInt(this.getArgument(opt), defaultValue);
    }

    public synchronized long getLong(String opt, long defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "long");
        return MultiCommandLine.parseLong(this.getArgument(opt), defaultValue);
    }

    public synchronized double getDouble(String opt, double defaultValue) throws CommandLine.BadInvocationException, NumberFormatException {
        this.addOpt(opt, "val");
        return MultiCommandLine.parseDouble(this.getArgument(opt), defaultValue);
    }

    public synchronized Writer getWriter(String opt, Writer defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseWriter(this.getArgument(opt), defaultValue);
    }

    public synchronized Writer getWriter(String opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseWriter(this.getArgument(opt), path);
    }

    public synchronized Reader getReader(String opt, Reader defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseReader(this.getArgument(opt), defaultValue);
    }

    public synchronized Reader getReader(String opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseReader(this.getArgument(opt), path);
    }

    public synchronized OutputStream getOutputStream(String opt, OutputStream defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseOutputStream(this.getArgument(opt), defaultValue);
    }

    public synchronized OutputStream getOutputStream(String opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseOutputStream(this.getArgument(opt), path);
    }

    public synchronized InputStream getInputStream(String opt, InputStream defaultValue) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseInputStream(this.getArgument(opt), defaultValue);
    }

    public synchronized InputStream getInputStream(String opt, String path) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseInputStream(this.getArgument(opt), path);
    }

    public synchronized RandomAccessFile getRandomAccessFile(String opt, RandomAccessFile defaultValue, String mode) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseRandomAccessFile(this.getArgument(opt), defaultValue, mode);
    }

    public synchronized RandomAccessFile getRandomAccessFile(String opt, String path, String mode) throws IOException, CommandLine.BadInvocationException {
        this.addOpt(opt, "file");
        return MultiCommandLine.parseRandomAccessFile(this.getArgument(opt), path, mode);
    }

    private boolean findOpt(String opt) {
        if (this.allUsed) {
            return false;
        }
        boolean seenUnused = false;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.used.get(i) || !this.args[i].startsWith("-")) continue;
            if (this.args[i].equals("--")) break;
            seenUnused = true;
            if (this.args[i].length() - 1 != opt.length() || !this.args[i].regionMatches(1, opt, 0, opt.length())) continue;
            this.str = i;
            this.opt = opt;
            this.used.set(i);
            return true;
        }
        if (!seenUnused) {
            this.allUsed = true;
        }
        return false;
    }

    private String optArg() throws CommandLine.BadInvocationException {
        if (this.str >= this.args.length) {
            throw new CommandLine.BadInvocationException(this.opt);
        }
        this.used.set(this.str + 1);
        return this.args[this.str + 1];
    }

    public String[] getOperands() throws CommandLine.BadInvocationException, CommandLine.HelpOnlyException {
        int a;
        if (this.getBoolean("?") || this.getBoolean("help")) {
            this.usage();
            throw new CommandLine.HelpOnlyException();
        }
        StringBuffer unknown = new StringBuffer();
        for (a = 0; a < this.args.length; ++a) {
            if (this.used.get(a)) continue;
            if (!this.args[a].startsWith("-")) break;
            if (this.args[a].equals("--")) {
                ++a;
                break;
            }
            unknown.append(' ').append(this.args[a]);
        }
        if (unknown.length() != 0) {
            String ustr = unknown.toString();
            throw new CommandLine.BadInvocationException("unknown option" + (ustr.indexOf(32) > 0 ? "s" : "") + ":" + ustr);
        }
        String[] remains = new String[this.args.length - a];
        System.arraycopy(this.args, a, remains, 0, remains.length);
        this.usedUp = true;
        return remains;
    }

    private void addOpt(String opt, String optType) {
        for (Opt o : this.options) {
            if (!o.opt.equals(opt)) continue;
            o.multi = true;
            return;
        }
        if (!MultiCommandLine.isHelp(opt)) {
            this.options.add(new Opt(opt, optType));
        }
    }

    private static boolean isHelp(String opt) {
        return opt.equals("?") || opt.equals("help");
    }

    public void usage() {
        if (this.prog != null) {
            System.out.print(this.prog);
            System.out.print(' ');
        }
        System.out.print("[-?]");
        for (Opt o : this.options) {
            System.out.print(" [-");
            System.out.print(o.opt);
            if (o.argType != null) {
                System.out.print(' ');
                System.out.print(o.argType);
            }
            System.out.print("]");
            if (!o.multi) continue;
            System.out.print("...");
        }
        System.out.println(" ...");
    }

    private static class Opt {
        String opt;
        String argType;
        boolean multi;

        Opt(String opt, String argType) {
            this.opt = opt;
            this.argType = argType;
        }
    }
}

