/*
 * Decompiled with CFR 0.152.
 */
package net.jini.iiop;

import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import net.jini.export.Exporter;
import org.omg.CORBA.ORB;

public final class IiopExporter
implements Exporter {
    private static final Logger logger = Logger.getLogger("net.jini.iiop.IiopExporter");
    private ORB orb;
    private WeakReference ref;

    public IiopExporter() {
    }

    public IiopExporter(ORB orb) {
        this.orb = orb;
    }

    @Override
    public synchronized Remote export(Remote impl) throws ExportException {
        if (impl == null) {
            throw new NullPointerException();
        }
        if (this.ref != null) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        if (IiopExporter.getTieClass(impl.getClass()) == null) {
            throw new ExportException("tie class unavailable");
        }
        this.ref = new WeakReference<Remote>(impl);
        try {
            PortableRemoteObject.exportObject((Remote)impl);
            Remote proxy = PortableRemoteObject.toStub((Remote)impl);
            if (this.orb != null) {
                ((Stub)proxy).connect(this.orb);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{impl, this, proxy});
            }
            return proxy;
        }
        catch (ExportException ex) {
            throw ex;
        }
        catch (RemoteException ex) {
            throw new ExportException("export failed", ex);
        }
    }

    @Override
    public synchronized boolean unexport(boolean force) {
        if (this.ref == null) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        Remote impl = (Remote)this.ref.get();
        if (impl != null) {
            try {
                PortableRemoteObject.unexportObject((Remote)impl);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, Boolean.TRUE});
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        return true;
    }

    public String toString() {
        return this.orb != null ? "IiopExporter[" + this.orb + "]" : "IiopExporter[]";
    }

    private static Class getTieClass(Class implClass) {
        String implClassName = implClass.getName();
        int i = implClassName.indexOf(36);
        if (i < 0) {
            i = implClassName.lastIndexOf(46);
        }
        String tieClassName2 = i > 0 ? implClassName.substring(0, i + 1) + "_" + implClassName.substring(i + 1) + "_Tie" : "_" + implClassName + "_Tie";
        ArrayList<String> names = new ArrayList<String>(2);
        names.add(tieClassName2);
        if (tieClassName2.startsWith("java.") || tieClassName2.startsWith("com.sun.") || tieClassName2.startsWith("net.jini.") || tieClassName2.startsWith("jini.") || tieClassName2.startsWith("javax.")) {
            names.add("org.omg.stub." + tieClassName2);
        }
        ClassLoader loader = implClass.getClassLoader();
        String codebase = Util.getCodebase((Class)implClass);
        for (String tieClassName2 : names) {
            try {
                return Util.loadClass((String)tieClassName2, (String)codebase, (ClassLoader)loader);
            }
            catch (ClassNotFoundException ex) {
                if (loader == null) continue;
                try {
                    return loader.loadClass(tieClassName2);
                }
                catch (ClassNotFoundException ex2) {
                }
            }
        }
        Class implSuper = implClass.getSuperclass();
        return implSuper != null && implSuper != PortableRemoteObject.class && implSuper != Object.class ? IiopExporter.getTieClass(implSuper) : null;
    }
}

