/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.net.Socket;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.AuthenticationPermission;

class ClientAuthManager
extends AuthManager {
    private static final Logger logger = clientLogger;
    private X509Certificate serverCredential;
    private X500Principal serverPrincipal;
    private X500PrivateCredential clientCredential;
    private X500Principal clientPrincipal;
    private Exception clientCredentialException;
    private long credentialsValidUntil = 0L;
    private AuthenticationPermission authenticationPermission;

    ClientAuthManager(Subject subject, Set permittedLocalPrincipals, Set permittedRemotePrincipals) throws NoSuchAlgorithmException {
        super(subject, permittedLocalPrincipals, permittedRemotePrincipals);
    }

    synchronized boolean getClientAuthenticated() {
        return this.clientCredential != null;
    }

    synchronized Exception getClientCredentialException() {
        return this.clientCredentialException;
    }

    synchronized void checkAuthentication() throws UnsupportedConstraintException {
        if (this.clientCredential == null) {
            throw new UnsupportedConstraintException("Client is not authenticated");
        }
        if (this.clientCredential.isDestroyed()) {
            throw new UnsupportedConstraintException("Private credentials are destroyed");
        }
        if (System.currentTimeMillis() > this.credentialsValidUntil) {
            throw new UnsupportedConstraintException("Certificates are no longer valid");
        }
        if (this.subjectIsReadOnly) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(this.authenticationPermission);
            }
        } else {
            X509Certificate cert;
            Subject subject = this.getSubject();
            if (SubjectCredentials.getPrincipal(subject, cert = this.clientCredential.getCertificate()) == null) {
                throw new UnsupportedConstraintException("Missing principal");
            }
            CertPath chain = SubjectCredentials.getCertificateChain(subject, cert);
            if (chain == null) {
                throw new UnsupportedConstraintException("Missing public credentials");
            }
            X500PrivateCredential pc = this.getPrivateCredential(cert, this.authenticationPermission);
            if (pc == null) {
                throw new UnsupportedConstraintException("Missing private credentials");
            }
            if (!this.equalPrivateCredentials(this.clientCredential, pc)) {
                throw new UnsupportedConstraintException("Wrong private credentials");
            }
        }
    }

    @Override
    synchronized X500PrivateCredential getPrivateCredential(X509Certificate cert) {
        return this.getPrivateCredential(cert, this.getAuthenticationPermission(cert));
    }

    private X500PrivateCredential getPrivateCredential(X509Certificate cert, AuthenticationPermission ap) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ap);
        }
        return (X500PrivateCredential)AccessController.doPrivileged(new SubjectCredentials.GetPrivateCredentialAction(subject, cert));
    }

    @Override
    Logger getLogger() {
        return logger;
    }

    private AuthenticationPermission getAuthenticationPermission(X509Certificate cert) {
        Set<X500Principal> client = Collections.singleton(cert.getSubjectX500Principal());
        Set<X500Principal> server = this.serverPrincipal == null ? null : Collections.singleton(this.serverPrincipal);
        return new AuthenticationPermission(client, server, "connect");
    }

    synchronized X500Principal getServerPrincipal() {
        return this.serverPrincipal;
    }

    synchronized X500Principal getClientPrincipal() {
        return this.clientPrincipal;
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        super.checkServerTrusted(chain, authType);
        if (this.serverPrincipal == null) {
            this.serverCredential = chain[0];
            this.serverPrincipal = this.serverCredential.getSubjectX500Principal();
            this.setPermittedRemotePrincipals(Collections.singleton(this.serverPrincipal));
            this.credentialsValidUntil = ClientAuthManager.certificatesValidUntil(chain);
        } else if (!this.serverCredential.equals(chain[0])) {
            throw new CertificateException("Server credentials changed");
        }
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        Object[] result = this.getAliases(keyType, issuers);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "get client aliases for key type {0}\nand issuers {1}\nreturns {2}", new Object[]{keyType, ClientAuthManager.toString(issuers), ClientAuthManager.toString(result)});
        }
        return result;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }

    @Override
    public synchronized String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        if (this.clientCredentialException != null) {
            return null;
        }
        if (this.clientCredential == null) {
            int i;
            ArrayList<GeneralSecurityException> exceptions = null;
            for (i = 0; i < keyTypes.length; ++i) {
                Exception exception;
                try {
                    this.clientCredential = this.chooseCredential(keyTypes[i], issuers);
                    if (this.clientCredential == null) continue;
                    break;
                }
                catch (GeneralSecurityException e) {
                    exception = e;
                }
                catch (SecurityException e) {
                    exception = e;
                }
                if (exceptions == null) {
                    exceptions = new ArrayList<GeneralSecurityException>();
                }
                exceptions.add((GeneralSecurityException)exception);
            }
            if (this.clientCredential == null) {
                if (exceptions == null) {
                    this.clientCredentialException = new GeneralSecurityException("Credentials not found");
                } else if (exceptions.size() == 1) {
                    this.clientCredentialException = (Exception)exceptions.get(0);
                } else {
                    i = exceptions.size();
                    while (--i >= 0) {
                        Exception e = (Exception)exceptions.get(i);
                        if (e instanceof SecurityException) continue;
                        this.clientCredentialException = new GeneralSecurityException(((Object)exceptions).toString());
                        break;
                    }
                    if (this.clientCredentialException == null) {
                        this.clientCredentialException = new SecurityException(((Object)exceptions).toString());
                    }
                }
                return null;
            }
        }
        X509Certificate cert = this.clientCredential.getCertificate();
        this.clientPrincipal = cert.getSubjectX500Principal();
        this.credentialsValidUntil = Math.min(this.credentialsValidUntil, ClientAuthManager.certificatesValidUntil(SubjectCredentials.getCertificateChain(this.getSubject(), cert)));
        this.authenticationPermission = this.getAuthenticationPermission(cert);
        String result = SubjectCredentials.getCertificateName(this.clientCredential.getCertificate());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose client alias for key types {0}\nand issuers {1}\nreturns {2}", new Object[]{ClientAuthManager.toString(keyTypes), ClientAuthManager.toString(issuers), result});
        }
        return result;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }
}

