/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Guard;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.TreeSet;
import net.jini.security.policy.PolicyInitializationException;
import org.apache.river.api.security.DefaultPolicyParser;
import org.apache.river.api.security.PermissionComparator;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.PolicyParser;
import org.apache.river.api.security.PolicyUtils;
import org.apache.river.api.security.ScalableNestedPolicy;

public class ConcurrentPolicyFile
extends Policy
implements ScalableNestedPolicy {
    private static final String JAVA_SECURITY_POLICY = "java.security.policy";
    private static final String POLICY_URL_PREFIX = "policy.url.";
    private static final Permission ALL_PERMISSION = new AllPermission();
    private volatile PermissionGrant[] grantArray;
    private final PolicyParser parser;
    private static final Guard guard = new SecurityPermission("getPolicy");
    private static final ProtectionDomain myDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return ConcurrentPolicyFile.class.getProtectionDomain();
        }
    });
    private final Comparator<Permission> comparator;
    private volatile PermissionCollection myPermissions;

    public ConcurrentPolicyFile() throws PolicyInitializationException {
        this(new DefaultPolicyParser(), new PermissionComparator());
    }

    protected ConcurrentPolicyFile(PolicyParser dpr, Comparator<Permission> comp) throws PolicyInitializationException {
        guard.checkGuard(null);
        this.parser = dpr;
        this.comparator = comp;
        try {
            this.initialize();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("PolicyInitialization failed", e);
        }
    }

    private PermissionCollection convert(NavigableSet<Permission> permissions) {
        Permissions pc = new Permissions();
        Iterator<Permission> it = permissions.descendingIterator();
        while (it.hasNext()) {
            ((PermissionCollection)pc).add(it.next());
        }
        return pc;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain pd) {
        TreeSet<Permission> perms = new TreeSet<Permission>(this.comparator);
        for (PermissionGrant ge : this.grantArray) {
            if (!ge.implies(pd)) continue;
            if (ge.isPrivileged()) {
                Permissions pc = new Permissions();
                ((PermissionCollection)pc).add(new AllPermission());
                return pc;
            }
            Collection<Permission> c = ge.getPermissions();
            for (Permission p : c) {
                perms.add(p);
            }
        }
        PermissionCollection staticPC = null;
        if (pd != null && (staticPC = pd.getPermissions()) != null) {
            Enumeration<Permission> e = staticPC.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (p instanceof AllPermission) {
                    Permissions pc = new Permissions();
                    ((PermissionCollection)pc).add(p);
                    return pc;
                }
                perms.add(p);
            }
        }
        return this.convert(perms);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        if (cs == null) {
            throw new NullPointerException("CodeSource cannot be null");
        }
        for (PermissionGrant ge : this.grantArray) {
            if (!ge.implies(cs, null) || !ge.isPrivileged()) continue;
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(ALL_PERMISSION);
            return pc;
        }
        return super.getPermissions(cs);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (permission == null) {
            throw new NullPointerException("permission not allowed to be null");
        }
        if (domain == myDomain) {
            PermissionCollection pc = this.myPermissions;
            return pc.implies(permission);
        }
        Class<?> klass = permission.getClass();
        TreeSet<Permission> perms = new TreeSet<Permission>(this.comparator);
        for (PermissionGrant ge : this.grantArray) {
            if (!ge.implies(domain)) continue;
            if (ge.isPrivileged()) {
                return true;
            }
            Collection<Permission> c = ge.getPermissions();
            for (Permission p : c) {
                if (!klass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                perms.add(p);
            }
        }
        PermissionCollection staticPC = null;
        if (domain != null && (staticPC = domain.getPermissions()) != null) {
            Enumeration<Permission> e = staticPC.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (p instanceof AllPermission) {
                    return true;
                }
                if (!klass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                perms.add(p);
            }
        }
        return this.convert(perms).implies(permission);
    }

    @Override
    public void refresh() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    private void initialize() throws Exception {
        try {
            Collection<PermissionGrant> fresh = AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<PermissionGrant>>(){

                @Override
                public Collection<PermissionGrant> run() throws SecurityException {
                    ArrayList<PermissionGrant> fresh = new ArrayList<PermissionGrant>(120);
                    Properties system = System.getProperties();
                    system.setProperty("/", File.separator);
                    URL[] policyLocations = PolicyUtils.getPolicyURLs(system, ConcurrentPolicyFile.JAVA_SECURITY_POLICY, ConcurrentPolicyFile.POLICY_URL_PREFIX);
                    int l = policyLocations.length;
                    for (int i = 0; i < l; ++i) {
                        try {
                            Collection<PermissionGrant> pc = null;
                            pc = ConcurrentPolicyFile.this.parser.parse(policyLocations[i], system);
                            fresh.addAll(pc);
                            continue;
                        }
                        catch (Exception e) {
                            if (!(e instanceof SecurityException)) continue;
                            e.printStackTrace(System.out);
                            throw (SecurityException)e;
                        }
                    }
                    return fresh;
                }
            });
            this.grantArray = fresh.toArray(new PermissionGrant[fresh.size()]);
            this.myPermissions = this.getPermissions(myDomain);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    @Override
    public Collection<PermissionGrant> getPermissionGrants(ProtectionDomain pd) {
        PermissionCollection pc;
        PermissionGrant[] grants = this.grantArray;
        int l = grants.length;
        LinkedList<PermissionGrant> applicable = new LinkedList<PermissionGrant>();
        for (int i = 0; i < l; ++i) {
            if (!grants[i].implies(pd)) continue;
            applicable.add(grants[i]);
        }
        PermissionCollection permissionCollection = pc = pd != null ? pd.getPermissions() : null;
        if (pc != null) {
            PermissionGrantBuilder pgb = PermissionGrantBuilder.newBuilder();
            pgb.setDomain(new WeakReference<ProtectionDomain>(pd));
            pgb.context(1);
            LinkedList<Permission> perms = new LinkedList<Permission>();
            Enumeration<Permission> en = pc.elements();
            while (en.hasMoreElements()) {
                perms.add(en.nextElement());
            }
            pgb.permissions(perms.toArray(new Permission[perms.size()]));
            applicable.add(pgb.build());
        }
        return applicable;
    }
}

