/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.discovery;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;
import org.apache.river.extra.discovery.ServiceFinder;

public class MulticastServiceFinder
implements ServiceFinder {
    private static final Logger logger = Logger.getLogger(MulticastServiceFinder.class.getSimpleName());
    private static final long SETTLE_DOWN_WAIT_TIME = 500L;
    private final ServiceDiscoveryManager serviceDiscovery;

    public MulticastServiceFinder() throws IOException {
        this(LookupDiscovery.ALL_GROUPS);
    }

    public MulticastServiceFinder(String[] lookupGroups) throws IOException {
        this(new LookupDiscovery(lookupGroups), new LeaseRenewalManager());
    }

    public MulticastServiceFinder(DiscoveryManagement dm, LeaseRenewalManager lrm) throws IOException {
        this.serviceDiscovery = new ServiceDiscoveryManager(dm, lrm);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Object findNewService(ServiceTemplate template) throws RemoteException {
        return this.findNewService(template, new ServiceItemFilter(){

            @Override
            public boolean check(ServiceItem item) {
                return true;
            }
        });
    }

    public Object findNewService(ServiceTemplate template, ServiceItemFilter filter) throws RemoteException {
        ServiceItem[] services = this.serviceDiscovery.lookup(template, 1, filter);
        if (null == services || 0 == services.length) {
            throw new RemoteException("Cannot find valid service");
        }
        return services[0].service;
    }

    @Override
    public void terminate() {
        logger.info("Terminating service finder");
        this.serviceDiscovery.terminate();
    }
}

