/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.extra.helpers;

import com.sun.jini.config.Component;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.Remote;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.id.Uuid;
import org.apache.river.extra.helpers.ProxyHelper;

public abstract class ConfigHelper {
    public static final String DGC = "dgc";
    public static final String IC = "ic";
    public static final String UUID = "uuid";
    public static final String VERIFY = "verify";
    public static final String EXPORTER = "exporter";
    public static final String ILF = "ilf";
    public static final String KEEPALIVE = "keepAlive";
    public static final String SERVERENDPOINT = "serverEndpoint";
    public static final String PREPARER = "preparer";
    protected Configuration configuration;

    public ConfigHelper(Configuration configuration) {
        this.configuration = configuration;
    }

    public ConfigHelper(URL resource) throws ConfigurationException {
        String[] configArgs = new String[]{resource.toExternalForm()};
        this.configuration = ConfigurationProvider.getInstance(configArgs);
    }

    protected ProxyHelper getProxyHelper(String component) {
        return new ProxyHelper(this.configuration);
    }

    private Component findComponentAnnotation(Class<?> cls) {
        Class<?>[] ifs;
        if (!Remote.class.isAssignableFrom(cls)) {
            return null;
        }
        if (Proxy.isProxyClass(cls)) {
            Class<?>[] ifs2;
            for (Class<?> c : ifs2 = cls.getInterfaces()) {
                Component jc = this.findComponentAnnotation(c);
                if (jc == null) continue;
                return jc;
            }
            return null;
        }
        Component jc = cls.getAnnotation(Component.class);
        if (jc != null) {
            return jc;
        }
        for (Class<?> c : ifs = cls.getInterfaces()) {
            jc = this.findComponentAnnotation(c);
            if (jc == null) continue;
            return jc;
        }
        return null;
    }

    protected String getComponent(Class<?> cls) {
        Component jc = this.findComponentAnnotation(cls);
        if (jc != null) {
            String comp = jc.value();
            if (comp == null) {
                comp = cls.getName();
            }
            return comp;
        }
        return cls.getName();
    }

    protected InvocationConstraints getInvocationConstraints(String component) throws ConfigurationException {
        InvocationConstraints ic = (InvocationConstraints)this.configuration.getEntry(component, IC, InvocationConstraints.class, null);
        return ic;
    }

    protected Uuid getUuid(String component) throws ConfigurationException {
        Uuid uuid = (Uuid)this.configuration.getEntry(component, UUID, Uuid.class, null);
        return uuid;
    }

    protected boolean getDgc(String component) throws ConfigurationException {
        Boolean b = (Boolean)this.configuration.getEntry(component, DGC, Boolean.TYPE, false);
        return b;
    }

    protected boolean getVerify(String component) throws ConfigurationException {
        return (Boolean)this.configuration.getEntry(component, VERIFY, Boolean.TYPE, false);
    }
}

