/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.CollectionDecorator;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferencedQueue;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceBlockingQueue<T>
extends ReferencedQueue<T>
implements BlockingQueue<T> {
    private static final long serialVersionUID = 1L;
    private final BlockingQueue<Referrer<T>> queue;

    ReferenceBlockingQueue(BlockingQueue<Referrer<T>> queue, Ref type, boolean gcThreads, long gcCycle) {
        super(queue, type, gcThreads, gcCycle);
        this.queue = queue;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public void put(T e) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        this.queue.put(r);
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> r = this.wrapObj(e, true, false);
        return this.queue.offer(r, timeout, unit);
    }

    @Override
    public T take() throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.queue.take();
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.processQueue();
        Referrer<T> t = this.queue.poll(timeout, unit);
        if (t != null) {
            return t.get();
        }
        return null;
    }

    @Override
    public int remainingCapacity() {
        this.processQueue();
        return this.queue.remainingCapacity();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        this.processQueue();
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        CollectionDecorator<? super T> dr = new CollectionDecorator<T>(c, this.getRQF(), false, true);
        return this.queue.drainTo(dr);
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        this.processQueue();
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        CollectionDecorator<? super T> drain = new CollectionDecorator<T>(c, this.getRQF(), false, true);
        return this.queue.drainTo(drain, maxElements);
    }
}

