/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceEntryFacade;
import au.net.zeus.collection.ReferenceNavigableSet;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.ReferenceSortedMap;
import au.net.zeus.collection.Referrer;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceNavigableMap<K, V>
extends ReferenceSortedMap<K, V>
implements NavigableMap<K, V> {
    private final NavigableMap<Referrer<K>, Referrer<V>> map;

    ReferenceNavigableMap(NavigableMap<Referrer<K>, Referrer<V>> map, Ref keyRef, Ref valRef, boolean gcThreads, long gcKeyCycle, long gcValCycle) {
        super(map, keyRef, valRef, gcThreads, gcKeyCycle, gcValCycle);
        this.map = map;
    }

    ReferenceNavigableMap(NavigableMap<Referrer<K>, Referrer<V>> map, ReferenceQueuingFactory<K, Referrer<K>> krqf, ReferenceQueuingFactory<V, Referrer<V>> vrqf, Ref key, Ref val) {
        super(map, krqf, vrqf, key, val);
        this.map = map;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.lowerEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K lowerKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.lowerKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.floorEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K floorKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.floorKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.ceilingEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K ceilingKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.ceilingKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.higherEntry(this.wrapKey(key, false, true)), this.getValRQF());
    }

    @Override
    public K higherKey(K key) {
        this.processQueue();
        Referrer<K> k = this.map.higherKey(this.wrapKey(key, false, true));
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.firstEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.lastEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.pollFirstEntry(), this.getValRQF());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        this.processQueue();
        return new ReferenceEntryFacade<K, V>(this.map.pollLastEntry(), this.getValRQF());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        this.processQueue();
        return new ReferenceNavigableMap<K, V>(this.map.descendingMap(), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        this.processQueue();
        return new ReferenceNavigableSet(this.map.navigableKeySet(), this.getKeyRQF(), this.keyRef());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        this.processQueue();
        return new ReferenceNavigableSet(this.map.descendingKeySet(), this.getKeyRQF(), this.keyRef());
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        this.processQueue();
        return new ReferenceNavigableMap<K, V>(this.map.subMap(this.wrapKey(fromKey, false, true), fromInclusive, this.wrapKey(toKey, false, true), toInclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        this.processQueue();
        return new ReferenceNavigableMap<K, V>(this.map.headMap(this.wrapKey(toKey, false, true), inclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        this.processQueue();
        return new ReferenceNavigableMap<K, V>(this.map.tailMap(this.wrapKey(fromKey, false, true), inclusive), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }
}

