/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.kerberos;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.EndpointBasedServer;
import com.sun.jini.discovery.internal.EndpointInternals;
import com.sun.jini.discovery.internal.KerberosEndpointInternalsAccess;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.net.ServerSocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.kerberos.KerberosServerEndpoint;

public class Server
implements UnicastDiscoveryServer {
    private final ServerImpl impl = new ServerImpl();

    @Override
    public String getFormatName() {
        return this.impl.getFormatName();
    }

    @Override
    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        this.impl.checkUnicastDiscoveryConstraints(constraints);
    }

    @Override
    public void handleUnicastDiscovery(UnicastResponse response, Socket socket, InvocationConstraints constraints, ClientSubjectChecker checker, Collection context, ByteBuffer received, ByteBuffer sent) throws IOException {
        this.impl.handleUnicastDiscovery(response, socket, constraints, checker, context, received, sent);
    }

    private static final class ServerImpl
    extends EndpointBasedServer {
        private static EndpointInternals epi = (EndpointInternals)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return KerberosEndpointInternalsAccess.get();
            }
        });

        ServerImpl() {
            super("net.jini.discovery.kerberos", epi);
        }

        @Override
        protected ServerEndpoint getServerEndpoint(ServerSocketFactory factory) throws UnsupportedConstraintException {
            return KerberosServerEndpoint.getInstance("ignored", 0, null, factory);
        }
    }
}

