/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.lease;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;

public abstract class AbstractLease
implements Lease,
Serializable {
    private static final long serialVersionUID = -9067179156916102052L;
    protected transient long expiration;
    protected int serialFormat = 1;

    protected AbstractLease(long expiration) {
        this.expiration = expiration;
    }

    @Override
    public synchronized long getExpiration() {
        return this.expiration;
    }

    @Override
    public synchronized int getSerialFormat() {
        return this.serialFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSerialFormat(int format) {
        if (format != 1 && format != 2) {
            throw new IllegalArgumentException("invalid serial format");
        }
        AbstractLease abstractLease = this;
        synchronized (abstractLease) {
            this.serialFormat = format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renew(long duration) throws UnknownLeaseException, LeaseDeniedException, RemoteException {
        long exp = this.doRenew(duration) + System.currentTimeMillis();
        if (exp < 0L) {
            exp = Long.MAX_VALUE;
        }
        AbstractLease abstractLease = this;
        synchronized (abstractLease) {
            this.expiration = exp;
        }
    }

    protected abstract long doRenew(long var1) throws UnknownLeaseException, LeaseDeniedException, RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        long exp;
        long val;
        int format;
        AbstractLease abstractLease = this;
        synchronized (abstractLease) {
            format = this.serialFormat;
            val = this.expiration;
        }
        if (format == 1 && (exp = val) < 0L && (val -= System.currentTimeMillis()) > 0L) {
            val = Long.MIN_VALUE;
        }
        stream.putFields().put("serialFormat", format);
        stream.writeFields();
        stream.writeLong(val);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data in stream");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        long val = stream.readLong();
        if (this.serialFormat == 1) {
            long dur = val;
            if ((val += System.currentTimeMillis()) < 0L && dur > 0L) {
                val = Long.MAX_VALUE;
            }
        } else if (this.serialFormat != 2) {
            throw new InvalidObjectException("invalid serial format");
        }
        this.expiration = val;
    }
}

