/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.mercury.EventID;
import com.sun.jini.mercury.EventLogFactory;
import com.sun.jini.mercury.EventLogIterator;
import com.sun.jini.mercury.InternalMailboxException;
import com.sun.jini.mercury.ListenerProxy;
import com.sun.jini.mercury.MailboxAdminProxy;
import com.sun.jini.mercury.MailboxBackEnd;
import com.sun.jini.mercury.MailboxProxy;
import com.sun.jini.mercury.ProxyVerifier;
import com.sun.jini.mercury.Registration;
import com.sun.jini.mercury.RemoteEventData;
import com.sun.jini.mercury.RemoteEventIteratorData;
import com.sun.jini.mercury.ServiceRegistration;
import com.sun.jini.proxy.ThrowThis;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.event.InvalidIteratorException;
import net.jini.event.MailboxPullRegistration;
import net.jini.event.MailboxRegistration;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class MailboxImpl
implements MailboxBackEnd,
TimeConstants,
ServerProxyTrust,
ProxyAccessor {
    static final String MERCURY = "com.sun.jini.mercury";
    static final Logger leaseLogger = Logger.getLogger("com.sun.jini.mercury.lease");
    static final Logger deliveryLogger = Logger.getLogger("com.sun.jini.mercury.delivery");
    static final Logger adminLogger = Logger.getLogger("com.sun.jini.mercury.admin");
    static final Logger initLogger = Logger.getLogger("com.sun.jini.mercury.init");
    static final Logger receiveLogger = Logger.getLogger("com.sun.jini.mercury.receive");
    static final Logger expirationLogger = Logger.getLogger("com.sun.jini.mercury.expiration");
    static final Logger recoveryLogger = Logger.getLogger("com.sun.jini.mercury.recovery");
    static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mercury.persistence");
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.mercury.startup");
    static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mercury.operations");
    private static final String mailboxSourceClass = MailboxImpl.class.getName();
    private static final String notifierSourceClass = Notifier.class.getName();
    private static final String notifyTaskSourceClass = NotifyTask.class.getName();
    private static final String destroyThreadSourceClass = DestroyThread.class.getName();
    private static final String expirationThreadSourceClass = ExpirationThread.class.getName();
    private static final String registrationLogObjSourceClass = RegistrationLogObj.class.getName();
    private static final String registrationEnabledLogObjSourceClass = RegistrationEnabledLogObj.class.getName();
    private static final String registrationDisabledLogObjSourceClass = RegistrationDisabledLogObj.class.getName();
    private static final String registrationIteratorEnabledLogObjSourceClass = RegistrationIteratorEnabledLogObj.class.getName();
    private static final String lookupGroupsChangedLogObjSourceClass = LookupGroupsChangedLogObj.class.getName();
    private static final String lookupLocatorsChangedLogObjSourceClass = LookupLocatorsChangedLogObj.class.getName();
    private static final String attrsAddedLogObjSourceClass = AttrsAddedLogObj.class.getName();
    private static final String attrsModifiedLogObjSourceClass = AttrsModifiedLogObj.class.getName();
    private static final String registrationRenewedLogObjSourceClass = RegistrationRenewedLogObj.class.getName();
    private static final String registrationCancelledLogObjSourceClass = RegistrationCancelledLogObj.class.getName();
    private static final String unknownEventExceptionLogObjSourceClass = UnknownEventExceptionLogObj.class.getName();
    private static final String snapshotThreadSourceClass = SnapshotThread.class.getName();
    private static final String PRODUCT = "EventMailbox";
    private static final String MANUFACTURER = "Sun Microsystems, Inc.";
    private static final String VENDOR = "Sun Microsystems, Inc.";
    private static final String VERSION = "2.2.0";
    private MailboxBackEnd serverStub;
    private MailboxProxy mailboxProxy;
    private MailboxAdminProxy mailboxAdminProxy;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private HashMap regByID = new HashMap();
    private final TreeMap regByExpiration = new TreeMap();
    private List pendingReg = new ArrayList();
    private Map activeReg = new HashMap();
    private ReliableLog log;
    private static final int LOG_VERSION = 2;
    private boolean inRecovery;
    private int logFileSize = 0;
    private int logToSnapshotThreshold = 50;
    private final Object snapshotNotifier = new Object();
    private Thread snapshotter = null;
    protected LoginContext loginContext;
    private String persistenceDirectory = null;
    private ProxyPreparer listenerPreparer;
    protected Exporter exporter;
    private Uuid serviceID = null;
    private ActivationID activationID = null;
    private boolean activationPrepared;
    private ActivationSystem activationSystem;
    private final EventLogFactory eventLogFactory = new EventLogFactory();
    private LeasePeriodPolicy leasePolicy = null;
    private LeaseFactory leaseFactory = null;
    private LocalLandlordAdaptor localLandlord = new LocalLandlordAdaptor();
    private JoinManager joiner = null;
    private DiscoveryManagement lookupDiscMgr = null;
    private Entry[] baseLookupAttrs = new Entry[]{new ServiceInfo("EventMailbox", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.0", "", ""), new BasicServiceType("Event Mailbox")};
    private Entry[] lookupAttrs = new Entry[0];
    private String[] lookupGroups = LookupDiscovery.NO_GROUPS;
    private LookupLocator[] lookupLocators = new LookupLocator[0];
    private static ProxyPreparer locatorToJoinPreparer;
    private static ProxyPreparer recoveredLocatorToJoinPreparer;
    private Notifier notifier = null;
    private final Object eventNotifier = new Object();
    private ExpirationThread expirer = null;
    private long minRegExpiration = Long.MAX_VALUE;
    private final Object expirationNotifier = new Object();
    private final Object destroyLock = new Object();
    private boolean destroySucceeded = false;
    private long maxUnexportDelay;
    private long unexportRetryDelay;
    private final ReadyState readyState = new ReadyState();
    private LifeCycle lifeCycle = null;
    private boolean persistent = true;
    private static final long MAX_TIME = 3600000L;
    private static final int MAX_ATTEMPTS = 5;

    @Override
    public Object getProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getProxy");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getProxy", this.serverStub);
        }
        return this.serverStub;
    }

    @Override
    public Object getServiceProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getServiceProxy");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getServiceProxy", this.mailboxProxy);
        }
        return this.mailboxProxy;
    }

    @Override
    public Object getAdmin() throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getAdmin");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getAdmin", this.mailboxAdminProxy);
        }
        return this.mailboxAdminProxy;
    }

    MailboxImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "MailboxImpl", new Object[]{activationID, data});
        }
        this.activationID = activationID;
        try {
            this.init((String[])data.get());
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "MailboxImpl");
        }
    }

    MailboxImpl(String[] configArgs, LifeCycle lc, boolean persistent) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "MailboxImpl", new Object[]{configArgs, lc, persistent});
        }
        try {
            this.lifeCycle = lc;
            this.persistent = persistent;
            this.init(configArgs);
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "MailboxImpl");
        }
    }

    private void init(String[] configArgs) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "init", configArgs);
        }
        Configuration config = ConfigurationProvider.getInstance(configArgs, this.getClass().getClassLoader());
        this.loginContext = (LoginContext)config.getEntry(MERCURY, "loginContext", LoginContext.class, null);
        if (this.loginContext != null) {
            this.doInitWithLogin(config, this.loginContext);
        } else {
            this.doInit(config);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "init");
        }
    }

    private void doInitWithLogin(final Configuration config, LoginContext loginContext) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "doInitWithLogin", new Object[]{config, loginContext});
        }
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MailboxImpl.this.doInit(config);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            block6: {
                try {
                    loginContext.logout();
                }
                catch (LoginException le) {
                    if (!initLogger.isLoggable(Levels.HANDLED)) break block6;
                    initLogger.log(Levels.HANDLED, "Trouble logging out", le);
                }
            }
            throw e.getException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "doInitWithLogin");
        }
    }

    private void doInit(Configuration config) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "doInit", config);
        }
        if (this.activationID != null) {
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationSystemPreparer: {0}", activationSystemPreparer);
            }
            this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy(ActivationGroup.getSystem());
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Prepared activation system is: {0}", this.activationSystem);
            }
            ProxyPreparer activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationIdPreparer: {0}", activationIdPreparer);
            }
            this.activationID = (ActivationID)activationIdPreparer.prepareProxy(this.activationID);
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Prepared activationID is: {0}", this.activationID);
            }
            this.activationPrepared = true;
            this.exporter = (Exporter)Config.getNonNullEntry(config, MERCURY, "serverExporter", Exporter.class, new ActivationExporter(this.activationID, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, true)), this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Activatable service exporter is: {0}", this.exporter);
            }
        } else {
            this.exporter = (Exporter)Config.getNonNullEntry(config, MERCURY, "serverExporter", Exporter.class, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, true));
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Non-activatable service exporter is: {0}", this.exporter);
            }
        }
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "listenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Listener preparer is: {0}", this.listenerPreparer);
        }
        locatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "locatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Locator preparer is: {0}", locatorToJoinPreparer);
        }
        this.leasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, MERCURY, "leasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(10800000L, 3600000L));
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "LeasePeriodPolicy is: {0}", this.leasePolicy);
        }
        ProxyPreparer recoveredListenerPreparer = null;
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry(config, MERCURY, "persistenceDirectory", String.class);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Persistence directory is: {0}", this.persistenceDirectory);
            }
            recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "recoveredListenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Recovered listener preparer is: {0}", recoveredListenerPreparer);
            }
            recoveredLocatorToJoinPreparer = (ProxyPreparer)Config.getNonNullEntry(config, MERCURY, "recoveredLocatorToJoinPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Recovered locator preparer is: {0}", recoveredLocatorToJoinPreparer);
            }
            this.logToSnapshotThreshold = Config.getIntEntry(config, MERCURY, "logToSnapshotThreshold", 50, 0, Integer.MAX_VALUE);
            this.log = new ReliableLog(this.persistenceDirectory, new LocalLogHandler());
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering persistent state");
            }
            this.inRecovery = true;
            this.log.recover();
            this.inRecovery = false;
        }
        if (this.serviceID == null) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Getting initial values.");
            }
            this.serviceID = UuidFactory.generate();
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "ServiceID: {0}", this.serviceID);
            }
            this.lookupGroups = (String[])config.getEntry(MERCURY, "initialLookupGroups", String[].class, new String[]{""});
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Initial groups:");
                MailboxImpl.dumpGroups(this.lookupGroups, initLogger, Level.CONFIG);
            }
            this.lookupLocators = (LookupLocator[])Config.getNonNullEntry(config, MERCURY, "initialLookupLocators", LookupLocator[].class, new LookupLocator[0]);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Initial locators:");
                MailboxImpl.dumpLocators(this.lookupLocators, initLogger, Level.CONFIG);
            }
            Entry[] initialAttrs = (Entry[])Config.getNonNullEntry(config, MERCURY, "initialLookupAttributes", Entry[].class, new Entry[0]);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Initial lookup attributes:");
                MailboxImpl.dumpAttrs(initialAttrs, initLogger, Level.CONFIG);
            }
            if (initialAttrs.length == 0) {
                this.lookupAttrs = this.baseLookupAttrs;
            } else {
                this.lookupAttrs = new Entry[initialAttrs.length + this.baseLookupAttrs.length];
                int i = 0;
                int j = 0;
                while (j < this.baseLookupAttrs.length) {
                    this.lookupAttrs[i] = this.baseLookupAttrs[j];
                    ++j;
                    ++i;
                }
                j = 0;
                while (j < initialAttrs.length) {
                    this.lookupAttrs[i] = initialAttrs[j];
                    ++j;
                    ++i;
                }
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Combined lookup attributes:");
                MailboxImpl.dumpAttrs(this.lookupAttrs, initLogger, Level.FINEST);
            }
        } else {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Preparing recovered locators:");
                MailboxImpl.dumpLocators(this.lookupLocators, initLogger, Level.FINEST);
            }
            MailboxImpl.prepareExistingLocators(recoveredLocatorToJoinPreparer, this.lookupLocators);
        }
        if (this.persistent) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Taking snapshot.");
            }
            this.log.snapshot();
            this.rebuildTransientState(recoveredListenerPreparer);
            this.snapshotter = new SnapshotThread();
        }
        this.maxUnexportDelay = Config.getLongEntry(config, MERCURY, "maxUnexportDelay", 120000L, 0L, Long.MAX_VALUE);
        this.unexportRetryDelay = Config.getLongEntry(config, MERCURY, "unexportRetryDelay", 1000L, 1L, Long.MAX_VALUE);
        this.notifier = new Notifier(config);
        this.expirer = new ExpirationThread();
        this.serverStub = (MailboxBackEnd)this.exporter.export(this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service stub is: {0}", this.serverStub);
        }
        this.mailboxProxy = MailboxProxy.create(this.serverStub, this.serviceID);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service proxy is: {0}", this.mailboxProxy);
        }
        this.mailboxAdminProxy = MailboxAdminProxy.create(this.serverStub, this.serviceID);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service admin proxy is: {0}", this.mailboxAdminProxy);
        }
        this.leaseFactory = new LeaseFactory(this.serverStub, this.serviceID);
        try {
            this.lookupDiscMgr = (DiscoveryManagement)Config.getNonNullEntry(config, MERCURY, "discoveryManager", DiscoveryManagement.class);
            if (this.lookupDiscMgr instanceof DiscoveryGroupManagement) {
                String[] groups = ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).getGroups();
                if (groups == DiscoveryGroupManagement.ALL_GROUPS || groups.length != 0) {
                    throw new ConfigurationException("discoveryManager entry must be configured  with no groups.");
                }
            } else {
                throw new ConfigurationException("discoveryManager entry must implement DiscoveryGroupManagement");
            }
            if (this.lookupDiscMgr instanceof DiscoveryLocatorManagement) {
                LookupLocator[] locs = ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).getLocators();
                if (locs != null && locs.length != 0) {
                    throw new ConfigurationException("discoveryManager entry must be configured with no locators");
                }
            } else {
                throw new ConfigurationException("discoveryManager entry must implement DiscoveryLocatorManagement");
            }
            ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).setGroups(this.lookupGroups);
            ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).setLocators(this.lookupLocators);
        }
        catch (NoSuchEntryException e) {
            this.lookupDiscMgr = new LookupDiscoveryManager(this.lookupGroups, this.lookupLocators, null, config);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Discovery manager is: {0}", this.lookupDiscMgr);
        }
        ServiceID lookupID = new ServiceID(this.serviceID.getMostSignificantBits(), this.serviceID.getLeastSignificantBits());
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Creating JoinManager.");
        }
        this.joiner = new JoinManager((Object)this.mailboxProxy, this.lookupAttrs, lookupID, this.lookupDiscMgr, null, config);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "doInit");
        }
        this.readyState.ready();
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Mercury started: {0}", this);
        }
    }

    private void rebuildTransientState(ProxyPreparer recoveredListenerPreparer) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "rebuildTransientState", recoveredListenerPreparer);
        }
        if (!this.regByID.isEmpty()) {
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Rebuilding transient state ...");
            }
            Collection regs = this.regByID.values();
            Iterator iter2 = regs.iterator();
            ServiceRegistration reg = null;
            Uuid uuid = null;
            EventLogIterator eli = null;
            while (iter2.hasNext()) {
                reg = (ServiceRegistration)iter2.next();
                uuid = reg.getCookie();
                if (recoveryLogger.isLoggable(Level.FINEST)) {
                    recoveryLogger.log(Level.FINEST, "Checking reg : {0}", reg);
                }
                if (MailboxImpl.ensureCurrent(reg)) {
                    if (recoveryLogger.isLoggable(Level.FINEST)) {
                        recoveryLogger.log(Level.FINEST, "Restoring reg transient state ...");
                    }
                    try {
                        reg.restoreTransientState(recoveredListenerPreparer);
                    }
                    catch (Exception e) {
                        if (recoveryLogger.isLoggable(Levels.HANDLED)) {
                            recoveryLogger.log(Levels.HANDLED, "Trouble restoring reg transient state", e);
                        }
                        try {
                            reg.setEventTarget(null);
                        }
                        catch (IOException ioe) {
                            throw new AssertionError((Object)("Setting a null target threw an exception: " + ioe));
                        }
                    }
                    if (recoveryLogger.isLoggable(Level.FINEST)) {
                        recoveryLogger.log(Level.FINEST, "Reinitializing iterator ...");
                    }
                    eli = this.persistent ? this.eventLogFactory.iterator(uuid, MailboxImpl.getEventLogPath(this.persistenceDirectory, uuid)) : this.eventLogFactory.iterator(uuid);
                    reg.setIterator(eli);
                    if (recoveryLogger.isLoggable(Level.FINEST)) {
                        recoveryLogger.log(Level.FINEST, "Adding registration to expiration watch list");
                    }
                    this.regByExpiration.put(reg, reg);
                    if (!reg.hasEventTarget() || this.pendingReg.contains(uuid)) continue;
                    if (recoveryLogger.isLoggable(Level.FINEST)) {
                        recoveryLogger.log(Level.FINEST, "Adding registration to pending task list");
                    }
                    this.pendingReg.add(uuid);
                    continue;
                }
                if (recoveryLogger.isLoggable(Level.FINEST)) {
                    recoveryLogger.log(Level.FINEST, "Removing expired registration: ");
                }
                iter2.remove();
                this.removeRegistration(uuid, reg, true);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "rebuildTransientState");
        }
    }

    private void cleanup() {
        block31: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                if (operationsLogger.isLoggable(Level.FINER)) {
                                    operationsLogger.entering(mailboxSourceClass, "cleanup");
                                }
                                if (this.serverStub != null) {
                                    try {
                                        if (initLogger.isLoggable(Level.FINEST)) {
                                            initLogger.log(Level.FINEST, "Unexporting service");
                                        }
                                        this.exporter.unexport(true);
                                    }
                                    catch (Throwable t) {
                                        if (!initLogger.isLoggable(Levels.HANDLED)) break block26;
                                        initLogger.log(Levels.HANDLED, "Trouble unexporting service", t);
                                    }
                                }
                            }
                            if (this.joiner != null) {
                                try {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Terminating join manager");
                                    }
                                    this.joiner.terminate();
                                }
                                catch (Throwable t) {
                                    if (!initLogger.isLoggable(Levels.HANDLED)) break block27;
                                    initLogger.log(Levels.HANDLED, "Trouble terminating join manager", t);
                                }
                            }
                        }
                        if (this.lookupDiscMgr != null) {
                            try {
                                if (initLogger.isLoggable(Level.FINEST)) {
                                    initLogger.log(Level.FINEST, "Terminating lookup discovery manager");
                                }
                                this.lookupDiscMgr.terminate();
                            }
                            catch (Throwable t) {
                                if (!initLogger.isLoggable(Levels.HANDLED)) break block28;
                                initLogger.log(Levels.HANDLED, "Trouble terminating lookup discovery manager", t);
                            }
                        }
                    }
                    if (this.notifier != null) {
                        try {
                            if (initLogger.isLoggable(Level.FINEST)) {
                                initLogger.log(Level.FINEST, "Interrupting notifier");
                            }
                            this.notifier.interrupt();
                        }
                        catch (Throwable t) {
                            if (!initLogger.isLoggable(Levels.HANDLED)) break block29;
                            initLogger.log(Levels.HANDLED, "Trouble interrupting notifier", t);
                        }
                    }
                }
                if (this.expirer != null) {
                    try {
                        if (initLogger.isLoggable(Level.FINEST)) {
                            initLogger.log(Level.FINEST, "Interrupting expirer");
                        }
                        this.expirer.interrupt();
                    }
                    catch (Throwable t) {
                        if (!initLogger.isLoggable(Levels.HANDLED)) break block30;
                        initLogger.log(Levels.HANDLED, "Trouble interrupting expirer", t);
                    }
                }
            }
            if (this.snapshotter != null) {
                try {
                    if (initLogger.isLoggable(Level.FINEST)) {
                        initLogger.log(Level.FINEST, "Interrupting snapshotter");
                    }
                    this.snapshotter.interrupt();
                }
                catch (Throwable t) {
                    if (!initLogger.isLoggable(Levels.HANDLED)) break block31;
                    initLogger.log(Levels.HANDLED, "Trouble interrupting snapshotter", t);
                }
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "cleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailboxRegistration register(long leaseDuration) throws RemoteException, LeaseDeniedException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Registration registration = this.registerDo(leaseDuration);
            return registration;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailboxPullRegistration pullRegister(long leaseDuration) throws RemoteException, LeaseDeniedException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Registration registration = this.registerDo(leaseDuration);
            return registration;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableDelivery(Uuid uuid, RemoteEventListener target) throws RemoteException, ThrowThis {
        this.readyState.check();
        RemoteEventListener preparedTarget = null;
        if (target == null) {
            this.disableDelivery(uuid);
            return;
        }
        try {
            preparedTarget = (RemoteEventListener)this.listenerPreparer.prepareProxy(target);
            if (deliveryLogger.isLoggable(Level.FINEST)) {
                deliveryLogger.log(Level.FINEST, "prepared listener: {0}", preparedTarget);
            }
        }
        catch (RemoteException e) {
            throw new ThrowThis(e);
        }
        this.concurrentObj.writeLock();
        try {
            this.enableDeliveryDo(uuid, preparedTarget);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableDelivery(Uuid uuid) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.disableDeliveryDo(uuid);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEventIteratorData getRemoteEvents(Uuid uuid) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            RemoteEventIteratorData remoteEventIteratorData = this.getRemoteEventsDo(uuid);
            return remoteEventIteratorData;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getNextBatch(Uuid regId, Uuid iterId, long timeout, Object lastEventCookie) throws InvalidIteratorException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Collection collection = this.getNextBatchDo(regId, iterId, timeout, lastEventCookie);
            return collection;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnknownEvents(Uuid uuid, Collection unknownEvents) throws RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.addUnknownEventsDo(uuid, unknownEvents);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Uuid registrationID, RemoteEvent theEvent) throws UnknownEventException, RemoteException, ThrowThis {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.notifyDo(registrationID, theEvent);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
        this.readyState.check();
        this.concurrentObj.priorityWriteLock();
        try {
            long l = this.renewDo(cookie, extension);
            return l;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Uuid cookie) throws UnknownLeaseException, RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.cancelDo(cookie);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extension) throws RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Landlord.RenewResults renewResults = this.renewAllDo(cookies, extension);
            return renewResults;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map cancelAll(Uuid[] cookies) throws RemoteException {
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            Map map = this.cancelAllDo(cookies);
            return map;
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "destroy");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            ServiceRegistration[] regs = this.regByID.values().toArray(new ServiceRegistration[this.regByID.size()]);
            if (adminLogger.isLoggable(Level.FINEST)) {
                adminLogger.log(Level.FINEST, "Notifying {0} possible registrations", this.regByID.size());
            }
            for (int i = 0; i < regs.length; ++i) {
                this.removeRegistration(regs[i].getCookie(), regs[i]);
                this.concurrentObj.waiterNotify(regs[i].getIteratorNotifier());
                if (!adminLogger.isLoggable(Level.FINEST)) continue;
                adminLogger.log(Level.FINEST, "Iterator for reg {0} notified", regs[i]);
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        new DestroyThread().start();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(mailboxSourceClass, "getLookupAttributes");
            }
            Entry[] entryArray = this.lookupAttrs;
            return entryArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joiner.addAttributes(attrSets, true);
            this.lookupAttrs = this.joiner.getAttributes();
            this.addLogRecord(new AttrsAddedLogObj(attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addLookupAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "modifyLookupAttributes");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            this.joiner.modifyAttributes(attrSetTemplates, attrSets, true);
            this.lookupAttrs = this.joiner.getAttributes();
            this.addLogRecord(new AttrsModifiedLogObj(attrSetTemplates, attrSets));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "modifyLookupAttributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLookupGroups() throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(mailboxSourceClass, "getLookupGroups");
            }
            String[] stringArray = this.lookupGroups;
            return stringArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).addGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addLookupGroups");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "removeLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).removeGroups(groups);
            this.lookupGroups = ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "removeLookupGroups");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "setLookupGroups");
        }
        this.readyState.check();
        this.concurrentObj.writeLock();
        try {
            try {
                ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).setGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = ((DiscoveryGroupManagement)((Object)this.lookupDiscMgr)).getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "setLookupGroups");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getLookupLocators");
        }
        this.readyState.check();
        this.concurrentObj.readLock();
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(mailboxSourceClass, "getLookupLocators");
            }
            LookupLocator[] lookupLocatorArray = this.lookupLocators;
            return lookupLocatorArray;
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).addLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addLookupLocators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "removeLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).removeLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "removeLookupLocators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "setLookupLocators");
        }
        this.readyState.check();
        MailboxImpl.prepareNewLocators(locatorToJoinPreparer, locators);
        this.concurrentObj.writeLock();
        try {
            ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).setLocators(locators);
            this.lookupLocators = ((DiscoveryLocatorManagement)((Object)this.lookupDiscMgr)).getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "setLookupLocators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnknownEvent(Uuid regID, EventID evid) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addUnknownEvent", new Object[]{regID, evid});
        }
        this.concurrentObj.writeLock();
        try {
            this.addUnknownEventDo(regID, evid);
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addUnknownEvent");
        }
    }

    private void addUnknownEventDo(Uuid regID, EventID evid) {
        ServiceRegistration reg;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addUnknownEventDo", new Object[]{regID, evid});
        }
        if ((reg = (ServiceRegistration)this.regByID.get(regID)) == null || !MailboxImpl.ensureCurrent(reg)) {
            return;
        }
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "Using reg: {0} ", reg);
        }
        reg.getUnknownEvents().put(evid, evid);
        this.addLogRecord(new UnknownEventExceptionLogObj(regID, evid));
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "UnknownEvents size: {0}", reg.getUnknownEvents().size());
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addUnknownEventDo");
        }
    }

    private ServiceRegistration getServiceRegistration(Uuid regID) throws ThrowThis {
        ServiceRegistration reg;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getServiceRegistration", regID);
        }
        if ((reg = (ServiceRegistration)this.regByID.get(regID)) == null) {
            throw new ThrowThis(new NoSuchObjectException("Not managing requested registration object"));
        }
        if (!MailboxImpl.ensureCurrent(reg)) {
            throw new ThrowThis(new NoSuchObjectException("Requested registration objecthas expired"));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getServiceRegistration", reg);
        }
        return reg;
    }

    private void removeRegistration(Uuid regID, ServiceRegistration reg) {
        this.removeRegistration(regID, reg, false);
    }

    private void removeRegistration(Uuid regID, ServiceRegistration reg, boolean initializing) {
        NotifyTask task;
        boolean exists;
        block10: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(mailboxSourceClass, "removeRegistration", new Object[]{regID, reg, initializing});
            }
            if (!initializing) {
                this.regByID.remove(regID);
            }
            this.regByExpiration.remove(reg);
            exists = this.pendingReg.remove(regID);
            task = (NotifyTask)this.activeReg.remove(regID);
            if (task != null) {
                task.cancel();
                if (deliveryLogger.isLoggable(Level.FINEST)) {
                    deliveryLogger.log(Level.FINEST, "Cancelling active notification task for {0}", regID);
                }
            }
            try {
                EventLogIterator iter2;
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Removing logs for {0}", reg);
                }
                if ((iter2 = reg.iterator()) != null) {
                    iter2.destroy();
                }
            }
            catch (IOException ioe) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block10;
                persistenceLogger.log(Levels.HANDLED, "Trouble removing logs", ioe);
            }
        }
        if (exists && task != null && leaseLogger.isLoggable(Level.SEVERE)) {
            leaseLogger.log(Level.SEVERE, "ERROR: Registration was found on both the active and pending lists");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "removeRegistration");
        }
    }

    private static File getEventLogPath(String parent, Uuid uuid) {
        return new File(parent, uuid.toString());
    }

    private Registration registerDo(long duration) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "registerDo", duration);
        }
        if (duration < 1L && duration != -1L) {
            throw new IllegalArgumentException("Duration must be a positive value");
        }
        Uuid uuid = UuidFactory.generate();
        EventLogIterator iter2 = this.persistent ? this.eventLogFactory.iterator(uuid, MailboxImpl.getEventLogPath(this.persistenceDirectory, uuid)) : this.eventLogFactory.iterator(uuid);
        ServiceRegistration reg = new ServiceRegistration(uuid, iter2);
        LandlordLease l = null;
        try {
            LeasePeriodPolicy.Result r = this.leasePolicy.grant(reg, duration);
            reg.setExpiration(r.expiration);
            l = this.leaseFactory.newLease(uuid, r.expiration);
        }
        catch (LeaseDeniedException lde) {
            throw new InternalMailboxException("Registration lease was denied", lde);
        }
        this.addRegistration(reg);
        this.addLogRecord(new RegistrationLogObj(reg));
        if (reg.getExpiration() < this.minRegExpiration) {
            this.minRegExpiration = reg.getExpiration();
            if (expirationLogger.isLoggable(Level.FINEST)) {
                expirationLogger.log(Level.FINEST, "Notifying expiration thread");
            }
            this.concurrentObj.waiterNotify(this.expirationNotifier);
        }
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Generated new lease for: {0}", reg);
            reg.dumpInfo(leaseLogger);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "registerDo");
        }
        return Registration.create(uuid, this.serverStub, l);
    }

    private void addRegistration(ServiceRegistration reg) {
        this.regByID.put(reg.getCookie(), reg);
        this.regByExpiration.put(reg, reg);
    }

    private long renewDo(Uuid cookie, long extension) throws UnknownLeaseException, LeaseDeniedException {
        LeasePeriodPolicy.Result r;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "renewDo", new Object[]{cookie, extension});
        }
        if (extension < 1L && extension != -1L) {
            throw new IllegalArgumentException("Duration must be a positive value");
        }
        ServiceRegistration reg = null;
        long expiration = 0L;
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Attempting to renew {0}''s lease for {1} sec", new Object[]{cookie, extension / 1000L});
        }
        try {
            reg = this.getServiceRegistration(cookie);
            r = this.leasePolicy.renew(reg, extension);
            reg.setExpiration(r.expiration);
            this.addLogRecord(new RegistrationRenewedLogObj(cookie, reg.getExpiration()));
            this.regByExpiration.remove(reg);
            this.regByExpiration.put(reg, reg);
        }
        catch (ThrowThis tt) {
            if (leaseLogger.isLoggable(Level.FINEST)) {
                leaseLogger.log(Level.FINEST, "Lease for {0} was NOT renewed", cookie);
            }
            throw new UnknownLeaseException("Not managing requested lease");
        }
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Lease for {0} was renewed", cookie);
            reg.dumpInfo(leaseLogger);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "renewDo", r.duration);
        }
        return r.duration;
    }

    private void cancelDo(Uuid cookie) throws UnknownLeaseException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "cancelDo", cookie);
        }
        ServiceRegistration reg = null;
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Attempting to cancel lease for: {0}", cookie);
        }
        try {
            reg = this.getServiceRegistration(cookie);
            this.removeRegistration(cookie, reg);
            this.addLogRecord(new RegistrationCancelledLogObj(cookie));
            if (reg.getExpiration() == this.minRegExpiration) {
                if (expirationLogger.isLoggable(Level.FINEST)) {
                    expirationLogger.log(Level.FINEST, "Notifying expiration thread");
                }
                this.concurrentObj.waiterNotify(this.expirationNotifier);
            }
            this.concurrentObj.waiterNotify(reg.getIteratorNotifier());
            if (expirationLogger.isLoggable(Level.FINEST)) {
                expirationLogger.log(Level.FINEST, "Iterator notified");
            }
        }
        catch (ThrowThis tt) {
            throw new UnknownLeaseException("Not managing requested lease");
        }
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Lease cancelled for: {0}", cookie);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "cancelDo");
        }
    }

    private Landlord.RenewResults renewAllDo(Uuid[] cookie, long[] extension) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "renewAllDo");
        }
        int count = cookie.length;
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Attempting to renew a batch of {0} leases", count);
        }
        Landlord.RenewResults rslt = LandlordUtil.renewAll(this.localLandlord, cookie, extension);
        if (rslt.denied == null) {
            if (leaseLogger.isLoggable(Level.FINEST)) {
                leaseLogger.log(Level.FINEST, "Batch renew totally successful");
            }
        } else if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Batch renew contained exceptions");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "renewAllDo");
        }
        return rslt;
    }

    private Map cancelAllDo(Uuid[] cookie) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "cancelAllDo");
        }
        int count = cookie.length;
        if (leaseLogger.isLoggable(Level.FINEST)) {
            leaseLogger.log(Level.FINEST, "Attempting to cancel a batch of {0} leases", count);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "cancelAllDo");
        }
        return LandlordUtil.cancelAll(this.localLandlord, cookie);
    }

    private void enableDeliveryDo(Uuid uuid, RemoteEventListener preparedTarget) throws ThrowThis {
        Uuid id;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "enableDeliveryDo", new Object[]{uuid, preparedTarget});
        }
        if (preparedTarget instanceof ListenerProxy && this.regByID.get(id = ((ListenerProxy)preparedTarget).getReferentUuid()) != null) {
            if (deliveryLogger.isLoggable(Level.FINEST)) {
                deliveryLogger.log(Level.FINEST, "Disallowing resubmission of one of this service''s own listeners: {0}", id);
            }
            throw new IllegalArgumentException("Cannot submit a listener that was provided by the same EventMailbox service");
        }
        this.enableRegistration(uuid, preparedTarget);
        this.addLogRecord(new RegistrationEnabledLogObj(uuid, preparedTarget));
        this.concurrentObj.waiterNotify(this.eventNotifier);
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        this.concurrentObj.waiterNotify(reg.getIteratorNotifier());
        if (expirationLogger.isLoggable(Level.FINEST)) {
            expirationLogger.log(Level.FINEST, "Iterator notified");
        }
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "Enabling delivery for {0} to {1}", new Object[]{uuid, preparedTarget});
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "enableDeliveryDo");
        }
    }

    private void enableRegistration(Uuid uuid, RemoteEventListener preparedTarget) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        try {
            reg.setEventTarget(preparedTarget);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Passed a listener that could not be serialized");
        }
        this.disableRegistrationIterator(uuid);
        reg.getUnknownEvents().clear();
        if (!this.pendingReg.contains(uuid) && !this.activeReg.containsKey(uuid)) {
            this.pendingReg.add(uuid);
        }
    }

    private void disableDeliveryDo(Uuid uuid) throws ThrowThis {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "disableDeliveryDo", uuid);
        }
        this.disableRegistration(uuid);
        this.addLogRecord(new RegistrationDisabledLogObj(uuid));
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "disableDeliveryDo");
        }
    }

    private void disableRegistration(Uuid uuid) throws ThrowThis {
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "Attempting to disable delivery for {0}", uuid);
        }
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        boolean wasEnabled = reg.hasEventTarget();
        try {
            reg.setEventTarget(null);
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Setting a null target threw an exception: " + ioe));
        }
        boolean inPending = this.pendingReg.remove(uuid);
        NotifyTask task = (NotifyTask)this.activeReg.remove(uuid);
        if (task != null) {
            task.cancel();
            if (deliveryLogger.isLoggable(Level.FINEST)) {
                deliveryLogger.log(Level.FINEST, "Cancelling active notification task for {0}", uuid);
            }
        }
        if (wasEnabled && !inPending && task == null && !this.inRecovery && deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "*** Registration was not found on the active or pending lists");
        }
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "Disabled delivery for {0}", uuid);
        }
    }

    private void enableRegistrationIterator(Uuid regId, Uuid iterId) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        reg.setRemoteEventIteratorID(iterId);
        this.disableRegistration(regId);
        reg.getUnknownEvents().clear();
    }

    private void disableRegistrationIterator(Uuid regId) throws ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        reg.setRemoteEventIteratorID(null);
    }

    private void addUnknownEventsDo(Uuid uuid, Collection unknownEvents) throws ThrowThis {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "addUnknownEventsDo", new Object[]{uuid, unknownEvents});
        }
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        for (RemoteEvent ev : unknownEvents) {
            this.addUnknownEventDo(uuid, new EventID(ev));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addUnknownEventsDo");
        }
    }

    private RemoteEventIteratorData getRemoteEventsDo(Uuid uuid) throws ThrowThis {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getRemoteEventsDo", new Object[]{uuid});
        }
        ArrayList<RemoteEventData> events = new ArrayList<RemoteEventData>();
        ServiceRegistration reg = this.getServiceRegistration(uuid);
        Uuid iteratorId = UuidFactory.generate();
        if (deliveryLogger.isLoggable(Level.FINEST)) {
            deliveryLogger.log(Level.FINEST, "Generated remote event iterator id {0}", iteratorId);
        }
        this.addLogRecord(new RegistrationIteratorEnabledLogObj(uuid, iteratorId));
        this.enableRegistrationIterator(uuid, iteratorId);
        try {
            EventLogIterator eli = reg.iterator();
            if (eli.hasNext()) {
                RemoteEventData[] evts = eli.readAhead(Integer.MAX_VALUE);
                RemoteEvent evt = null;
                for (int i = 0; i < evts.length; ++i) {
                    evt = evts[i].getRemoteEvent();
                    if (evt == null || reg.getUnknownEvents().containsKey(new EventID(evt))) continue;
                    events.add(evts[i]);
                }
            }
        }
        catch (IOException ioe) {
        }
        catch (NoSuchElementException nse) {
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        this.concurrentObj.waiterNotify(reg.getIteratorNotifier());
        if (expirationLogger.isLoggable(Level.FINEST)) {
            expirationLogger.log(Level.FINEST, "Iterator notified");
        }
        events.trimToSize();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getRemoteEventsDo", events);
        }
        return new RemoteEventIteratorData(iteratorId, events);
    }

    private Collection getNextBatchDo(Uuid regId, Uuid iterId, long timeout, Object lastEventCookie) throws InvalidIteratorException, ThrowThis {
        ArrayList<RemoteEventData> events;
        block21: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(mailboxSourceClass, "getNextBatchDo", new Object[]{regId, iterId, timeout, lastEventCookie});
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout value must non-negative");
            }
            long endTime = System.currentTimeMillis() + timeout;
            if (endTime < 0L) {
                endTime = Long.MAX_VALUE;
            }
            events = new ArrayList<RemoteEventData>();
            this.validateIterator(regId, iterId);
            try {
                ServiceRegistration reg = this.getServiceRegistration(regId);
                EventLogIterator eli = reg.iterator();
                if (operationsLogger.isLoggable(Level.FINEST)) {
                    operationsLogger.log(Level.FINEST, "Moving past lastEventCookie {0}", lastEventCookie);
                }
                if (lastEventCookie != null) {
                    eli.moveAhead(lastEventCookie);
                }
                do {
                    if (eli.hasNext()) {
                        RemoteEventData[] evts = eli.readAhead(Integer.MAX_VALUE);
                        RemoteEvent evt = null;
                        for (int i = 0; i < evts.length; ++i) {
                            try {
                                evt = evts[i].getRemoteEvent();
                                if (evt != null && !reg.getUnknownEvents().containsKey(new EventID(evt))) {
                                    events.add(evts[i]);
                                    continue;
                                }
                                if (!deliveryLogger.isLoggable(Level.FINEST)) continue;
                                deliveryLogger.log(Level.FINEST, "Problem with unknown or unrecoverable RemoteEvent {0} -- skipping", evt);
                                continue;
                            }
                            catch (ClassNotFoundException cnfe) {
                                if (!deliveryLogger.isLoggable(Levels.HANDLED)) continue;
                                deliveryLogger.log(Levels.HANDLED, "Problem accessing RemoteEvent -- skipping", cnfe);
                            }
                        }
                    }
                    long waitFor = endTime - System.currentTimeMillis();
                    if (events.size() != 0 || waitFor <= 0L) continue;
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "No available events. Attempting to wait for " + waitFor + " milliseconds.");
                    }
                    try {
                        this.concurrentObj.writerWait(reg.getIteratorNotifier(), waitFor);
                    }
                    catch (ReadersWriter.ConcurrentLockException cle) {
                        return new ArrayList(0);
                    }
                    this.validateIterator(regId, iterId);
                } while (System.currentTimeMillis() < endTime && events.size() == 0);
            }
            catch (IOException ioe) {
                if (deliveryLogger.isLoggable(Levels.HANDLED)) {
                    deliveryLogger.log(Levels.HANDLED, "Trouble accessing event state - skipping", ioe);
                }
            }
            catch (NoSuchElementException nse) {
                if (deliveryLogger.isLoggable(Level.WARNING)) {
                    deliveryLogger.log(Level.WARNING, "Invalid iterator access", nse);
                }
                throw new InvalidIteratorException("Invalid iterator access: " + nse);
            }
            catch (ClassNotFoundException cnfe) {
                if (!deliveryLogger.isLoggable(Levels.HANDLED)) break block21;
                deliveryLogger.log(Levels.HANDLED, "Trouble accessing remote event(s) - skipping", cnfe);
            }
        }
        events.trimToSize();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getNextBatchDo", events);
        }
        return events;
    }

    private void validateIterator(Uuid regId, Uuid iterId) throws InvalidIteratorException, ThrowThis {
        ServiceRegistration reg = this.getServiceRegistration(regId);
        Uuid validIterId = reg.getRemoteEventIteratorID();
        if (!iterId.equals(validIterId)) {
            if (deliveryLogger.isLoggable(Level.FINEST)) {
                deliveryLogger.log(Level.FINEST, "Provided iterator id " + iterId + " doesn't match current valid iterator id " + validIterId);
            }
            throw new InvalidIteratorException("Iterator is not valid");
        }
    }

    private void notifyDo(Uuid registrationID, RemoteEvent theEvent) throws UnknownEventException, RemoteException, ThrowThis {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "notifyDo", new Object[]{registrationID, theEvent});
        }
        if (receiveLogger.isLoggable(Level.FINEST)) {
            receiveLogger.log(Level.FINEST, "RemoteEvent {0}, ID {1}, Seq# {2}", new Object[]{theEvent, theEvent.getID(), theEvent.getSequenceNumber()});
        }
        ServiceRegistration reg = this.getServiceRegistration(registrationID);
        EventID evtid = new EventID(theEvent);
        if (reg.getUnknownEvents().containsKey(evtid)) {
            if (receiveLogger.isLoggable(Level.FINEST)) {
                receiveLogger.log(Level.FINEST, "Discarding event -- it is unknown");
            }
            throw new UnknownEventException();
        }
        try {
            reg.iterator().add(theEvent);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (reg.hasEventTarget()) {
            this.concurrentObj.waiterNotify(this.eventNotifier);
            if (receiveLogger.isLoggable(Level.FINEST)) {
                receiveLogger.log(Level.FINEST, "Notifier notified");
            }
        } else if (reg.getRemoteEventIteratorID() != null) {
            this.concurrentObj.waiterNotify(reg.getIteratorNotifier());
            if (receiveLogger.isLoggable(Level.FINEST)) {
                receiveLogger.log(Level.FINEST, "Iterator notified");
            }
        } else if (receiveLogger.isLoggable(Level.FINEST)) {
            receiveLogger.log(Level.FINEST, "Notification skipped");
        }
        if (receiveLogger.isLoggable(Level.FINEST)) {
            receiveLogger.log(Level.FINEST, "");
            reg.dumpInfo(receiveLogger);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "notifyDo");
        }
    }

    private static MarshalledObject[] marshalAttributes(Entry[] attrs) {
        if (attrs == null) {
            return new MarshalledObject[0];
        }
        ArrayList<MarshalledObject<Entry>> marshalledAttrs = new ArrayList<MarshalledObject<Entry>>();
        for (int i = 0; i < attrs.length; ++i) {
            try {
                marshalledAttrs.add(new MarshalledObject<Entry>(attrs[i]));
                continue;
            }
            catch (Throwable e) {
                if (!recoveryLogger.isLoggable(Levels.HANDLED)) continue;
                recoveryLogger.log(Levels.HANDLED, "Error while marshalling attribute[{0}]: {1}", new Object[]{i, attrs[i]});
                recoveryLogger.log(Levels.HANDLED, "Marshalling exception", e);
            }
        }
        return marshalledAttrs.toArray(new MarshalledObject[marshalledAttrs.size()]);
    }

    private static Entry[] unmarshalAttributes(MarshalledObject[] marshalledAttrs) {
        if (marshalledAttrs == null) {
            return new Entry[0];
        }
        ArrayList<Entry> attrs = new ArrayList<Entry>();
        for (int i = 0; i < marshalledAttrs.length; ++i) {
            try {
                attrs.add((Entry)marshalledAttrs[i].get());
                continue;
            }
            catch (Throwable e) {
                if (!recoveryLogger.isLoggable(Levels.HANDLED)) continue;
                recoveryLogger.log(Levels.HANDLED, "Error while unmarshalling attribute[{0}]: {1}", new Object[]{i, marshalledAttrs[i]});
                recoveryLogger.log(Levels.HANDLED, "Exception was", e);
            }
        }
        return attrs.toArray(new Entry[attrs.size()]);
    }

    private void addLogRecord(LogRecord rec) {
        block8: {
            if (this.log == null) {
                return;
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(mailboxSourceClass, "addLogRecord", rec);
            }
            try {
                if (recoveryLogger.isLoggable(Level.FINEST)) {
                    recoveryLogger.log(Level.FINEST, "Adding log record: {0}", rec);
                }
                this.log.update(rec, true);
                if (++this.logFileSize >= this.logToSnapshotThreshold) {
                    if (recoveryLogger.isLoggable(Level.FINEST)) {
                        recoveryLogger.log(Level.FINEST, "Notifying snapshot thread");
                    }
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
            catch (Exception e) {
                if (!recoveryLogger.isLoggable(Levels.HANDLED)) break block8;
                recoveryLogger.log(Levels.HANDLED, "Exception adding LogRecord", e);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "addLogRecord");
        }
    }

    private void takeSnapshot(OutputStream out) throws IOException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "takeSnapshot", out);
        }
        if (recoveryLogger.isLoggable(Level.FINEST)) {
            recoveryLogger.log(Level.FINEST, "Taking snapshot ...");
        }
        ObjectOutputStream stream = new ObjectOutputStream(out);
        stream.writeUTF(mailboxSourceClass);
        stream.writeInt(2);
        stream.writeObject(this.serviceID);
        stream.writeObject(this.lookupGroups);
        stream.writeObject(this.lookupLocators);
        stream.writeObject(MailboxImpl.marshalAttributes(this.lookupAttrs));
        stream.writeObject(this.regByID);
        stream.flush();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "takeSnapshot");
        }
    }

    private void recoverSnapshot(InputStream in) throws IOException, ClassNotFoundException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "recoverSnapshot", in);
        }
        if (recoveryLogger.isLoggable(Level.FINEST)) {
            recoveryLogger.log(Level.FINEST, "Recovering snapshot ...");
        }
        boolean i = false;
        ObjectInputStream stream = new ObjectInputStream(in);
        if (!mailboxSourceClass.equals(stream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (stream.readInt() != 2) {
            throw new IOException("wrong log format version");
        }
        this.serviceID = (Uuid)stream.readObject();
        this.lookupGroups = (String[])stream.readObject();
        this.lookupLocators = (LookupLocator[])stream.readObject();
        MarshalledObject[] marshalledAttrs = (MarshalledObject[])stream.readObject();
        this.lookupAttrs = MailboxImpl.unmarshalAttributes(marshalledAttrs);
        this.regByID = (HashMap)stream.readObject();
        if (recoveryLogger.isLoggable(Level.FINEST)) {
            recoveryLogger.log(Level.FINEST, "serviceID: {0}", this.serviceID);
            recoveryLogger.log(Level.FINEST, "lookupGroups:");
            MailboxImpl.dumpGroups(this.lookupGroups, recoveryLogger, Level.FINEST);
            recoveryLogger.log(Level.FINEST, "lookupLocators:");
            MailboxImpl.dumpLocators(this.lookupLocators, recoveryLogger, Level.FINEST);
            recoveryLogger.log(Level.FINEST, "lookupAttributes:");
            MailboxImpl.dumpAttrs(this.lookupAttrs, recoveryLogger, Level.FINEST);
            Collection regs = this.regByID.values();
            for (ServiceRegistration reg : regs) {
                reg.dumpInfo(recoveryLogger);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "recoverSnapshot");
        }
    }

    private static void dumpGroups(String[] grps, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (grps == null) {
                logger.log(level, "<ALL_GROUPS>");
            } else if (grps.length == 0) {
                logger.log(level, "<NO_GROUPS>");
            } else {
                String[] dups = new String[grps.length];
                for (int i = 0; i < grps.length; ++i) {
                    dups[i] = "".equals(grps[i]) ? "<PUBLIC_GROUP>" : grps[i];
                }
                logger.log(level, "Groups: {0}", Arrays.asList(dups));
            }
        }
    }

    private static void dumpLocators(LookupLocator[] locs, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (locs == null) {
                logger.log(level, "<null>");
            } else if (locs.length == 0) {
                logger.log(level, "<EMPTY>");
            } else {
                logger.log(level, "Locators: {0}", Arrays.asList(locs));
            }
        }
    }

    private static void dumpAttrs(Entry[] attrs, Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            if (attrs == null) {
                logger.log(level, "<null>");
            } else if (attrs.length == 0) {
                logger.log(level, "<EMPTY>");
            } else {
                logger.log(level, "Attributes: {0}", Arrays.asList(attrs));
            }
        }
    }

    protected void initFailed(Throwable e) throws Exception {
        initLogger.log(Level.SEVERE, "Mercury failed to initialize", e);
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        IllegalStateException ise = new IllegalStateException(e.getMessage());
        ise.initCause(e);
        throw ise;
    }

    private static void prepareNewLocators(ProxyPreparer preparer, LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "prepareNewLocators");
        }
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (LookupLocator)preparer.prepareProxy(locators[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "prepareNewLocators");
        }
    }

    private static LookupLocator[] prepareExistingLocators(ProxyPreparer preparer, LookupLocator[] lookupLocators) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "prepareExistingLocators");
        }
        ArrayList<Object> locsList = new ArrayList<Object>(lookupLocators.length);
        for (int i = 0; i < lookupLocators.length; ++i) {
            try {
                locsList.add(preparer.prepareProxy(lookupLocators[i]));
                continue;
            }
            catch (Exception e) {
                if (!deliveryLogger.isLoggable(Level.INFO)) continue;
                deliveryLogger.log(Level.INFO, "Failure preparing recovered lookup locator: {0}", lookupLocators[i]);
                deliveryLogger.log(Level.INFO, "Associated exception is: ", e);
            }
        }
        lookupLocators = locsList.toArray(new LookupLocator[locsList.size()]);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "prepareExistingLocators");
        }
        return lookupLocators;
    }

    @Override
    public TrustVerifier getProxyVerifier() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(mailboxSourceClass, "getProxyVerifier");
        }
        this.readyState.check();
        if (!(this.mailboxProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(mailboxSourceClass, "getProxyVerifier");
        }
        return new ProxyVerifier(this.serverStub, this.serviceID);
    }

    private static boolean ensureCurrent(LeasedResource resource) {
        return resource.getExpiration() > System.currentTimeMillis();
    }

    static /* synthetic */ String[] access$4502(MailboxImpl x0, String[] x1) {
        x0.lookupGroups = x1;
        return x1;
    }

    static /* synthetic */ LookupLocator[] access$4802(MailboxImpl x0, LookupLocator[] x1) {
        x0.lookupLocators = x1;
        return x1;
    }

    static /* synthetic */ Entry[] access$5202(MailboxImpl x0, Entry[] x1) {
        x0.lookupAttrs = x1;
        return x1;
    }

    private class SnapshotThread
    extends InterruptedStatusThread {
        public SnapshotThread() {
            super("SnapshotThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.entering(snapshotThreadSourceClass, "run");
                }
                try {
                    MailboxImpl.this.concurrentObj.readLock();
                }
                catch (ReadersWriter.ConcurrentLockException e) {
                    return;
                }
                while (true) {
                    if (this.hasBeenInterrupted()) break block16;
                    MailboxImpl.this.concurrentObj.readerWait(MailboxImpl.this.snapshotNotifier, Long.MAX_VALUE);
                    try {
                        MailboxImpl.this.log.snapshot();
                        MailboxImpl.this.logFileSize = 0;
                        continue;
                    }
                    catch (InterruptedIOException e) {
                        MailboxImpl.this.concurrentObj.readUnlock();
                        return;
                    }
                    catch (Exception e) {
                        block17: {
                            if (!(e instanceof LogException) || !(((LogException)e).detail instanceof InterruptedIOException)) break block17;
                            MailboxImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                        try {
                            if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                            persistenceLogger.log(Levels.HANDLED, "Exception taking snapshot", e);
                            continue;
                        }
                        catch (ReadersWriter.ConcurrentLockException e2) {
                            MailboxImpl.this.concurrentObj.readUnlock();
                            return;
                        }
                    }
                    break;
                }
                finally {
                    MailboxImpl.this.concurrentObj.readUnlock();
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(snapshotThreadSourceClass, "run");
            }
        }
    }

    private class LocalLogHandler
    extends LogHandler {
        @Override
        public void snapshot(OutputStream out) throws IOException {
            MailboxImpl.this.takeSnapshot(out);
        }

        @Override
        public void recover(InputStream in) throws IOException, ClassNotFoundException {
            MailboxImpl.this.recoverSnapshot(in);
        }

        @Override
        public void applyUpdate(Object logRecObj) {
            ((LogRecord)logRecObj).apply(MailboxImpl.this);
        }
    }

    private static class UnknownEventExceptionLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private EventID evtID;

        public UnknownEventExceptionLogObj(Uuid id, EventID eid) {
            this.regID = id;
            this.evtID = eid;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(unknownEventExceptionLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                recoveryLogger.log(Level.FINEST, "Adding: {0} to {1}", new Object[]{this.evtID, this.regID});
            }
            ServiceRegistration reg = (ServiceRegistration)mb.regByID.get(this.regID);
            reg.getUnknownEvents().put(this.evtID, this.evtID);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(unknownEventExceptionLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;

        public RegistrationCancelledLogObj(Uuid id) {
            this.regID = id;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(registrationCancelledLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                recoveryLogger.log(Level.FINEST, "Cancelling Reg: {0}", this.regID);
            }
            ServiceRegistration reg = (ServiceRegistration)mb.regByID.get(this.regID);
            mb.removeRegistration(this.regID, reg);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationCancelledLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private long expirationTime;

        public RegistrationRenewedLogObj(Uuid id, long time) {
            this.regID = id;
            this.expirationTime = time;
        }

        @Override
        public void apply(MailboxImpl mb) {
            ServiceRegistration reg;
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(registrationRenewedLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                recoveryLogger.log(Level.FINEST, "Reg: {0} will expire at {1}", new Object[]{this.regID, new Date(this.expirationTime)});
            }
            if ((reg = (ServiceRegistration)mb.regByID.get(this.regID)) != null) {
                reg.setExpiration(this.expirationTime);
            } else if (recoveryLogger.isLoggable(Levels.HANDLED)) {
                recoveryLogger.log(Levels.HANDLED, "*** Registration not renewed - not found");
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationRenewedLogObjSourceClass, "apply");
            }
        }
    }

    private static class AttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private MarshalledObject[] marshalledAttrTmpls;
        private MarshalledObject[] marshalledModAttrs;

        public AttrsModifiedLogObj(Entry[] attrTmpls, Entry[] modAttrs) {
            this.marshalledAttrTmpls = MailboxImpl.marshalAttributes(attrTmpls);
            this.marshalledModAttrs = MailboxImpl.marshalAttributes(modAttrs);
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(attrsModifiedLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                recoveryLogger.log(Level.FINEST, "Attributes (before):");
                MailboxImpl.dumpAttrs(mb.lookupAttrs, recoveryLogger, Level.FINEST);
            }
            Entry[] attrTmpls = MailboxImpl.unmarshalAttributes(this.marshalledAttrTmpls);
            Entry[] modAttrs = MailboxImpl.unmarshalAttributes(this.marshalledModAttrs);
            MailboxImpl.access$5202(mb, LookupAttributes.modify(mb.lookupAttrs, attrTmpls, modAttrs));
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Attributes (after):");
                MailboxImpl.dumpAttrs(mb.lookupAttrs, recoveryLogger, Level.FINEST);
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(attrsModifiedLogObjSourceClass, "apply");
            }
        }
    }

    private static class AttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private MarshalledObject[] marshalledAttrs;

        public AttrsAddedLogObj(Entry[] attrs) {
            this.marshalledAttrs = MailboxImpl.marshalAttributes(attrs);
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(attrsAddedLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
            }
            Entry[] attrs = MailboxImpl.unmarshalAttributes(this.marshalledAttrs);
            MailboxImpl.access$5202(mb, LookupAttributes.add(mb.lookupAttrs, attrs));
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Added the attributes:");
                MailboxImpl.dumpAttrs(attrs, recoveryLogger, Level.FINEST);
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(attrsAddedLogObjSourceClass, "apply");
            }
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] locators) {
            this.locators = locators;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(lookupLocatorsChangedLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                MailboxImpl.dumpLocators(this.locators, recoveryLogger, Level.FINEST);
            }
            MailboxImpl.access$4802(mb, this.locators);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(lookupLocatorsChangedLogObjSourceClass, "apply");
            }
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] groups) {
            this.groups = groups;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(lookupGroupsChangedLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                MailboxImpl.dumpGroups(this.groups, recoveryLogger, Level.FINEST);
            }
            MailboxImpl.access$4502(mb, this.groups);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(lookupGroupsChangedLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationIteratorEnabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private Uuid iterID;

        public RegistrationIteratorEnabledLogObj(Uuid rid, Uuid iid) {
            this.regID = rid;
            this.iterID = iid;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(registrationIteratorEnabledLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}, regID = {1}, iterID = {2}", new Object[]{this.getClass().getName(), this.regID, this.iterID});
            }
            try {
                mb.enableRegistrationIterator(this.regID, this.iterID);
            }
            catch (ThrowThis throwThis) {
                // empty catch block
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationIteratorEnabledLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationDisabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;

        public RegistrationDisabledLogObj(Uuid id) {
            this.regID = id;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(registrationDisabledLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}, regID = {1}", new Object[]{this.getClass().getName(), this.regID});
            }
            try {
                mb.disableRegistration(this.regID);
            }
            catch (ThrowThis throwThis) {
                // empty catch block
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationDisabledLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationEnabledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private Uuid regID;
        private transient RemoteEventListener target;

        public RegistrationEnabledLogObj(Uuid id, RemoteEventListener l) {
            this.regID = id;
            this.target = l;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(new MarshalledObject<RemoteEventListener>(this.target));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            block2: {
                stream.defaultReadObject();
                MarshalledObject mo = (MarshalledObject)stream.readObject();
                try {
                    this.target = (RemoteEventListener)mo.get();
                }
                catch (Throwable e) {
                    if (!(e instanceof Error) || e instanceof LinkageError || e instanceof OutOfMemoryError || e instanceof StackOverflowError) break block2;
                    throw (Error)e;
                }
            }
        }

        @Override
        public void apply(MailboxImpl mb) {
            block8: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.entering(registrationEnabledLogObjSourceClass, "apply", mb);
                }
                if (recoveryLogger.isLoggable(Level.FINEST)) {
                    recoveryLogger.log(Level.FINEST, "Applying a {0}, regID = {1}, target = {2}", new Object[]{this.getClass().getName(), this.regID, this.target});
                }
                try {
                    if (this.target != null) {
                        mb.enableRegistration(this.regID, this.target);
                    } else if (recoveryLogger.isLoggable(Levels.HANDLED)) {
                        recoveryLogger.log(Levels.HANDLED, "{0} cancelled due to null target", this.getClass().getName());
                    }
                }
                catch (ThrowThis tt) {
                    if (!recoveryLogger.isLoggable(Levels.HANDLED)) break block8;
                    recoveryLogger.log(Levels.HANDLED, "{0} Null or expired registration entry", this.getClass().getName());
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationEnabledLogObjSourceClass, "apply");
            }
        }
    }

    private static class RegistrationLogObj
    implements LogRecord {
        private static final long serialVersionUID = 1L;
        private ServiceRegistration reg;

        public RegistrationLogObj(ServiceRegistration reg) {
            this.reg = reg;
        }

        @Override
        public void apply(MailboxImpl mb) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(registrationLogObjSourceClass, "apply", mb);
            }
            if (recoveryLogger.isLoggable(Level.FINEST)) {
                recoveryLogger.log(Level.FINEST, "Applying a {0}", this.getClass().getName());
                this.reg.dumpInfo(recoveryLogger);
            }
            mb.addRegistration(this.reg);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(registrationLogObjSourceClass, "apply");
            }
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(MailboxImpl var1);
    }

    private class LocalLandlordAdaptor
    implements LocalLandlord {
        private LocalLandlordAdaptor() {
        }

        @Override
        public long renew(Uuid cookie, long extension) throws LeaseDeniedException, UnknownLeaseException {
            return MailboxImpl.this.renewDo(cookie, extension);
        }

        @Override
        public void cancel(Uuid cookie) throws UnknownLeaseException {
            MailboxImpl.this.cancelDo(cookie);
        }
    }

    private class ExpirationThread
    extends InterruptedStatusThread
    implements TimeConstants {
        public ExpirationThread() {
            super("ExpirationThread");
            this.setDaemon(true);
            if (expirationLogger.isLoggable(Level.FINEST)) {
                expirationLogger.log(Level.FINEST, "ExpirationThread started ...");
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(expirationThreadSourceClass, "run");
            }
            ServiceRegistration reg = null;
            long delay = 0L;
            try {
                MailboxImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    long now = System.currentTimeMillis();
                    if (expirationLogger.isLoggable(Level.FINEST)) {
                        expirationLogger.log(Level.FINEST, "ExpirationThread checking regs @ {0}", new Date(now));
                    }
                    while (!MailboxImpl.this.regByExpiration.isEmpty()) {
                        reg = (ServiceRegistration)MailboxImpl.this.regByExpiration.firstKey();
                        MailboxImpl.this.minRegExpiration = reg.getExpiration();
                        if (expirationLogger.isLoggable(Level.FINEST)) {
                            expirationLogger.log(Level.FINEST, "ExpirationThread checking {0} which expires @ {1}", new Object[]{reg, new Date(MailboxImpl.this.minRegExpiration)});
                        }
                        if (MailboxImpl.this.minRegExpiration > now) break;
                        MailboxImpl.this.removeRegistration(reg.getCookie(), reg);
                        MailboxImpl.this.concurrentObj.waiterNotify(reg.getIteratorNotifier());
                        if (!expirationLogger.isLoggable(Level.FINEST)) continue;
                        expirationLogger.log(Level.FINEST, "Iterator notified");
                    }
                    try {
                        delay = MailboxImpl.this.minRegExpiration - now;
                        long l = delay = delay >= 0L ? delay : Long.MAX_VALUE;
                        if (expirationLogger.isLoggable(Level.FINEST)) {
                            expirationLogger.log(Level.FINEST, "ExpirationThread delayed until {0}", new Date(delay + now));
                        }
                        MailboxImpl.this.concurrentObj.writerWait(MailboxImpl.this.expirationNotifier, delay);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                        if (expirationLogger.isLoggable(Level.FINEST)) {
                            expirationLogger.log(Level.FINEST, "ExpirationThread exiting ...");
                        }
                        return;
                    }
                }
            }
            finally {
                MailboxImpl.this.concurrentObj.writeUnlock();
                if (expirationLogger.isLoggable(Level.FINEST)) {
                    expirationLogger.log(Level.FINEST, "ExpirationThread exiting ...");
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(expirationThreadSourceClass, "run");
            }
        }
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(destroyThreadSourceClass, "run");
            }
            Object object = MailboxImpl.this.destroyLock;
            synchronized (object) {
                block60: {
                    long now;
                    long endTime;
                    block57: {
                        if (MailboxImpl.this.destroySucceeded) {
                            if (adminLogger.isLoggable(Level.FINEST)) {
                                adminLogger.log(Level.FINEST, "DestroyThread skipped ...");
                            }
                            return;
                        }
                        if (MailboxImpl.this.activationPrepared) {
                            try {
                                MailboxImpl.this.activationSystem.unregisterObject(MailboxImpl.this.activationID);
                            }
                            catch (RemoteException e) {
                                if (adminLogger.isLoggable(Level.WARNING)) {
                                    adminLogger.log(Level.WARNING, "aborting shutdown - could not unregister activation ID", e);
                                }
                                return;
                            }
                            catch (ActivationException e) {
                                if (!adminLogger.isLoggable(Levels.HANDLED)) break block57;
                                adminLogger.log(Levels.HANDLED, "problem shutting down - could not unregister activation ID", e);
                            }
                        }
                    }
                    if ((endTime = (now = System.currentTimeMillis()) + MailboxImpl.this.maxUnexportDelay) < 0L) {
                        endTime = Long.MAX_VALUE;
                    }
                    boolean unexported = false;
                    while (!unexported && now < endTime) {
                        unexported = MailboxImpl.this.exporter.unexport(false);
                        if (!unexported) {
                            if (adminLogger.isLoggable(Level.FINEST)) {
                                adminLogger.log(Level.FINEST, "Waiting for in-progress calls to complete");
                            }
                            try {
                                long sleepTime = Math.min(MailboxImpl.this.unexportRetryDelay, endTime - now);
                                DestroyThread.sleep(sleepTime);
                                now = System.currentTimeMillis();
                                continue;
                            }
                            catch (InterruptedException ie) {
                                if (!adminLogger.isLoggable(Levels.HANDLED)) break;
                                adminLogger.log(Levels.HANDLED, "problem unexporting nicely", ie);
                                break;
                            }
                        }
                        if (!adminLogger.isLoggable(Level.FINEST)) continue;
                        adminLogger.log(Level.FINEST, "Unexport completed");
                    }
                    if (!unexported) {
                        unexported = MailboxImpl.this.exporter.unexport(true);
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Forced unexport completed");
                        }
                    }
                    if (MailboxImpl.this.joiner != null) {
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Terminating JoinManager ...");
                        }
                        MailboxImpl.this.joiner.terminate();
                        MailboxImpl.this.joiner = null;
                    }
                    if (MailboxImpl.this.lookupDiscMgr != null) {
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Terminating lookupDiscMgr ...");
                        }
                        MailboxImpl.this.lookupDiscMgr.terminate();
                        MailboxImpl.this.lookupDiscMgr = null;
                    }
                    if (adminLogger.isLoggable(Level.FINEST)) {
                        adminLogger.log(Level.FINEST, "Interrupting Notifier ...");
                    }
                    MailboxImpl.this.notifier.interrupt();
                    if (adminLogger.isLoggable(Level.FINEST)) {
                        adminLogger.log(Level.FINEST, "Interrupting Expirer ...");
                    }
                    MailboxImpl.this.expirer.interrupt();
                    if (MailboxImpl.this.snapshotter != null) {
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Interrupting Snapshotter ...");
                        }
                        MailboxImpl.this.snapshotter.interrupt();
                    }
                    try {
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Waiting for Notifier ...");
                        }
                        MailboxImpl.this.notifier.join();
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Waiting for Expirer ...");
                        }
                        MailboxImpl.this.expirer.join();
                        if (MailboxImpl.this.snapshotter != null) {
                            if (adminLogger.isLoggable(Level.FINEST)) {
                                adminLogger.log(Level.FINEST, "Waiting for Snapshotter ...");
                            }
                            MailboxImpl.this.snapshotter.join();
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    MailboxImpl.this.concurrentObj.writeLock();
                    try {
                        ServiceRegistration[] regs = MailboxImpl.this.regByID.values().toArray(new ServiceRegistration[MailboxImpl.this.regByID.size()]);
                        EventLogIterator logIter = null;
                        if (adminLogger.isLoggable(Level.FINEST)) {
                            adminLogger.log(Level.FINEST, "Destroying {0} registration storage locations", MailboxImpl.this.regByID.size());
                        }
                        for (int i = 0; i < regs.length; ++i) {
                            block58: {
                                try {
                                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                                        persistenceLogger.log(Level.FINEST, "Destroying logs for -> {0}", regs[i]);
                                    }
                                    MailboxImpl.this.regByID.remove(regs[i].getCookie());
                                    logIter = regs[i].iterator();
                                    if (logIter != null) {
                                        logIter.destroy();
                                    }
                                }
                                catch (IOException ioe) {
                                    if (persistenceLogger.isLoggable(Levels.HANDLED)) {
                                        persistenceLogger.log(Levels.HANDLED, "Destroy unsuccessful.", ioe);
                                    }
                                }
                                catch (Exception de) {
                                    if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block58;
                                    persistenceLogger.log(Levels.HANDLED, "Destroy unsuccessful", de);
                                }
                            }
                            MailboxImpl.this.concurrentObj.waiterNotify(regs[i].getIteratorNotifier());
                            if (!expirationLogger.isLoggable(Level.FINEST)) continue;
                            expirationLogger.log(Level.FINEST, "Iterator notified");
                        }
                    }
                    finally {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                    }
                    if (MailboxImpl.this.log != null) {
                        MailboxImpl.this.log.deletePersistentStore();
                    }
                    if (MailboxImpl.this.activationID != null) {
                        ActivationGroupID gid = ActivationGroup.currentGroupID();
                        try {
                            Activatable.inactive((ActivationID)MailboxImpl.this.activationID);
                        }
                        catch (RemoteException e) {
                        }
                        catch (ActivationException e) {}
                    } else if (MailboxImpl.this.lifeCycle != null) {
                        MailboxImpl.this.lifeCycle.unregister(MailboxImpl.this);
                    }
                    if (MailboxImpl.this.loginContext != null) {
                        try {
                            if (adminLogger.isLoggable(Level.FINEST)) {
                                adminLogger.log(Level.FINEST, "Logging out");
                            }
                            MailboxImpl.this.loginContext.logout();
                        }
                        catch (Exception e) {
                            if (!adminLogger.isLoggable(Levels.HANDLED)) break block60;
                            adminLogger.log(Levels.HANDLED, "Exception while logging out", e);
                        }
                    }
                }
                if (adminLogger.isLoggable(Level.FINEST)) {
                    adminLogger.log(Level.FINEST, "DestroyThread finished ...");
                }
                MailboxImpl.this.destroySucceeded = true;
                MailboxImpl.this.readyState.shutdown();
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(destroyThreadSourceClass, "run");
            }
        }
    }

    class NotifyTask
    extends RetryTask {
        private Uuid regID;

        NotifyTask(TaskManager tm, WakeupManager mgr, Uuid regID) {
            super(tm, mgr);
            this.regID = regID;
        }

        private RemoteEvent getNextEvent(ServiceRegistration reg) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(notifyTaskSourceClass, "getNextEvent", reg);
            }
            RemoteEvent evt = null;
            try {
                if (reg.iterator().hasNext()) {
                    try {
                        evt = reg.iterator().next();
                    }
                    catch (IOException ioe) {
                    }
                    catch (ClassNotFoundException cnfe) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(notifyTaskSourceClass, "getNextEvent", evt);
            }
            return evt;
        }

        private void deleteNextEvent(ServiceRegistration reg) {
            block8: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.entering(notifyTaskSourceClass, "deleteNextEvent", reg);
                }
                try {
                    if (reg.iterator().hasNext()) {
                        try {
                            reg.iterator().remove();
                        }
                        catch (IOException ioe) {
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "NotifyTask could not deleteNextEvent for reg: {0}", reg);
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!deliveryLogger.isLoggable(Level.FINEST)) break block8;
                    deliveryLogger.log(Level.FINEST, "NotifyTask could not delete event because state info for {0} was inaccessible", reg);
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(notifyTaskSourceClass, "deleteNextEvent");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean disableRegistration(Uuid regID, RemoteEventListener l) {
            boolean disabled;
            block9: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.entering(notifyTaskSourceClass, "disableRegistration", new Object[]{regID, l});
                }
                disabled = true;
                MailboxImpl.this.concurrentObj.writeLock();
                try {
                    try {
                        ServiceRegistration reg = MailboxImpl.this.getServiceRegistration(regID);
                        RemoteEventListener currentListener = reg.getEventTarget();
                        if (currentListener == l) {
                            MailboxImpl.this.disableDeliveryDo(regID);
                            break block9;
                        }
                        if (deliveryLogger.isLoggable(Level.FINEST)) {
                            deliveryLogger.log(Level.FINEST, "Disabling registration for {0} skipped due to listener change.", regID);
                        }
                        disabled = false;
                    }
                    catch (ThrowThis tt) {
                        // empty catch block
                    }
                }
                finally {
                    MailboxImpl.this.concurrentObj.writeUnlock();
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(notifyTaskSourceClass, "disableRegistration", disabled);
            }
            return disabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryOnce() {
            long curTime;
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(notifyTaskSourceClass, "tryOnce");
            }
            boolean succeeded = false;
            boolean deleteEvent = false;
            boolean doNotify = true;
            ServiceRegistration reg = null;
            RemoteEventListener listener = null;
            RemoteEvent ev = null;
            if (deliveryLogger.isLoggable(Level.FINEST)) {
                deliveryLogger.log(Level.FINEST, "Attempting event delivery for: {0} at {1}", new Object[]{this.regID, new Date(System.currentTimeMillis())});
            }
            if ((curTime = System.currentTimeMillis()) - this.startTime() > 3600000L) {
                succeeded = true;
                deleteEvent = false;
                doNotify = false;
                if (deliveryLogger.isLoggable(Level.FINEST)) {
                    deliveryLogger.log(Level.FINEST, "Cancelling delivery due to time limit expiration.");
                }
            } else {
                MailboxImpl.this.concurrentObj.readLock();
                try {
                    try {
                        reg = MailboxImpl.this.getServiceRegistration(this.regID);
                        listener = reg.getEventTarget();
                        ev = this.getNextEvent(reg);
                        if (listener == null) {
                            succeeded = true;
                            deleteEvent = false;
                            doNotify = false;
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Cancelling delivery because of disabled listener");
                            }
                        } else if (ev == null) {
                            succeeded = true;
                            deleteEvent = false;
                            doNotify = false;
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Cancelling delivery because of null event");
                            }
                        } else if (ev != null && reg.getUnknownEvents().containsKey(new EventID(ev))) {
                            succeeded = true;
                            deleteEvent = true;
                            doNotify = false;
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Cancelling delivery because of unknown event");
                            }
                        }
                    }
                    catch (ThrowThis tt) {
                        succeeded = true;
                        deleteEvent = false;
                        doNotify = false;
                        if (deliveryLogger.isLoggable(Level.FINEST)) {
                            deliveryLogger.log(Level.FINEST, "Cancelling delivery because of unknown registration");
                        }
                    }
                }
                finally {
                    MailboxImpl.this.concurrentObj.readUnlock();
                }
            }
            if (doNotify) {
                if (deliveryLogger.isLoggable(Level.FINEST)) {
                    deliveryLogger.log(Level.FINEST, "Delivering evt: {0}, ID {1}, Seq# {2}", new Object[]{ev, ev.getID(), ev.getSequenceNumber()});
                }
                try {
                    listener.notify(ev);
                    succeeded = true;
                    deleteEvent = true;
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "Delivery was successful");
                    }
                }
                catch (UnknownEventException e) {
                    if (deliveryLogger.isLoggable(Levels.HANDLED)) {
                        deliveryLogger.log(Levels.HANDLED, "Caught UnknownEventException during notify");
                    }
                    MailboxImpl.this.addUnknownEvent(this.regID, new EventID(ev));
                    succeeded = true;
                    deleteEvent = true;
                }
                catch (Throwable t) {
                    int cat = ThrowableConstants.retryable(t);
                    if (cat == 2) {
                        if (deliveryLogger.isLoggable(Levels.HANDLED)) {
                            deliveryLogger.log(Levels.HANDLED, "Caught a BAD_OBJECT exception during notify", t);
                        }
                        this.disableRegistration(this.regID, listener);
                        succeeded = true;
                        deleteEvent = false;
                    }
                    if (cat == 0) {
                        if (deliveryLogger.isLoggable(Level.FINEST)) {
                            deliveryLogger.log(Level.FINEST, "Caught an INDEFINITE exception during notify", t);
                        }
                        succeeded = false;
                        deleteEvent = false;
                    }
                    if (cat == 1) {
                        if (deliveryLogger.isLoggable(Levels.HANDLED)) {
                            deliveryLogger.log(Levels.HANDLED, "Caught a BAD_INVOCATION exception during notify", t);
                        }
                        succeeded = true;
                        deleteEvent = true;
                    }
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "Caught an uncategorized exception during notify", t);
                    }
                    succeeded = false;
                    deleteEvent = false;
                }
            }
            if (!succeeded && this.attempt() > 5) {
                if (deliveryLogger.isLoggable(Levels.HANDLED)) {
                    deliveryLogger.log(Levels.HANDLED, "Maximum delivery attempts reached");
                }
                succeeded = true;
                deleteEvent = true;
            }
            if (succeeded || deleteEvent) {
                MailboxImpl.this.concurrentObj.writeLock();
                try {
                    try {
                        reg = MailboxImpl.this.getServiceRegistration(this.regID);
                        if (succeeded) {
                            if (reg.hasEventTarget()) {
                                if (deliveryLogger.isLoggable(Level.FINEST)) {
                                    deliveryLogger.log(Level.FINEST, "Putting task back onto pending list");
                                }
                                MailboxImpl.this.activeReg.remove(this.regID);
                                MailboxImpl.this.pendingReg.add(this.regID);
                            } else {
                                if (deliveryLogger.isLoggable(Level.FINEST)) {
                                    deliveryLogger.log(Level.FINEST, "Removing task ...");
                                }
                                if ((MailboxImpl.this.activeReg.remove(this.regID) != null || MailboxImpl.this.pendingReg.remove(this.regID)) && deliveryLogger.isLoggable(Level.FINEST)) {
                                    deliveryLogger.log(Level.FINEST, "ERROR: Found pending/active task for a disabled registration");
                                }
                            }
                        }
                        if (deleteEvent) {
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Deleting event ...");
                            }
                            this.deleteNextEvent(reg);
                        }
                    }
                    catch (ThrowThis tt) {
                        // empty catch block
                    }
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "Waking up notifier");
                    }
                    MailboxImpl.this.concurrentObj.waiterNotify(MailboxImpl.this.eventNotifier);
                }
                finally {
                    MailboxImpl.this.concurrentObj.writeUnlock();
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(notifyTaskSourceClass, "tryOnce", succeeded);
            }
            return succeeded;
        }

        @Override
        public boolean runAfter(List list, int max) {
            return false;
        }
    }

    private class Notifier
    extends InterruptedStatusThread
    implements TimeConstants {
        private TaskManager taskManager;
        private final WakeupManager wakeupMgr;
        private Random rand;
        private static final long PAUSE_TIME = 5000L;

        Notifier(Configuration config) throws ConfigurationException {
            super("Notifier");
            this.wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
            this.rand = new Random(System.currentTimeMillis());
            this.taskManager = (TaskManager)Config.getNonNullEntry(config, MailboxImpl.MERCURY, "notificationsTaskManager", TaskManager.class, new TaskManager());
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(notifierSourceClass, "run");
            }
            try {
                MailboxImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException e) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted()) {
                    int count = MailboxImpl.this.pendingReg.size();
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "Notifier checking {0} possible registrations", count);
                    }
                    while (count-- > 0) {
                        int index = this.rand.nextInt(MailboxImpl.this.pendingReg.size());
                        Uuid uuid = (Uuid)MailboxImpl.this.pendingReg.get(index);
                        ServiceRegistration reg = null;
                        try {
                            reg = MailboxImpl.this.getServiceRegistration(uuid);
                            if (!reg.iterator().hasNext()) continue;
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Scheduling delivery task for reg: {0} ", reg);
                            }
                            NotifyTask t = new NotifyTask(this.taskManager, this.wakeupMgr, uuid);
                            this.taskManager.add(t);
                            MailboxImpl.this.activeReg.put(uuid, t);
                            MailboxImpl.this.pendingReg.remove(index);
                        }
                        catch (ThrowThis tt) {
                            if (!deliveryLogger.isLoggable(Level.FINEST)) continue;
                            deliveryLogger.log(Level.FINEST, "Notifier: invalid registration for {0}", uuid);
                        }
                        catch (IOException ioe) {
                            if (!deliveryLogger.isLoggable(Level.FINEST)) continue;
                            deliveryLogger.log(Level.FINEST, "Notifier: inaccessible registration data for {0}", uuid);
                        }
                    }
                    try {
                        if (deliveryLogger.isLoggable(Level.FINEST)) {
                            deliveryLogger.log(Level.FINEST, "Notifier: delayed until {0}", new Date(5000L + System.currentTimeMillis()));
                        }
                        MailboxImpl.this.concurrentObj.writerWait(MailboxImpl.this.eventNotifier, 5000L);
                    }
                    catch (ReadersWriter.ConcurrentLockException e) {
                        MailboxImpl.this.concurrentObj.writeUnlock();
                        if (this.hasBeenInterrupted()) {
                            if (deliveryLogger.isLoggable(Level.FINEST)) {
                                deliveryLogger.log(Level.FINEST, "Notifier: terminating taskManager");
                            }
                            this.wakeupMgr.stop();
                            this.wakeupMgr.cancelAll();
                            this.taskManager.terminate();
                        }
                        if (deliveryLogger.isLoggable(Level.FINEST)) {
                            deliveryLogger.log(Level.FINEST, " Notifier: exiting ...");
                        }
                        return;
                    }
                }
            }
            finally {
                MailboxImpl.this.concurrentObj.writeUnlock();
                if (this.hasBeenInterrupted()) {
                    if (deliveryLogger.isLoggable(Level.FINEST)) {
                        deliveryLogger.log(Level.FINEST, "Notifier: terminating taskManager");
                    }
                    this.wakeupMgr.stop();
                    this.wakeupMgr.cancelAll();
                    this.taskManager.terminate();
                }
                if (deliveryLogger.isLoggable(Level.FINEST)) {
                    deliveryLogger.log(Level.FINEST, " Notifier: exiting ...");
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(notifierSourceClass, "run");
            }
        }
    }
}

