/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.NormServerBaseImpl;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.util.logging.Level;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

class ActivatableNormServerImpl
extends NormServerBaseImpl {
    private ActivationID activationID;
    private ActivationSystem activationSystem;

    @Override
    public void destroy() throws RemoteException {
        try {
            this.activationSystem.unregisterObject(this.activationID);
            logger.log(Level.FINEST, "Unregistered object with activation system");
        }
        catch (ActivationException e) {
            logger.log(Levels.HANDLED, "Unable to unregister object with activation system", e);
        }
        super.destroy();
    }

    @Override
    void postDestroy() {
        try {
            net.jini.activation.ActivationGroup.inactive(this.activationID, this.exporter);
            logger.log(Level.FINEST, "Inactivated object with activation system");
        }
        catch (RemoteException e) {
            logger.log(Levels.HANDLED, "Unable to inactivate object with activation system", e);
        }
        catch (ActivationException e) {
            logger.log(Levels.HANDLED, "Unable to inactivate object with activation system", e);
        }
    }

    ActivatableNormServerImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        super(true);
        String[] configOptions = null;
        try {
            if (activationID == null) {
                throw new NullPointerException("activationID is null");
            }
            configOptions = (String[])data.get();
        }
        catch (Throwable e) {
            ActivatableNormServerImpl.initFailed(e);
        }
        this.activationID = activationID;
        this.init(configOptions, null);
    }

    @Override
    void initAsSubject(Configuration config) throws Exception {
        ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.norm", "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy(ActivationGroup.getSystem());
        ProxyPreparer activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.norm", "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.activationID = (ActivationID)activationIdPreparer.prepareProxy(this.activationID);
        super.initAsSubject(config);
    }

    @Override
    Exporter getExporter(Configuration config) throws ConfigurationException {
        Exporter result = (Exporter)Config.getNonNullEntry(config, "com.sun.jini.norm", "serverExporter", Exporter.class, new ActivationExporter(this.activationID, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory())), this.activationID);
        return result;
    }
}

