/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lease.LeaseMapException;

class ClientLeaseMapWrapper
extends AbstractMap
implements LeaseMap {
    private static final long serialVersionUID = 1L;
    private static final Method[] leaseToLeaseMapMethods;
    private final LeaseMap clientLeaseMap;
    private final Map wrapperMap = new HashMap();
    private final ClientLeaseWrapper example;

    ClientLeaseMapWrapper(ClientLeaseWrapper wrapper, long duration) {
        Lease clientLease = wrapper.getClientLease();
        if (clientLease == null) {
            throw new IllegalArgumentException("Wrapper cannot be deformed");
        }
        LeaseMap leaseMap = clientLease.createLeaseMap(duration);
        if (clientLease instanceof RemoteMethodControl && leaseMap instanceof RemoteMethodControl) {
            leaseMap = (LeaseMap)((Object)((RemoteMethodControl)((Object)leaseMap)).setConstraints(ConstrainableProxyUtil.translateConstraints(((RemoteMethodControl)((Object)clientLease)).getConstraints(), leaseToLeaseMapMethods)));
        }
        this.clientLeaseMap = leaseMap;
        this.wrapperMap.put(clientLease, wrapper);
        this.example = wrapper;
    }

    @Override
    public void cancelAll() {
        throw new UnsupportedOperationException("ClientLeaseMapWrapper.cancelAll: LRS should not being canceling client leases");
    }

    private void applyException(Throwable t) {
        for (ClientLeaseWrapper clw : this.wrapperMap.values()) {
            clw.failedRenewal(t);
        }
    }

    @Override
    public void renewAll() throws LeaseMapException, RemoteException {
        LeaseMapException lme = null;
        HashMap<ClientLeaseWrapper, Throwable> newExceptionMap = null;
        long now = System.currentTimeMillis();
        Iterator<Object> i = this.wrapperMap.values().iterator();
        while (i.hasNext()) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)i.next();
            if (clw.ensureCurrent(now)) continue;
            if (newExceptionMap == null) {
                newExceptionMap = new HashMap<ClientLeaseWrapper, Throwable>(this.wrapperMap.size());
            }
            newExceptionMap.put(clw, LRMEventListener.EXPIRED_SET_EXCEPTION);
            i.remove();
            this.clientLeaseMap.remove(clw.getClientLease());
        }
        if (this.clientLeaseMap.isEmpty()) {
            if (newExceptionMap == null) {
                return;
            }
            throw new LeaseMapException("Expired Sets", newExceptionMap);
        }
        try {
            this.clientLeaseMap.renewAll();
        }
        catch (LeaseMapException e) {
            lme = e;
        }
        catch (RemoteException e) {
            this.applyException(e);
            throw e;
        }
        catch (Error e) {
            this.applyException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.applyException(e);
            throw e;
        }
        for (Lease cl : this.clientLeaseMap.keySet()) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)this.wrapperMap.get(cl);
            clw.successfulRenewal();
        }
        if (lme == null && newExceptionMap == null) {
            return;
        }
        if (lme != null) {
            Map exceptionMap = lme.exceptionMap;
            if (newExceptionMap == null) {
                newExceptionMap = new HashMap(exceptionMap.size());
            }
            Iterator i2 = exceptionMap.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e = i2.next();
                Lease cl = (Lease)e.getKey();
                Throwable t = (Throwable)e.getValue();
                ClientLeaseWrapper clw = (ClientLeaseWrapper)this.wrapperMap.remove(cl);
                i2.remove();
                clw.failedRenewal(t);
                newExceptionMap.put(clw, t);
            }
        }
        if (newExceptionMap != null) {
            throw new LeaseMapException(lme == null ? "Expired Sets" : lme.getMessage(), newExceptionMap);
        }
    }

    @Override
    public boolean canContainKey(Object key) {
        return key instanceof Lease && this.example.canBatch((Lease)key);
    }

    private Lease checkKey(Object key) {
        if (this.canContainKey(key)) {
            return ((ClientLeaseWrapper)key).getClientLease();
        }
        throw new IllegalArgumentException("key is not valid for this LeaseMap");
    }

    private static void checkValue(Object value) {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("value is not a Long");
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Lease cl = this.checkKey(key);
        return this.clientLeaseMap.containsKey(cl);
    }

    @Override
    public boolean containsValue(Object value) {
        ClientLeaseMapWrapper.checkValue(value);
        return this.clientLeaseMap.containsValue(value);
    }

    public Object get(Object key) {
        Lease cl = this.checkKey(key);
        return this.clientLeaseMap.get(cl);
    }

    public Object put(Object key, Object value) {
        Lease cl = this.checkKey(key);
        ClientLeaseMapWrapper.checkValue(value);
        this.wrapperMap.put(cl, key);
        return this.clientLeaseMap.put(cl, value);
    }

    public Object remove(Object key) {
        Lease cl = this.checkKey(key);
        this.wrapperMap.remove(cl);
        return this.clientLeaseMap.remove(cl);
    }

    public void putAll(Map m) {
        for (Map.Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.clientLeaseMap.clear();
        this.wrapperMap.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.clientLeaseMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.clientLeaseMap.hashCode();
    }

    public Set entrySet() {
        return new EntrySet();
    }

    static {
        try {
            Method cancel = Lease.class.getMethod("cancel", new Class[0]);
            Method cancelAll = LeaseMap.class.getMethod("cancelAll", new Class[0]);
            Method renew = Lease.class.getMethod("renew", Long.TYPE);
            Method renewAll = LeaseMap.class.getMethod("renewAll", new Class[0]);
            leaseToLeaseMapMethods = new Method[]{cancel, cancelAll, renew, renewAll};
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    private final class EntryIterator
    implements Iterator {
        private final Iterator iter;
        private Lease last;

        public EntryIterator() {
            this.iter = ClientLeaseMapWrapper.this.wrapperMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Map.Entry e = (Map.Entry)this.iter.next();
            this.last = (Lease)e.getKey();
            return new Entry((ClientLeaseWrapper)e.getValue());
        }

        @Override
        public void remove() {
            ClientLeaseMapWrapper.this.clientLeaseMap.remove(this.last);
            this.iter.remove();
        }
    }

    private final class Entry
    implements Map.Entry {
        private final ClientLeaseWrapper key;

        public Entry(ClientLeaseWrapper key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return ClientLeaseMapWrapper.this.clientLeaseMap.get(this.key.getClientLease());
        }

        public Object setValue(Object value) {
            ClientLeaseMapWrapper.checkValue(value);
            return ClientLeaseMapWrapper.this.clientLeaseMap.put(this.key.getClientLease(), value);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry that = (Entry)o;
                return that.key.equals(this.key);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private final class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        private Lease getClientLease(Object o) {
            if (!(o instanceof Map.Entry)) {
                return null;
            }
            Map.Entry e = (Map.Entry)o;
            Object eValue = e.getValue();
            if (!(e.getKey() instanceof ClientLeaseWrapper) || !(eValue instanceof Long) || eValue == null) {
                return null;
            }
            ClientLeaseWrapper clw = (ClientLeaseWrapper)e.getKey();
            return clw.getClientLease();
        }

        @Override
        public boolean contains(Object o) {
            Lease cl = this.getClientLease(o);
            if (cl == null) {
                return false;
            }
            Object eValue = ((Map.Entry)o).getValue();
            Object value = ClientLeaseMapWrapper.this.clientLeaseMap.get(cl);
            if (value == null) {
                return false;
            }
            return value.equals(eValue);
        }

        @Override
        public boolean remove(Object o) {
            Lease cl = this.getClientLease(o);
            if (cl == null) {
                return false;
            }
            Object eValue = ((Map.Entry)o).getValue();
            Object value = ClientLeaseMapWrapper.this.clientLeaseMap.get(cl);
            if (value == null || !value.equals(eValue)) {
                return false;
            }
            ClientLeaseMapWrapper.this.clientLeaseMap.remove(cl);
            ClientLeaseMapWrapper.this.wrapperMap.remove(cl);
            return true;
        }

        @Override
        public int size() {
            return ClientLeaseMapWrapper.this.clientLeaseMap.size();
        }

        @Override
        public void clear() {
            ClientLeaseMapWrapper.this.wrapperMap.clear();
            ClientLeaseMapWrapper.this.clientLeaseMap.clear();
        }
    }
}

