/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.GetLeasesResult;
import com.sun.jini.norm.NormServer;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.LinkedList;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.id.Uuid;
import net.jini.io.MarshalledInstance;
import net.jini.lease.LeaseRenewalSet;
import net.jini.lease.LeaseUnmarshalException;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class SetProxy
extends AbstractProxy
implements LeaseRenewalSet {
    private static final long serialVersionUID = 2L;
    final Lease ourLease;

    static SetProxy create(NormServer server, Uuid id, Lease lease) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableSetProxy(server, id, lease, null);
        }
        return new SetProxy(server, id, lease);
    }

    private SetProxy(NormServer server, Uuid id, Lease lease) {
        super(server, id);
        if (lease == null) {
            throw new NullPointerException("lease cannot be null");
        }
        this.ourLease = lease;
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server, uuid, and ourLease must be non-null");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ourLease == null) {
            throw new InvalidObjectException("ourLease cannot be null");
        }
    }

    @Override
    public void renewFor(Lease leaseToRenew, long membershipDuration) throws RemoteException {
        try {
            this.server2().renewFor(this.uuid, leaseToRenew, membershipDuration, Long.MAX_VALUE);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public void renewFor(Lease leaseToRenew, long membershipDuration, long renewDuration) throws RemoteException {
        try {
            this.server.renewFor(this.uuid, leaseToRenew, membershipDuration, renewDuration);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public Lease remove(Lease leaseToRemove) throws RemoteException {
        try {
            return this.server.remove(this.uuid, leaseToRemove);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return null;
        }
    }

    @Override
    public Lease[] getLeases() throws LeaseUnmarshalException, RemoteException {
        try {
            GetLeasesResult result = this.server.getLeases(this.uuid);
            MarshalledInstance[] mls = result.marshalledLeases;
            if (mls == null || mls.length == 0) {
                return new Lease[0];
            }
            LinkedList<Lease> leases = new LinkedList<Lease>();
            LinkedList<MarshalledObject> problems = new LinkedList<MarshalledObject>();
            LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
            for (int i = 0; i < mls.length; ++i) {
                MarshalledInstance ml = mls[i];
                try {
                    Lease l = (Lease)ml.get(result.verifyCodebaseIntegrity());
                    leases.add(l);
                    continue;
                }
                catch (Throwable t) {
                    problems.add(ml.convertToMarshalledObject());
                    exceptions.add(t);
                }
            }
            Lease[] rslt = leases.toArray(new Lease[leases.size()]);
            if (problems.isEmpty()) {
                return rslt;
            }
            MarshalledObject[] sml = problems.toArray(new MarshalledObject[problems.size()]);
            Throwable[] es = exceptions.toArray(new Throwable[exceptions.size()]);
            throw new LeaseUnmarshalException("Problem unmarshalling lease(s)", rslt, sml, es);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return null;
        }
    }

    @Override
    public EventRegistration setExpirationWarningListener(RemoteEventListener listener, long minWarning, MarshalledObject handback) throws RemoteException {
        if (listener == null) {
            throw new NullPointerException("LeaseRenewalSet.setExpirationWarningListener:Must pass a non-null listener");
        }
        try {
            return this.server.setExpirationWarningListener(this.uuid, listener, minWarning, handback);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return null;
        }
    }

    @Override
    public void clearExpirationWarningListener() throws RemoteException {
        try {
            this.server2().setExpirationWarningListener(this.uuid, null, -1L, null);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    @Override
    public EventRegistration setRenewalFailureListener(RemoteEventListener listener, MarshalledObject handback) throws RemoteException {
        if (listener == null) {
            throw new NullPointerException("LeaseRenewalSet.setRenewalFailureListener:Must pass a non-null listener");
        }
        try {
            return this.server.setRenewalFailureListener(this.uuid, listener, handback);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
            return null;
        }
    }

    @Override
    public void clearRenewalFailureListener() throws RemoteException {
        try {
            this.server2().setRenewalFailureListener(this.uuid, null, null);
        }
        catch (ThrowThis e) {
            e.throwRemoteException();
        }
    }

    NormServer server2() {
        return this.server;
    }

    @Override
    public Lease getRenewalSetLease() {
        return this.ourLease;
    }

    static final class ConstrainableSetProxy
    extends SetProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;
        private static final Method[] methodMap1;
        private static final Method[] methodMap2;
        private MethodConstraints methodConstraints;
        private transient NormServer server2;

        ConstrainableSetProxy(NormServer server, Uuid id, Lease lease, MethodConstraints methodConstraints) {
            super(ConstrainableSetProxy.constrainServer(server, methodConstraints, methodMap1), id, lease);
            if (!(lease instanceof ConstrainableLandlordLease)) {
                throw new IllegalArgumentException("lease must be a ConstrainableLandlordLease");
            }
            this.methodConstraints = methodConstraints;
            this.server2 = ConstrainableSetProxy.constrainServer(server, methodConstraints, methodMap2);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("server does not implement RemoteMethodControl");
            }
            if (!(this.ourLease instanceof ConstrainableLandlordLease)) {
                throw new InvalidObjectException("ourLease is not a ConstrainableLandlordLease");
            }
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMap1);
            this.server2 = ConstrainableSetProxy.constrainServer(this.server, this.methodConstraints, methodMap2);
        }

        private static NormServer constrainServer(NormServer server, MethodConstraints methodConstraints, Method[] mappings) {
            return (NormServer)((Object)((RemoteMethodControl)((Object)server)).setConstraints(ConstrainableProxyUtil.translateConstraints(methodConstraints, mappings)));
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableSetProxy(this.server, this.uuid, this.ourLease, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        @Override
        NormServer server2() {
            return this.server2;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        static {
            try {
                methodMap1 = new Method[]{LeaseRenewalSet.class.getMethod("renewFor", Lease.class, Long.TYPE, Long.TYPE), NormServer.class.getMethod("renewFor", Uuid.class, Lease.class, Long.TYPE, Long.TYPE), LeaseRenewalSet.class.getMethod("remove", Lease.class), NormServer.class.getMethod("remove", Uuid.class, Lease.class), LeaseRenewalSet.class.getMethod("getLeases", new Class[0]), NormServer.class.getMethod("getLeases", Uuid.class), LeaseRenewalSet.class.getMethod("setExpirationWarningListener", RemoteEventListener.class, Long.TYPE, MarshalledObject.class), NormServer.class.getMethod("setExpirationWarningListener", Uuid.class, RemoteEventListener.class, Long.TYPE, MarshalledObject.class), LeaseRenewalSet.class.getMethod("setRenewalFailureListener", RemoteEventListener.class, MarshalledObject.class), NormServer.class.getMethod("setRenewalFailureListener", Uuid.class, RemoteEventListener.class, MarshalledObject.class)};
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
            try {
                methodMap2 = new Method[]{LeaseRenewalSet.class.getMethod("renewFor", Lease.class, Long.TYPE), NormServer.class.getMethod("renewFor", Uuid.class, Lease.class, Long.TYPE, Long.TYPE), LeaseRenewalSet.class.getMethod("clearExpirationWarningListener", new Class[0]), NormServer.class.getMethod("setExpirationWarningListener", Uuid.class, RemoteEventListener.class, Long.TYPE, MarshalledObject.class), LeaseRenewalSet.class.getMethod("clearRenewalFailureListener", new Class[0]), NormServer.class.getMethod("setRenewalFailureListener", Uuid.class, RemoteEventListener.class, MarshalledObject.class)};
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }
    }
}

