/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.EventRegistrationRecord;
import com.sun.jini.outrigger.EventSender;
import com.sun.jini.outrigger.OutriggerAvailabilityEvent;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.TemplateHandle;
import com.sun.jini.outrigger.TransitionWatcher;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.util.HashSet;
import java.util.Set;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;
import net.jini.space.JavaSpace;

abstract class AvailabilityRegistrationWatcher
extends TransitionWatcher
implements EventRegistrationRecord {
    long expiration;
    Uuid cookie;
    MarshalledObject handback;
    boolean visibilityOnly;
    long eventID;
    private long currentSeqNum = 0L;
    private Set owners = new HashSet();
    private OutriggerServerImpl server;

    AvailabilityRegistrationWatcher(long timestamp, long startOrdinal, long currentSeqNum) {
        super(timestamp, startOrdinal);
        this.currentSeqNum = currentSeqNum;
    }

    AvailabilityRegistrationWatcher(long timestamp, long startOrdinal, Uuid cookie, boolean visibilityOnly, MarshalledObject handback, long eventID) {
        super(timestamp, startOrdinal);
        if (cookie == null) {
            throw new NullPointerException("cookie must be non-null");
        }
        this.cookie = cookie;
        this.handback = handback;
        this.eventID = eventID;
        this.visibilityOnly = visibilityOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void process(EntryTransition transition, long now) {
        boolean doneFor = false;
        AvailabilityRegistrationWatcher availabilityRegistrationWatcher = this;
        synchronized (availabilityRegistrationWatcher) {
            if (this.owners == null) {
                return;
            }
            if (now > this.expiration) {
                doneFor = true;
            } else {
                this.server.enqueueDelivery(new VisibilityEventSender(transition.getHandle().rep(), transition.isVisible(), this.currentSeqNum++));
            }
        }
        if (doneFor) {
            this.cancel();
        }
    }

    abstract RemoteEventListener getListener(ProxyPreparer var1) throws ClassNotFoundException, IOException;

    @Override
    synchronized boolean addTemplateHandle(TemplateHandle h) {
        if (this.owners == null) {
            return false;
        }
        this.owners.add(h);
        if (this.server == null) {
            this.server = h.getServer();
        }
        return true;
    }

    @Override
    public void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public Uuid getCookie() {
        return this.cookie;
    }

    void cleanup(OutriggerServerImpl server, boolean expired) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemove(long now, boolean doIt) {
        Set owners;
        AvailabilityRegistrationWatcher availabilityRegistrationWatcher = this;
        synchronized (availabilityRegistrationWatcher) {
            if (this.owners == null) {
                return false;
            }
            if (!doIt && now < this.expiration) {
                return false;
            }
            owners = this.owners;
            this.expiration = Long.MIN_VALUE;
            this.owners = null;
        }
        this.cleanup(this.server, !doIt);
        for (TemplateHandle h : owners) {
            h.removeTransitionWatcher(this);
        }
        this.server.removeEventRegistration(this);
        return true;
    }

    @Override
    void removeIfExpired(long now) {
        this.doRemove(now, false);
    }

    @Override
    public boolean cancel() {
        return this.doRemove(0L, true);
    }

    private class VisibilityEventSender
    implements EventSender {
        private final EntryRep rep;
        private final long ourSeqNumber;
        private final boolean isVisible;

        private VisibilityEventSender(EntryRep rep, boolean isVisible, long ourSeqNumber) {
            this.rep = rep;
            this.ourSeqNumber = ourSeqNumber;
            this.isVisible = isVisible;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendEvent(JavaSpace source, long now, ProxyPreparer preparer) throws UnknownEventException, IOException, ClassNotFoundException {
            boolean doneFor = false;
            AvailabilityRegistrationWatcher availabilityRegistrationWatcher = AvailabilityRegistrationWatcher.this;
            synchronized (availabilityRegistrationWatcher) {
                if (AvailabilityRegistrationWatcher.this.owners == null) {
                    return;
                }
                if (AvailabilityRegistrationWatcher.this.getExpiration() < now) {
                    doneFor = true;
                }
            }
            if (doneFor) {
                AvailabilityRegistrationWatcher.this.cancel();
                return;
            }
            AvailabilityRegistrationWatcher.this.getListener(preparer).notify(new OutriggerAvailabilityEvent(source, AvailabilityRegistrationWatcher.this.eventID, this.ourSeqNumber, AvailabilityRegistrationWatcher.this.handback, this.isVisible, this.rep));
        }

        @Override
        public void cancelRegistration() {
            AvailabilityRegistrationWatcher.this.cancel();
        }

        @Override
        public boolean runAfter(EventSender other) {
            return false;
        }
    }
}

