/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.OutriggerServerImpl;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;

class ExpirationOpQueue
extends Thread {
    private boolean dead;
    private final LinkedList queue = new LinkedList();
    private final OutriggerServerImpl server;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.leases");

    ExpirationOpQueue(OutriggerServerImpl server) {
        super("Expiration Op Queue");
        this.server = server;
    }

    synchronized void enqueue(Uuid cookie) {
        this.queue.add(cookie);
        this.notifyAll();
    }

    synchronized void terminate() {
        this.dead = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.dead) {
            try {
                Uuid cookie;
                ExpirationOpQueue expirationOpQueue = this;
                synchronized (expirationOpQueue) {
                    while (!this.dead && this.queue.isEmpty()) {
                        this.wait();
                    }
                    if (this.dead) {
                        return;
                    }
                    cookie = (Uuid)this.queue.removeFirst();
                }
                this.server.cancelOp(cookie, true);
            }
            catch (Throwable t) {
                try {
                    logger.log(Level.INFO, "ExpirationOpQueue.run encountered " + t.getClass().getName() + ", continuing", t);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

