/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import net.jini.export.ServerContext;
import net.jini.io.context.ClientHost;

class LocalAccess {
    private static Map cache = new HashMap(3);

    private LocalAccess() {
    }

    public static synchronized void check() {
        ClientHost host = null;
        try {
            host = (ClientHost)ServerContext.getServerContextElement(ClientHost.class);
        }
        catch (ServerNotActiveException e) {
            return;
        }
        if (host == null) {
            return;
        }
        InetAddress addr = host.getClientHost();
        Boolean ok = (Boolean)cache.get(addr);
        if (ok == null) {
            try {
                ok = addr != null && (NetworkInterface.getByInetAddress(addr) != null || addr.isLoopbackAddress());
            }
            catch (IOException e) {
                ok = Boolean.FALSE;
            }
            cache.put(addr, ok);
        }
        if (!ok.booleanValue()) {
            throw new AccessControlException("origin is non-local host");
        }
    }
}

