/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.AdminProxy;
import com.sun.jini.reggie.ConstrainableAdminProxy;
import com.sun.jini.reggie.ConstrainableEventLease;
import com.sun.jini.reggie.ConstrainableRegistrarProxy;
import com.sun.jini.reggie.ConstrainableRegistration;
import com.sun.jini.reggie.ConstrainableServiceLease;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarLease;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl server;
    private transient ServiceID registrarID;

    ProxyVerifier(Registrar server, ServiceID registrarID) {
        if (!(server instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("server does not implement RemoteMethodControl");
        }
        if (!(server instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("server does not implement TrustEquivalence");
        }
        this.server = (RemoteMethodControl)((Object)server);
        this.registrarID = registrarID;
    }

    @Override
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        ServiceID inputRegistrarID;
        RemoteMethodControl inputServer;
        ReferentUuid proxy;
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        if (obj instanceof ConstrainableRegistrarProxy) {
            proxy = (RegistrarProxy)obj;
            inputServer = (RemoteMethodControl)((Object)proxy.server);
            inputRegistrarID = proxy.registrarID;
        } else if (obj instanceof ConstrainableAdminProxy) {
            proxy = (AdminProxy)obj;
            inputServer = (RemoteMethodControl)((Object)((AdminProxy)proxy).server);
            inputRegistrarID = ((AdminProxy)proxy).registrarID;
        } else if (obj instanceof ConstrainableRegistration) {
            Registration reg = (Registration)obj;
            if (!this.isTrustedObject(reg.lease, ctx)) {
                return false;
            }
            inputServer = (RemoteMethodControl)((Object)reg.server);
            inputRegistrarID = this.registrarID;
        } else if (obj instanceof ConstrainableEventLease || obj instanceof ConstrainableServiceLease) {
            RegistrarLease lease = (RegistrarLease)obj;
            inputServer = (RemoteMethodControl)((Object)lease.server);
            inputRegistrarID = lease.registrarID;
        } else if (obj instanceof RemoteMethodControl) {
            inputServer = (RemoteMethodControl)obj;
            inputRegistrarID = this.registrarID;
        } else {
            return false;
        }
        TrustEquivalence trustEquiv = (TrustEquivalence)((Object)this.server.setConstraints(inputServer.getConstraints()));
        return trustEquiv.checkTrustEquivalence(inputServer) && this.registrarID.equals(inputRegistrarID);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.registrarID.writeBytes(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.registrarID = new ServiceID(in);
        if (!(this.server instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("server does not implement RemoteMethodControl");
        }
        if (!(this.server instanceof TrustEquivalence)) {
            throw new InvalidObjectException("server does not implement TrustEquivalence");
        }
    }
}

