/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

public class ServerTransaction
implements Transaction,
Serializable {
    static final long serialVersionUID = 4552277137549765374L;
    public final TransactionManager mgr;
    public final long id;

    public ServerTransaction(TransactionManager mgr, long id) {
        this.mgr = mgr;
        this.id = id;
    }

    public int hashCode() {
        return (int)this.id ^ this.mgr.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ServerTransaction)) {
            return false;
        }
        ServerTransaction t = (ServerTransaction)other;
        return this.id == t.id && this.mgr.equals(t.mgr);
    }

    @Override
    public void commit() throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.mgr.commit(this.id);
    }

    @Override
    public void commit(long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.mgr.commit(this.id, waitFor);
    }

    @Override
    public void abort() throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.mgr.abort(this.id);
    }

    @Override
    public void abort(long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.mgr.abort(this.id, waitFor);
    }

    public void join(TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.mgr.join(this.id, part, crashCount);
    }

    public int getState() throws UnknownTransactionException, RemoteException {
        return this.mgr.getState(this.id);
    }

    public boolean isNested() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " [manager=" + this.mgr + ", id=" + this.id + "]";
    }
}

