/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import java.lang.ref.WeakReference;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import net.jini.security.GrantPermission;
import net.jini.security.policy.UmbrellaGrantPermission;
import org.apache.river.api.security.ConcurrentPermissions;
import org.apache.river.api.security.PermissionComparator;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;

public abstract class AbstractPolicy
extends Policy {
    protected final Permission umbrella = new UmbrellaGrantPermission();
    protected final Permission ALL_PERMISSION = new AllPermission();
    protected final Comparator<Permission> comparator = new PermissionComparator();

    protected AbstractPolicy() {
    }

    protected final void checkCallerHasGrants(Collection<PermissionGrant> grants) throws SecurityException {
        for (PermissionGrant grant : grants) {
            this.checkCallerHasGrants(grant);
        }
    }

    protected final void checkCallerHasGrants(PermissionGrant grant) throws SecurityException {
        Collection<Permission> permCol = grant.getPermissions();
        Object[] perms = permCol.toArray(new Permission[permCol.size()]);
        this.checkNullElements(perms);
        GrantPermission g = new GrantPermission((Permission[])perms);
        g.checkGuard(this);
    }

    protected final void checkNullElements(Object[] array) throws NullPointerException {
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            if (array[i] != null) continue;
            throw new NullPointerException();
        }
    }

    protected final PermissionCollection convert(NavigableSet<Permission> permissions, int initialCapacity, float loadFactor, int concurrencyLevel, int unresolvedCapacity) throws IllegalArgumentException {
        ConcurrentPermissions pc = new ConcurrentPermissions(initialCapacity, loadFactor, concurrencyLevel, unresolvedCapacity);
        Iterator<Permission> it = permissions.descendingIterator();
        while (it.hasNext()) {
            ((PermissionCollection)pc).add(it.next());
        }
        return pc;
    }

    protected final void expandUmbrella(PermissionCollection pc) {
        if (pc.implies(this.umbrella)) {
            ArrayList<Permission> perms = new ArrayList<Permission>(120);
            Enumeration<Permission> e = pc.elements();
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                if (p instanceof GrantPermission || p instanceof UmbrellaGrantPermission) continue;
                perms.add(p);
            }
            pc.add(new GrantPermission(perms.toArray(new Permission[perms.size()])));
        }
    }

    protected final void processGrants(Collection<PermissionGrant> grant, Class permClass, boolean stopIfAll, NavigableSet<Permission> setToAddPerms) {
        Iterator<PermissionGrant> grants = grant.iterator();
        if (permClass == null) {
            while (grants.hasNext()) {
                PermissionGrant g = grants.next();
                if (stopIfAll && g.isPrivileged()) {
                    setToAddPerms.add(this.ALL_PERMISSION);
                    return;
                }
                for (Permission p : g.getPermissions()) {
                    setToAddPerms.add(p);
                }
            }
        } else {
            while (grants.hasNext()) {
                PermissionGrant g = grants.next();
                if (stopIfAll && g.isPrivileged()) {
                    setToAddPerms.add(this.ALL_PERMISSION);
                    return;
                }
                for (Permission p : g.getPermissions()) {
                    if (!permClass.isInstance(p) && !(p instanceof UnresolvedPermission)) continue;
                    setToAddPerms.add(p);
                }
            }
        }
    }

    protected PermissionGrant extractGrantFromPolicy(Policy p, ProtectionDomain domain) {
        LinkedList<Permission> perms = new LinkedList<Permission>();
        PermissionGrantBuilder pgb = PermissionGrantBuilder.newBuilder();
        pgb.setDomain(new WeakReference<ProtectionDomain>(domain));
        PermissionCollection pc = p.getPermissions(domain);
        Enumeration<Permission> en = pc.elements();
        while (en.hasMoreElements()) {
            perms.add(en.nextElement());
        }
        pgb.permissions(perms.toArray(new Permission[perms.size()]));
        pgb.context(1);
        return pgb.build();
    }
}

