/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.xtext.utils.unittesting;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.Issue;
import org.eclipselabs.xtext.utils.unittesting.XtextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluentIssueCollection
implements Iterable<Issue> {
    private static Logger LOGGER = Logger.getLogger(FluentIssueCollection.class);
    private List<Issue> issues;
    private List<String> messages;
    private Resource resource;
    private boolean state;
    private boolean stateIsSet;

    public FluentIssueCollection(Resource res, List<Issue> issues, List<String> messages) {
        this.resource = res;
        this.issues = issues;
        this.messages = messages;
    }

    public FluentIssueCollection(Resource res, List<String> messages) {
        this.issues = new ArrayList<Issue>();
        this.resource = res;
        this.messages = messages;
    }

    private void addMessage(String m) {
        this.messages.add(m);
    }

    public void addIssue(Issue issue) {
        this.issues.add(issue);
    }

    public FluentIssueCollection forType(Class<? extends EObject> cls) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            URI uri = i.getUriToProblem();
            EObject eObject = this.resource.getEObject(uri.fragment());
            if (!cls.isInstance(eObject)) continue;
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("No issues found for type " + cls.getName());
        }
        return res;
    }

    public FluentIssueCollection get(int index) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        if (index >= this.getIssueCount()) {
            res.addMessage("trying to get element at " + index + ", but only have " + this.getIssueCount() + " elements -> creating empty collection!");
        } else {
            res.addIssue(this.getIssues().get(index));
        }
        return res;
    }

    public FluentIssueCollection inLine(int lineNo) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        int rc = 0;
        for (Issue i : this.issues) {
            if (i.getLineNumber() != lineNo) continue;
            res.addIssue(i);
            ++rc;
        }
        if (rc == 0) {
            res.addMessage("no issues found for line number " + lineNo);
        }
        return res;
    }

    public FluentIssueCollection withStringFeatureValue(String featureName, String value) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            EObject eObject = XtextUtils.getEObject(i, this.resource);
            String v = XtextUtils.eString(XtextUtils.egetAndResolve(eObject, featureName, this.resource.getResourceSet()));
            if (!v.contains(value)) continue;
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("no elements found with feature " + featureName + " valued '" + value + "'");
        }
        return res;
    }

    public FluentIssueCollection except(Set<Issue> toBeRemoved) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        if (toBeRemoved != null) {
            for (Issue i : this.issues) {
                if (toBeRemoved.contains(i)) continue;
                res.addIssue(i);
            }
        }
        return res;
    }

    public FluentIssueCollection errorsOnly() {
        Severity severity = Severity.ERROR;
        return this.withSeverity(severity);
    }

    public FluentIssueCollection warningsOnly() {
        Severity severity = Severity.WARNING;
        return this.withSeverity(severity);
    }

    public FluentIssueCollection withSeverity(Severity ... severities) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            if (!Iterables.contains(Arrays.asList(severities), (Object)i.getSeverity())) continue;
            res.addIssue(i);
        }
        return res;
    }

    public FluentIssueCollection named(String expectedName) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            EObject eObject = XtextUtils.getEObject(i, this.resource);
            String name = XtextUtils.name(eObject);
            if (!name.contains(expectedName)) continue;
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("no elements found with name " + expectedName);
        }
        return res;
    }

    public FluentIssueCollection forElement(Class<? extends EObject> cls, String name) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            EObject eObject = XtextUtils.getEObject(i, this.resource);
            if (!cls.isInstance(eObject) || !name.equalsIgnoreCase(XtextUtils.name(eObject))) continue;
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("no elements of type " + cls.getName() + " named '" + name + "' found");
        }
        return res;
    }

    private int getIssueCount() {
        return this.issues.size();
    }

    public FluentIssueCollection under(Class<? extends EObject> cls) {
        return this.under(cls, null);
    }

    public FluentIssueCollection under(Class<? extends EObject> cls, String name) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            URI uri = i.getUriToProblem();
            EObject eObject = this.resource.getEObject(uri.fragment());
            EObject p = XtextUtils.ancestor(eObject, cls);
            if (p == null) continue;
            if (name != null) {
                if (!name.equals(XtextUtils.name(p))) continue;
                res.addIssue(i);
                continue;
            }
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("did not find issues under a " + cls.getName() + " named '" + name + "'");
        }
        return res;
    }

    public FluentIssueCollection sizeIs(int i) {
        if (this.issues.size() == i) {
            this.state = true;
        } else {
            this.addMessage("failed size: expected " + i + ", actual " + this.issues.size());
            this.state = false;
        }
        return this;
    }

    public FluentIssueCollection oneOfThemContains(String substring) {
        boolean found = false;
        for (Issue i : this.issues) {
            if (!i.getMessage().toLowerCase().contains(substring.toLowerCase())) continue;
            found = true;
        }
        if (found) {
            this.reportOk();
        } else {
            this.addMessage("failed oneOfThemContains: none of the issues contains substring '" + substring + "'");
            this.reportError();
        }
        return this;
    }

    public FluentIssueCollection nOfThemContain(int n, String substring) {
        int count = 0;
        for (Issue i : this.issues) {
            if (!i.getMessage().toLowerCase().contains(substring.toLowerCase())) continue;
            ++count;
        }
        if (count == n) {
            this.reportOk();
        } else {
            this.addMessage("failed nOfThemContain: expected " + n + " with substring '" + substring + "', but '" + count + "' found.");
            this.reportError();
        }
        return this;
    }

    public FluentIssueCollection allOfThemContain(String substring) {
        for (Issue i : this.issues) {
            if (i.getMessage().toLowerCase().contains(substring.toLowerCase())) continue;
            this.reportError();
            this.addMessage("failed allOfThemContain: not all issues contain the substring '" + substring + "'");
        }
        this.reportOk();
        return this;
    }

    public FluentIssueCollection theOneAndOnlyContains(String substring) {
        if (this.issues.size() > 1) {
            this.reportError();
            this.addMessage("failed theOneAndOnlyContains: expecting a single issue (theSingleOneReads) but found: " + this.issues.size());
            for (Issue issue : this.issues) {
                LOGGER.debug((Object)("  line " + issue.getLineNumber() + ": " + issue.getMessage() + " / " + issue.getUriToProblem()));
            }
            return this;
        }
        return this.oneOfThemContains(substring);
    }

    public FluentIssueCollection withCode(String code) {
        FluentIssueCollection res = new FluentIssueCollection(this.resource, this.messages);
        for (Issue i : this.issues) {
            if (!i.getCode().equals(code)) continue;
            res.addIssue(i);
        }
        if (res.getIssueCount() == 0) {
            res.addMessage("failed withCode: no issues found with code '" + code + "'");
        }
        return res;
    }

    public boolean evaluate() {
        return this.state;
    }

    protected void reportOk() {
        if (this.stateIsSet) {
            if (this.state) {
                this.state = true;
            }
            if (!this.state) {
                this.state = false;
            }
        } else {
            this.state = true;
        }
        this.stateIsSet = true;
    }

    protected void reportError() {
        if (this.stateIsSet) {
            if (this.state) {
                this.state = false;
            }
            if (!this.state) {
                this.state = false;
            }
        } else {
            this.state = false;
        }
        this.stateIsSet = true;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public Resource getResource() {
        return this.resource;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getMessageString() {
        StringBuffer sb = new StringBuffer();
        for (String m : this.messages) {
            sb.append("\n  - " + m);
        }
        return sb.toString();
    }

    public void dumpIssues() {
        LOGGER.debug((Object)"--- Issues ---");
        for (Issue i : this.issues) {
            FluentIssueCollection.dumpIssue(this.resource, i);
        }
    }

    public String getSummary() {
        if (this.issues.size() == 0) {
            return "No issues";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Issues:");
        for (Issue i : this.issues) {
            sb.append("\n  - " + FluentIssueCollection.getIssueSummary(this.resource, i));
        }
        return sb.toString();
    }

    public static void dumpIssue(Resource resource, Issue issue) {
        LOGGER.debug((Object)FluentIssueCollection.getIssueSummary(resource, issue));
    }

    public static String getIssueSummary(Resource resource, Issue issue) {
        boolean validFragment = true;
        if ("//".equals(issue.getUriToProblem().fragment())) {
            validFragment = false;
        }
        if (validFragment) {
            EObject eObject = resource.getEObject(issue.getUriToProblem().fragment());
            EClass cls = eObject.eClass();
            return issue.getSeverity() + " at " + cls.getName() + "( line " + issue.getLineNumber() + "): " + issue.getMessage();
        }
        return issue.getSeverity() + "( line " + issue.getLineNumber() + "): " + issue.getMessage();
    }

    @Override
    public Iterator<Issue> iterator() {
        return this.issues.iterator();
    }
}

