/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.xtext.utils.unittesting;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipselabs.xtext.utils.unittesting.FluentIssueCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XtextTest {
    protected String resourceRoot;
    protected FluentIssueCollection issues;
    private Set<Issue> assertedIssues;
    private boolean compareSerializedModelToInputFile;
    private boolean invokeSerializer;
    private boolean formatOnSerialize;
    private boolean failOnParserWarnings;
    private boolean ignoreOsSpecificNewline;
    private EObject rootElement;
    private static Logger LOGGER = Logger.getLogger(XtextTest.class);
    @Inject
    protected ResourceSet resourceSet;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private IGrammarAccess grammar;
    @Inject
    private IParser parser;
    @Inject
    private Lexer lexer;
    @Inject
    private ITokenDefProvider tokenDefProvider;

    public XtextTest() {
        this("/");
    }

    public XtextTest(String resourceRoot) {
        this.resourceRoot = !resourceRoot.contains(":/") ? "classpath:/" + resourceRoot : resourceRoot;
    }

    @BeforeClass
    public static void init_internal() {
        new StandaloneSetup().setPlatformUri("..");
    }

    @Before
    @Deprecated
    public void before() {
    }

    @Before
    public final void _before() {
        this.issues = null;
        this.assertedIssues = new HashSet<Issue>();
        this.invokeSerializer = true;
        this.compareSerializedModelToInputFile = true;
        this.formatOnSerialize = true;
        this.failOnParserWarnings = true;
    }

    private void ensureIsBeforeTestFile() {
        if (this.issues != null) {
            throw new RuntimeException("Method " + new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName() + " must be run BEFORE 'testFile' is executed!");
        }
    }

    private void ensureIsAfterTestFile() {
        if (this.issues == null) {
            throw new RuntimeException("Method " + new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName() + " must be run AFTER 'testFile' is executed!");
        }
    }

    @After
    @Deprecated
    public void after() {
    }

    @After
    public void _after() {
        if (this.issues != null) {
            this.dumpUnassertedIssues();
            if (this.issues.except(this.assertedIssues).getIssues().size() != 0) {
                junit.framework.Assert.fail((String)("\n\nfound unasserted issues " + this.issues.except(this.assertedIssues).getSummary() + "\n\n"));
            }
        }
    }

    protected EObject getModelRoot() {
        return this.rootElement;
    }

    protected FluentIssueCollection testFile(String fileToTest, String ... referencedResources) {
        LOGGER.info((Object)("testing " + fileToTest + " in test method " + this.getClass().getSimpleName() + "." + new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName()));
        String[] stringArray = referencedResources;
        int n = referencedResources.length;
        int n2 = 0;
        while (n2 < n) {
            String referencedResource = stringArray[n2];
            URI uri = URI.createURI((String)(String.valueOf(this.resourceRoot) + "/" + referencedResource));
            this.loadModel(this.resourceSet, uri, this.getRootObjectType(uri));
            ++n2;
        }
        Pair<String, FluentIssueCollection> result = this.loadAndSaveModule(this.resourceRoot, fileToTest);
        String serialized = (String)result.getFirst();
        if (this.compareSerializedModelToInputFile) {
            String expected = this.loadFileContents(this.resourceRoot, fileToTest);
            if (this.ignoreOsSpecificNewline) {
                expected = expected.replaceAll("(\r\n|\r)", "\n");
                serialized = serialized.replaceAll("(\r\n|\r)", "\n");
            }
            Assert.assertEquals((Object)expected.trim(), (Object)serialized.trim());
        }
        this.issues = (FluentIssueCollection)result.getSecond();
        return this.issues;
    }

    protected FluentIssueCollection testFileNoSerializer(String fileToTest, String ... referencedResources) {
        this.suppressSerialization();
        return this.testFile(fileToTest, referencedResources);
    }

    protected void testParserRule(String textToParse, String ruleName) {
        this.testParserRule(textToParse, ruleName, false);
    }

    private List<SyntaxErrorMessage> testParserRule(String textToParse, String ruleName, boolean errorsExpected) {
        ParserRule parserRule = (ParserRule)GrammarUtil.findRuleForName((Grammar)this.grammar.getGrammar(), (String)ruleName);
        if (parserRule == null) {
            Assert.fail((String)("\n\nCould not find ParserRule " + ruleName + "\n\n"));
        }
        IParseResult result = this.parser.parse(parserRule, (Reader)new StringReader(textToParse));
        ArrayList errors = Lists.newArrayList();
        ArrayList errMsg = Lists.newArrayList();
        for (INode err : result.getSyntaxErrors()) {
            errors.add(err.getSyntaxErrorMessage());
            errMsg.add(err.getSyntaxErrorMessage().getMessage());
        }
        if (!errorsExpected && !errors.isEmpty()) {
            Assert.fail((String)("\n\nParsing of text '" + textToParse + "' for rule '" + ruleName + "' failed with errors: " + errMsg + "\n\n"));
        }
        if (errorsExpected && errors.isEmpty()) {
            Assert.fail((String)("\n\nParsing of text '" + textToParse + "' for rule '" + ruleName + "' was expected to have parse errors.\n\n"));
        }
        return errors;
    }

    protected void testParserRuleErrors(String textToParse, String ruleName, String ... expectedErrorSubstrings) {
        int n;
        List<SyntaxErrorMessage> errors = this.testParserRule(textToParse, ruleName, true);
        HashSet<String> matchingSubstrings = new HashSet<String>();
        HashSet<String> assertedErrors = new HashSet<String>();
        boolean hadError = false;
        for (SyntaxErrorMessage err : errors) {
            String[] stringArray = expectedErrorSubstrings;
            int n2 = expectedErrorSubstrings.length;
            n = 0;
            while (n < n2) {
                String substring = stringArray[n];
                boolean contains = err.getMessage().contains(substring);
                if (contains) {
                    matchingSubstrings.add(substring);
                }
                ++n;
            }
            assertedErrors.add(err.getMessage());
        }
        StringBuilder error = new StringBuilder();
        if (expectedErrorSubstrings.length != matchingSubstrings.size()) {
            error.append("Unmatched assertions:");
            String[] stringArray = expectedErrorSubstrings;
            n = expectedErrorSubstrings.length;
            int n3 = 0;
            while (n3 < n) {
                String string = stringArray[n3];
                if (!matchingSubstrings.contains(string)) {
                    error.append("\n  - any error containing '" + string + "'");
                }
                ++n3;
            }
            error.append("\n");
            hadError = true;
        }
        if (assertedErrors.size() != errors.size()) {
            error.append("Unasserted Errors:");
            for (SyntaxErrorMessage err : errors) {
                if (assertedErrors.contains(err.getMessage())) continue;
                error.append("\n  - " + err.getMessage());
            }
        }
        String failMessage = error.toString();
        if (hadError || !failMessage.equals("") && this.failOnParserWarnings) {
            Assert.fail((String)("\n\n" + failMessage + "\n\n"));
        }
    }

    protected List<Token> getTokens(String input) {
        ANTLRStringStream stream = new ANTLRStringStream(input);
        this.lexer.setCharStream((CharStream)stream);
        XtextTokenStream tokenStream = new XtextTokenStream((TokenSource)this.lexer, this.tokenDefProvider);
        List tokens = tokenStream.getTokens();
        return tokens;
    }

    protected String getTokenType(Token token) {
        return (String)this.tokenDefProvider.getTokenDefMap().get(token.getType());
    }

    protected void testTerminal(String input, String ... expectedTerminals) {
        List<Token> tokens = this.getTokens(input);
        Assert.assertEquals((String)input, (long)expectedTerminals.length, (long)tokens.size());
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.get(i);
            String exp = expectedTerminals[i];
            if (!exp.startsWith("'")) {
                exp = "RULE_" + exp;
            }
            Assert.assertEquals((String)input, (Object)exp, (Object)this.getTokenType(token));
            ++i;
        }
    }

    protected void testNotTerminal(String input, String unexpectedTerminal) {
        List<Token> tokens = this.getTokens(input);
        Token token = tokens.get(0);
        Assert.assertNotSame((String)input, (Object)("RULE_" + unexpectedTerminal), (Object)this.getTokenType(token));
    }

    protected void testKeyword(String input) {
        String rule = "'" + input + "'";
        this.testTerminal(input, rule);
    }

    protected void testNoKeyword(String keyword) {
        List<Token> tokens = this.getTokens(keyword);
        Assert.assertEquals((String)keyword, (long)1L, (long)tokens.size());
        String type = this.getTokenType(tokens.get(0));
        Assert.assertFalse((String)keyword, (type.charAt(0) == '\'' ? 1 : 0) != 0);
    }

    protected String loadFileContents(String rootPath, String filename) {
        URI uri = URI.createURI((String)(String.valueOf(this.resourceRoot) + "/" + filename));
        try {
            int i;
            InputStream is = this.resourceSet.getURIConverter().createInputStream(uri);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((i = is.read()) >= 0) {
                bos.write(i);
            }
            is.close();
            bos.close();
            return bos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Pair<String, FluentIssueCollection> loadAndSaveModule(String rootPath, String filename) {
        URI uri = URI.createURI((String)(String.valueOf(this.resourceRoot) + "/" + filename));
        this.rootElement = this.loadModel(this.resourceSet, uri, this.getRootObjectType(uri));
        Resource r = this.resourceSet.getResource(uri, false);
        IResourceServiceProvider provider = this.serviceProviderRegistry.getResourceServiceProvider(r.getURI());
        List result = provider.getResourceValidator().validate(r, CheckMode.ALL, null);
        if (this.invokeSerializer) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                SaveOptions.Builder builder = SaveOptions.newBuilder();
                if (this.formatOnSerialize) {
                    builder.format();
                }
                SaveOptions s = builder.getOptions();
                this.rootElement.eResource().save((OutputStream)bos, s.toOptionsMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Tuples.create((Object)bos.toString(), (Object)new FluentIssueCollection(r, result, new ArrayList<String>()));
        }
        return Tuples.create((Object)"-not serialized-", (Object)new FluentIssueCollection(r, result, new ArrayList<String>()));
    }

    protected Class<? extends EObject> getRootObjectType(URI uri) {
        return null;
    }

    public void setResourceRoot(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    protected <T extends EObject> T loadModel(ResourceSet rs, URI uri, Class<T> clazz) {
        String failMessage;
        Resource resource = rs.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StringBuilder errors = new StringBuilder();
        if (!resource.getWarnings().isEmpty()) {
            LOGGER.error((Object)("Resource " + uri.toString() + " has warnings:"));
            for (Resource.Diagnostic issue : resource.getWarnings()) {
                LOGGER.error((Object)(String.valueOf(issue.getLine()) + ": " + issue.getMessage()));
            }
            if (this.failOnParserWarnings) {
                errors.append("Resource as warnings:");
                for (Resource.Diagnostic issue : resource.getWarnings()) {
                    errors.append("\n  - " + issue.getLine() + ": " + issue.getMessage());
                }
                errors.append("/n");
            }
        }
        if (!resource.getErrors().isEmpty()) {
            LOGGER.error((Object)("Resource " + uri.toString() + " has errors:"));
            for (Resource.Diagnostic issue : resource.getErrors()) {
                LOGGER.error((Object)("    " + issue.getLine() + ": " + issue.getMessage()));
            }
            errors.append("Resource as errors:");
            for (Resource.Diagnostic issue : resource.getErrors()) {
                errors.append("\n  - " + issue.getLine() + ": " + issue.getMessage());
            }
        }
        if (!(failMessage = errors.toString()).equals("")) {
            Assert.fail((String)("\n\n" + failMessage + "\n"));
        }
        Assert.assertFalse((String)"Resource has no content", (boolean)resource.getContents().isEmpty());
        EObject o = (EObject)resource.getContents().get(0);
        if (clazz != null) {
            Assert.assertTrue((boolean)clazz.isInstance(o));
        }
        EcoreUtil.resolveAll((Resource)resource);
        return (T)o;
    }

    protected void assertAllCrossReferencesResolvable(EObject obj) {
        boolean allIsGood = true;
        TreeIterator it = EcoreUtil2.eAll((EObject)obj);
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            for (EObject cr : o.eCrossReferences()) {
                if (!cr.eIsProxy()) continue;
                allIsGood = false;
                System.err.println("CrossReference from " + EmfFormatter.objPath((EObject)o) + " to " + ((InternalEObject)cr).eProxyURI() + " not resolved.");
            }
        }
        if (!allIsGood) {
            Assert.fail((String)("Unresolved cross references in " + EmfFormatter.objPath((EObject)obj)));
        }
    }

    protected void resetAssertedIssues() {
        this.assertedIssues.clear();
    }

    protected void ignoreSerializationDifferences() {
        this.ensureIsBeforeTestFile();
        this.compareSerializedModelToInputFile = false;
    }

    protected void suppressSerialization() {
        this.ensureIsBeforeTestFile();
        this.compareSerializedModelToInputFile = false;
        this.invokeSerializer = false;
    }

    protected void ignoreParserWarnings() {
        this.ensureIsBeforeTestFile();
        this.failOnParserWarnings = false;
    }

    protected void ignoreFormattingDifferences() {
        this.ensureIsBeforeTestFile();
        this.formatOnSerialize = false;
    }

    protected void ignoreUnassertedWarnings() {
        this.ensureIsAfterTestFile();
        this.assertedIssues.addAll(this.issues.warningsOnly().except(this.assertedIssues).getIssues());
    }

    protected void ignoreOsSpecificNewline() {
        this.ignoreOsSpecificNewline = true;
    }

    protected void assertConstraints(FluentIssueCollection coll, String msg) {
        this.ensureIsAfterTestFile();
        this.assertedIssues.addAll(coll.getIssues());
        junit.framework.Assert.assertTrue((String)("failed " + msg + coll.getMessageString()), (boolean)coll.evaluate());
    }

    protected void assertConstraints(FluentIssueCollection coll) {
        this.ensureIsAfterTestFile();
        this.assertedIssues.addAll(coll.getIssues());
        junit.framework.Assert.assertTrue((String)("<no id> failed" + coll.getMessageString()), (boolean)coll.evaluate());
    }

    protected void assertConstraints(String constraintID, FluentIssueCollection coll) {
        this.ensureIsAfterTestFile();
        this.assertedIssues.addAll(coll.getIssues());
        junit.framework.Assert.assertTrue((String)(String.valueOf(constraintID) + " failed" + coll.getMessageString()), (boolean)coll.evaluate());
    }

    public EObject getEObject(URI uri) {
        EObject eObject = this.issues.getResource().getEObject(uri.fragment());
        if (eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (Resource)this.issues.getResource());
        }
        return eObject;
    }

    private void dumpUnassertedIssues() {
        if (this.issues.except(this.assertedIssues).getIssues().size() > 0) {
            LOGGER.warn((Object)"---- Unasserted Issues ----");
            for (Issue issue : this.issues.except(this.assertedIssues)) {
                FluentIssueCollection.dumpIssue(this.issues.getResource(), issue);
            }
        }
    }
}

