/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.xtext.utils.unittesting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextUtils {
    public static <C extends EObject> C ancestor(EObject ctx, Class<C> ancestorClass) {
        return (C)EcoreUtil2.getContainerOfType((EObject)ctx, ancestorClass);
    }

    public static EObject ancestor(EObject ctx, EClass ancClass) {
        EObject anc = ctx.eContainer();
        while (anc != null) {
            if (ancClass.isInstance((Object)anc)) {
                return anc;
            }
            anc = anc.eContainer();
        }
        return null;
    }

    public static List<EObject> ancestors(EObject ctx, EClass ancClass) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        EObject anc = ctx.eContainer();
        while (anc != null) {
            if (ancClass.isInstance((Object)anc)) {
                res.add(anc);
            }
            anc = anc.eContainer();
        }
        return res;
    }

    public static boolean nullTolerantEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static String name(EObject object) {
        EStructuralFeature namefeature = object.eClass().getEStructuralFeature("name");
        if (namefeature == null) {
            return null;
        }
        return (String)object.eGet(namefeature);
    }

    public static String eString(EObject eObject) {
        if (eObject instanceof EClass) {
            return ((EClass)eObject).getName();
        }
        String name = XtextUtils.name(eObject);
        String res = name != null ? String.valueOf(eObject.eClass().getName()) + "/" + name : eObject.eClass().getName();
        if (eObject.eIsProxy()) {
            res = String.valueOf(res) + "[proxy]";
        }
        return res;
    }

    public static Object eget(EObject eObject, String featureName) {
        Object val = eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
        return val;
    }

    public static EObject egetAndResolve(EObject eObject, String featureName, ResourceSet rs) {
        EObject val = (EObject)XtextUtils.eget(eObject, featureName);
        return XtextUtils.resolveProxy(val, rs);
    }

    public static EObject getEObject(Issue issue, Resource r) {
        URI uri = issue.getUriToProblem();
        EObject eObject = r.getEObject(uri.fragment());
        return eObject;
    }

    public static EObject resolveProxy(EObject eObject, ResourceSet rs) {
        if (eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)rs);
        }
        return eObject;
    }
}

