/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicEnumBuilder;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceWorkbenchXMLProject;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.w3c.dom.Document;

public class DynamicTypeBuilder {
    static XMLParser xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
    protected DynamicTypeImpl entityType;

    public DynamicTypeBuilder(Class<?> dynamicClass, DynamicType parentType, String ... tableNames) {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(dynamicClass);
        this.entityType = new DynamicTypeImpl(descriptor, parentType);
        if (DynamicEntity.class.isAssignableFrom(dynamicClass)) {
            try {
                Field dpmField = dynamicClass.getField("DPM");
                DynamicPropertiesManager dpm = (DynamicPropertiesManager)dpmField.get(null);
                dpm.setType(this.entityType);
                this.entityType.setDynamicPropertiesManager(dpm);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.configure(descriptor, tableNames);
    }

    public DynamicTypeBuilder(DynamicClassLoader dcl, ClassDescriptor descriptor, DynamicType parentType) {
        this.entityType = new DynamicTypeImpl(descriptor, parentType);
        Class dynamicClass = descriptor.getJavaClass();
        if (dynamicClass == null) {
            this.addDynamicClasses(dcl, descriptor.getJavaClassName(), parentType);
        } else if (DynamicEntity.class.isAssignableFrom(dynamicClass)) {
            try {
                Field dpmField = descriptor.getJavaClass().getField("DPM");
                DynamicPropertiesManager dpm = (DynamicPropertiesManager)dpmField.get(null);
                dpm.setType(this.entityType);
                this.entityType.setDynamicPropertiesManager(dpm);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.configure(descriptor, new String[0]);
    }

    protected void addDynamicClasses(DynamicClassLoader dcl, String className, DynamicType parentType) {
        if (parentType == null) {
            dcl.addClass(className);
        } else if (parentType.getJavaClass() == null) {
            dcl.addClass(className, new DynamicClassWriter(parentType.getClassName()));
        } else {
            dcl.addClass(className, parentType.getJavaClass());
        }
    }

    protected void configure(ClassDescriptor descriptor, String ... tableNames) {
        int index;
        if (tableNames != null) {
            if (tableNames.length == 0) {
                if (descriptor.getTables().size() == 0) {
                    descriptor.descriptorIsAggregate();
                }
            } else {
                index = 0;
                while (index < tableNames.length) {
                    descriptor.addTableName(tableNames[index]);
                    ++index;
                }
            }
        }
        index = 0;
        while (index < descriptor.getMappings().size()) {
            this.addMapping(descriptor.getMappings().get(index));
            ++index;
        }
        descriptor.setProperty("ENTITY_TYPE", this.entityType);
    }

    public DynamicType getType() {
        return this.entityType;
    }

    private boolean requiresInitialization(DatabaseMapping mapping) {
        if (mapping.isDirectToFieldMapping() && mapping.getAttributeClassification() != null && mapping.getAttributeClassification().isPrimitive()) {
            return true;
        }
        if (mapping.isForeignReferenceMapping()) {
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
            return frMapping.usesIndirection() || frMapping.isCollectionMapping();
        }
        if (mapping.isAggregateObjectMapping() && !mapping.isXMLMapping()) {
            return !((AggregateObjectMapping)mapping).isNullAllowed();
        }
        return false;
    }

    public void setPrimaryKeyFields(String ... pkFieldNames) {
        if (pkFieldNames != null && pkFieldNames.length > 0) {
            int index = 0;
            while (index < pkFieldNames.length) {
                DatabaseField pkField = new DatabaseField(pkFieldNames[index]);
                if (!this.getType().getDescriptor().getPrimaryKeyFields().contains(pkField)) {
                    this.getType().getDescriptor().addPrimaryKeyFieldName(pkFieldNames[index]);
                }
                ++index;
            }
        }
    }

    public DirectToFieldMapping addDirectMapping(String name, Class<?> javaType, String fieldName) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setAttributeName(name);
        mapping.setFieldName(fieldName);
        mapping.setAttributeClassification(javaType);
        return (DirectToFieldMapping)this.addMapping(mapping);
    }

    public OneToOneMapping addOneToOneMapping(String name, DynamicType refType, String ... fkFieldNames) {
        if (fkFieldNames == null || refType.getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: " + refType);
        }
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        int index = 0;
        while (index < fkFieldNames.length) {
            String targetField = refType.getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addForeignKeyFieldName(fkFieldNames[index], targetField);
            ++index;
        }
        return (OneToOneMapping)this.addMapping(mapping);
    }

    public OneToManyMapping addOneToManyMapping(String name, DynamicType refType, String ... fkFieldNames) {
        if (fkFieldNames == null || this.getType().getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: " + refType);
        }
        OneToManyMapping mapping = new OneToManyMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        int index = 0;
        while (index < fkFieldNames.length) {
            String targetField = this.getType().getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addTargetForeignKeyFieldName(fkFieldNames[index], targetField);
            ++index;
        }
        mapping.useTransparentList();
        return (OneToManyMapping)this.addMapping(mapping);
    }

    public DirectCollectionMapping addDirectCollectionMapping(String name, String targetTable, String valueColumn, Class<?> valueType, String ... fkFieldNames) throws IllegalArgumentException {
        if (fkFieldNames == null || this.getType().getDescriptor().getPrimaryKeyFields().size() != fkFieldNames.length) {
            throw new IllegalArgumentException("Invalid FK field names: " + fkFieldNames + " for target: ");
        }
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceTableName(targetTable);
        mapping.setDirectFieldName(valueColumn);
        mapping.setDirectFieldClassification(valueType);
        int index = 0;
        while (index < fkFieldNames.length) {
            String targetField = this.getType().getDescriptor().getPrimaryKeyFields().get(index).getName();
            mapping.addReferenceKeyFieldName(fkFieldNames[index], targetField);
            ++index;
        }
        mapping.useTransparentList();
        return (DirectCollectionMapping)this.addMapping(mapping);
    }

    public AggregateObjectMapping addAggregateObjectMapping(String name, DynamicType refType, boolean allowsNull) {
        AggregateObjectMapping mapping = new AggregateObjectMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        mapping.setIsNullAllowed(allowsNull);
        return (AggregateObjectMapping)this.addMapping(mapping);
    }

    public void addManyToManyMapping(String name, DynamicType refType, String relationshipTableName) {
        ManyToManyMapping mapping = new ManyToManyMapping();
        mapping.setAttributeName(name);
        mapping.setReferenceClass(refType.getJavaClass());
        mapping.setRelationTableName(relationshipTableName);
        for (DatabaseField sourcePK : this.getType().getDescriptor().getPrimaryKeyFields()) {
            mapping.addSourceRelationKeyFieldName(sourcePK.getName(), sourcePK.getQualifiedName());
        }
        for (DatabaseField targetPK : refType.getDescriptor().getPrimaryKeyFields()) {
            String relField = targetPK.getName();
            if (mapping.getSourceRelationKeyFieldNames().contains(relField)) {
                relField = String.valueOf(refType.getName()) + "_" + relField;
            }
            mapping.addTargetRelationKeyFieldName(relField, targetPK.getQualifiedName());
        }
        mapping.useTransparentList();
        this.addMapping(mapping);
    }

    public DatabaseMapping addMapping(DatabaseMapping mapping) {
        String typeName;
        ClassDescriptor descriptor = this.getType().getDescriptor();
        if (!descriptor.getMappings().contains(mapping)) {
            descriptor.addMapping(mapping);
        }
        descriptor.getMappings().indexOf(mapping);
        if (this.getType().getParentType() != null) {
            DynamicType current = this.getType();
            while (current.getParentType() != null) {
                current.getParentType().getDescriptor().getMappings().size();
                current = current.getParentType();
            }
        }
        if (mapping.getAttributeClassification() == null && mapping.isAbstractDirectMapping() && (typeName = ((AbstractDirectMapping)mapping).getAttributeClassificationName()) != null) {
            typeName = typeName.trim();
            try {
                Class attrType = ConversionManager.getDefaultManager().convertClassNameToClass(typeName);
                ((AbstractDirectMapping)mapping).setAttributeClassification(attrType);
            }
            catch (Exception exception) {}
        }
        mapping.setAttributeAccessor(new ValuesAccessor(mapping));
        if (this.requiresInitialization(mapping)) {
            this.entityType.getMappingsRequiringInitialization().add(mapping);
        }
        return mapping;
    }

    public void configureSequencing(String numberName, String numberFieldName) {
        this.getType().getDescriptor().setSequenceNumberName(numberName);
        this.getType().getDescriptor().setSequenceNumberFieldName(numberFieldName);
    }

    public void configureSequencing(Sequence sequence, String numberName, String numberFieldName) {
        this.configureSequencing(numberName, numberFieldName);
        this.getType().getDescriptor().setSequence(sequence);
    }

    public DynamicEnumBuilder addEnum(String fieldName, String className, String columnName, DynamicClassLoader dcl) {
        dcl.addEnum(className, new Object[]{null});
        this.getType().getDescriptor();
        AbstractDirectMapping adm = this.addDirectMappingForEnum(fieldName, className, columnName);
        return new DynamicEnumBuilder(className, adm, dcl);
    }

    protected AbstractDirectMapping addDirectMappingForEnum(String fieldName, String className, String columnName) {
        DirectToFieldMapping dtfm = this.addDirectMapping(fieldName, null, columnName);
        dtfm.setConverter(new EnumTypeConverter(dtfm, className));
        this.addMapping(dtfm);
        return dtfm;
    }

    public static Project loadDynamicProject(String resourcePath, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) throws IOException {
        if (resourcePath == null) {
            throw new NullPointerException("null resourceStream");
        }
        if (dynamicClassLoader == null) {
            throw new NullPointerException("null dynamicClassLoader");
        }
        return DynamicTypeBuilder.loadDynamicProject(dynamicClassLoader.getResourceAsStream(resourcePath), login, dynamicClassLoader);
    }

    public static Project loadDynamicProject(InputStream resourceStream, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) throws IOException {
        if (resourceStream == null) {
            throw new NullPointerException("null resourceStream");
        }
        if (dynamicClassLoader == null) {
            throw new NullPointerException("null dynamicClassLoader");
        }
        ObjectPersistenceWorkbenchXMLProject opmProject = new ObjectPersistenceWorkbenchXMLProject();
        Document document = xmlParser.parse(resourceStream);
        Project project = XMLProjectReader.readObjectPersistenceRuntimeFormat(document, dynamicClassLoader, opmProject);
        return DynamicTypeBuilder.loadDynamicProject(project, login, dynamicClassLoader);
    }

    public static Project loadDynamicProject(Project project, DatabaseLogin login, DynamicClassLoader dynamicClassLoader) {
        if (project != null) {
            if (login == null) {
                if (project.getLogin() == null) {
                    project.setLogin(new DatabaseLogin());
                }
            } else {
                project.setLogin(login);
            }
            if (project.getLogin().getPlatform() == null) {
                project.getLogin().setPlatform(new DatabasePlatform());
            }
            project.getLogin().getPlatform().getConversionManager().setLoader(dynamicClassLoader);
            for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                DynamicTypeBuilder.createType(dynamicClassLoader, descriptor, project);
            }
            project.convertClassNamesToClasses(dynamicClassLoader);
            for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
                Class dynamicClass = descriptor.getJavaClass();
                if (dynamicClass == null || !DynamicEntity.class.isAssignableFrom(dynamicClass)) continue;
                DynamicType type = DynamicHelper.getType(descriptor);
                try {
                    Field dpmField = descriptor.getJavaClass().getField("DPM");
                    DynamicPropertiesManager dpm = (DynamicPropertiesManager)dpmField.get(null);
                    dpm.setType(type);
                    ((DynamicTypeImpl)type).setDynamicPropertiesManager(dpm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return project;
    }

    private static DynamicType createType(DynamicClassLoader dcl, ClassDescriptor descriptor, Project project) {
        DynamicType type;
        Class<?> javaClass = null;
        try {
            javaClass = dcl.loadClass(descriptor.getJavaClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (javaClass != null) {
            descriptor.setJavaClass(javaClass);
        }
        DynamicType parent = null;
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getParentClassName() != null) {
            ClassDescriptor parentDesc = null;
            Iterator<ClassDescriptor> i = project.getOrderedDescriptors().iterator();
            while (parentDesc == null && i.hasNext()) {
                ClassDescriptor d = i.next();
                if (!d.getJavaClassName().equals(descriptor.getInheritancePolicy().getParentClassName())) continue;
                parentDesc = d;
            }
            if (parentDesc == null) {
                throw ValidationException.missingDescriptor(descriptor.getInheritancePolicy().getParentClassName());
            }
            parent = DynamicHelper.getType(parentDesc);
            if (parent == null) {
                parent = DynamicTypeBuilder.createType(dcl, parentDesc, project);
            }
        }
        if ((type = DynamicHelper.getType(descriptor)) == null) {
            type = new DynamicTypeBuilder(dcl, descriptor, parent).getType();
        }
        if (javaClass != null && DynamicEntity.class.isAssignableFrom(javaClass)) {
            try {
                Field dpmField = javaClass.getField("DPM");
                DynamicPropertiesManager dpm = (DynamicPropertiesManager)dpmField.get(null);
                dpm.setType(type);
                ((DynamicTypeImpl)type).setDynamicPropertiesManager(dpm);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return type;
    }
}

