/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.CollectionDecorator;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceCollection;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceList<T>
extends ReferenceCollection<T>
implements List<T> {
    private static final long serialVersionUID = 1L;
    private final List<Referrer<T>> list;

    ReferenceList(List<Referrer<T>> list, Ref type, boolean gcThreads, long gcCycle) {
        super(list, type, gcThreads, gcCycle);
        this.list = list;
    }

    ReferenceList(List<Referrer<T>> list, ReferenceQueuingFactory<T, Referrer<T>> rqf, Ref type) {
        super(list, rqf, type);
        this.list = list;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        Iterator li = this.iterator();
        int i = 0;
        while (li.hasNext()) {
            Object t = li.next();
            if (t != null ? !t.equals(l.get(i)) : l.get(i) != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.processQueue();
        return this.list.addAll(index, new CollectionDecorator<T>(c, this.getRQF(), true, false));
    }

    @Override
    public T get(int index) {
        this.processQueue();
        Referrer<T> r = this.list.get(index);
        if (r != null) {
            return r.get();
        }
        return null;
    }

    @Override
    public T set(int index, T element) {
        this.processQueue();
        Referrer<T> r = this.list.set(index, this.wrapObj(element, true, false));
        if (r != null) {
            return r.get();
        }
        return null;
    }

    @Override
    public void add(int index, T element) {
        this.processQueue();
        this.list.add(index, this.wrapObj(element, true, false));
    }

    @Override
    public T remove(int index) {
        this.processQueue();
        Referrer<T> r = this.list.remove(index);
        if (r != null) {
            return r.get();
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        this.processQueue();
        return this.list.indexOf(this.wrapObj(o, false, true));
    }

    @Override
    public int lastIndexOf(Object o) {
        this.processQueue();
        return this.list.lastIndexOf(this.wrapObj(o, false, true));
    }

    @Override
    public ListIterator<T> listIterator() {
        this.processQueue();
        return new ReferenceListIterator(this.list.listIterator(), this.getRQF());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        this.processQueue();
        return new ReferenceListIterator(this.list.listIterator(index), this.getRQF());
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.processQueue();
        ReferenceList<T> sub = new ReferenceList<T>(this.list.subList(fromIndex, toIndex), this.getRQF(), null);
        return sub;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReferenceListIterator<T>
    implements ListIterator<T> {
        ListIterator<Referrer<T>> iterator;
        ReferenceQueuingFactory<T, Referrer<T>> rqf;

        private ReferenceListIterator(ListIterator<Referrer<T>> iterator, ReferenceQueuingFactory<T, Referrer<T>> rqf) {
            if (iterator == null || rqf == null) {
                throw new NullPointerException("Null iterator or reference queuing factory not allowed");
            }
            this.iterator = iterator;
            this.rqf = rqf;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            Referrer<T> t = this.iterator.next();
            if (t != null) {
                return t.get();
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            Referrer<T> t = this.iterator.previous();
            if (t != null) {
                return t.get();
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void set(T e) {
            this.iterator.set(this.rqf.referenced(e, true, false));
        }

        @Override
        public void add(T e) {
            this.iterator.add(this.rqf.referenced(e, true, false));
        }
    }
}

