/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.EntryFacadeConverter;
import au.net.zeus.collection.EntrySetFacade;
import au.net.zeus.collection.Ref;
import au.net.zeus.collection.RefQueue;
import au.net.zeus.collection.RefReferenceQueue;
import au.net.zeus.collection.ReferenceCollection;
import au.net.zeus.collection.ReferenceProcessor;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.ReferenceSet;
import au.net.zeus.collection.Referrer;
import au.net.zeus.collection.TimedRefQueue;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<Referrer<K>, Referrer<V>> map;
    private final ReferenceQueuingFactory<K, Referrer<K>> krqf;
    private final ReferenceQueuingFactory<V, Referrer<V>> vrqf;
    private final Ref key;
    private final Ref val;
    private final Collection<V> values;
    private final Set<K> keys;
    private final Set<Map.Entry<K, V>> entrys;

    ReferenceMap(Map<Referrer<K>, Referrer<V>> map, Ref key, Ref val, boolean gcThreads, long gcKeyCycle, long gcValCycle) {
        RefQueue keyQue = null;
        if (key.equals((Object)Ref.TIME)) {
            keyQue = new TimedRefQueue();
        } else if (!key.equals((Object)Ref.STRONG)) {
            keyQue = new RefReferenceQueue();
        }
        RefQueue valQue = null;
        if (val.equals((Object)Ref.TIME)) {
            valQue = new TimedRefQueue();
        } else if (!val.equals((Object)Ref.STRONG)) {
            valQue = new RefReferenceQueue();
        }
        ReferenceProcessor<K> krp = new ReferenceProcessor<K>(map.keySet(), key, keyQue, gcThreads, map);
        ReferenceProcessor<V> vrp = new ReferenceProcessor<V>(map.values(), val, valQue, gcThreads, map);
        this.krqf = krp;
        this.vrqf = vrp;
        this.map = map;
        this.key = key;
        this.val = val;
        this.values = new ReferenceCollection<V>(this.map.values(), this.vrqf, val);
        this.keys = new ReferenceSet<K>(this.map.keySet(), this.krqf, key);
        this.entrys = new EntrySetFacade<K, Map.Entry<Referrer<Referrer<K>>, Referrer<Referrer<V>>>>(map.entrySet(), new EntryFacadeConverter<K, V>(this.krqf, this.vrqf));
        krp.start(gcKeyCycle);
        vrp.start(gcValCycle);
    }

    ReferenceMap(Map<Referrer<K>, Referrer<V>> map, ReferenceQueuingFactory<K, Referrer<K>> krqf, ReferenceQueuingFactory<V, Referrer<V>> vrqf, Ref key, Ref val) {
        this.map = map;
        this.krqf = krqf;
        this.vrqf = vrqf;
        this.key = key;
        this.val = val;
        this.values = new ReferenceCollection<V>(this.map.values(), vrqf, val);
        this.keys = new ReferenceSet<K>(this.map.keySet(), krqf, key);
        this.entrys = new EntrySetFacade<K, Map.Entry<Referrer<Referrer<K>>, Referrer<Referrer<V>>>>(map.entrySet(), new EntryFacadeConverter<K, V>(krqf, vrqf));
    }

    ReferenceQueuingFactory<K, Referrer<K>> getKeyRQF() {
        return this.krqf;
    }

    ReferenceQueuingFactory<V, Referrer<V>> getValRQF() {
        return this.vrqf;
    }

    Ref keyRef() {
        return this.key;
    }

    Ref valRef() {
        return this.val;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.map.containsKey(this.wrapKey(key, false, true));
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        return this.map.containsValue(this.wrapVal(value, false, true));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrys;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        Referrer<V> refVal = this.map.get(this.wrapKey(key, false, true));
        if (refVal != null) {
            return refVal.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.keys;
    }

    public void processQueue() {
        this.krqf.processQueue();
        this.vrqf.processQueue();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        Referrer<V> val = this.map.put(this.wrapKey(key, true, false), this.wrapVal(value, true, false));
        if (val != null) {
            return val.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        Referrer<V> val = this.map.remove(this.wrapKey(key, false, true));
        if (val != null) {
            return val.get();
        }
        return null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        return this.values;
    }

    Referrer<V> wrapVal(V val, boolean enque, boolean temporary) {
        return this.vrqf.referenced(val, enque, temporary);
    }

    Referrer<K> wrapKey(K key, boolean enque, boolean temporary) {
        return this.krqf.referenced(key, enque, temporary);
    }
}

