/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.Ref;
import au.net.zeus.collection.ReferenceComparator;
import au.net.zeus.collection.ReferenceMap;
import au.net.zeus.collection.ReferenceQueuingFactory;
import au.net.zeus.collection.Referrer;
import java.util.Comparator;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReferenceSortedMap<K, V>
extends ReferenceMap<K, V>
implements SortedMap<K, V> {
    private SortedMap<Referrer<K>, Referrer<V>> map;

    ReferenceSortedMap(SortedMap<Referrer<K>, Referrer<V>> map, Ref keyRef, Ref valRef, boolean gcThreads, long gcKeyCycle, long gcValCycle) {
        super(map, keyRef, valRef, gcThreads, gcKeyCycle, gcValCycle);
        this.map = map;
    }

    ReferenceSortedMap(SortedMap<Referrer<K>, Referrer<V>> map, ReferenceQueuingFactory<K, Referrer<K>> krqf, ReferenceQueuingFactory<V, Referrer<V>> vrqf, Ref key, Ref val) {
        super(map, krqf, vrqf, key, val);
        this.map = map;
    }

    @Override
    public Comparator<? super K> comparator() {
        this.processQueue();
        Comparator<Referrer<K>> c = this.map.comparator();
        if (c instanceof ReferenceComparator) {
            return ((ReferenceComparator)c).get();
        }
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        this.processQueue();
        return new ReferenceSortedMap<K, V>(this.map.subMap(this.wrapKey(fromKey, false, true), this.wrapKey(toKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        this.processQueue();
        return new ReferenceSortedMap<K, V>(this.map.headMap(this.wrapKey(toKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        this.processQueue();
        return new ReferenceSortedMap<K, V>(this.map.tailMap(this.wrapKey(fromKey, false, true)), this.getKeyRQF(), this.getValRQF(), this.keyRef(), this.valRef());
    }

    @Override
    public K firstKey() {
        this.processQueue();
        Referrer<K> k = this.map.firstKey();
        if (k != null) {
            return k.get();
        }
        return null;
    }

    @Override
    public K lastKey() {
        this.processQueue();
        Referrer<K> k = this.map.lastKey();
        if (k != null) {
            return k.get();
        }
        return null;
    }
}

