/*
 * Decompiled with CFR 0.152.
 */
package au.net.zeus.collection;

import au.net.zeus.collection.ReferenceSerializationFactory;
import au.net.zeus.collection.Referrer;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StrongReference<T>
implements Referrer<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T referent;
    private final int hash;

    StrongReference(T referent) {
        this.referent = referent;
        int hash = 7;
        hash = 29 * hash + referent.hashCode();
        this.hash = hash = 29 * hash + referent.getClass().hashCode();
    }

    StrongReference(T referent, ReferenceQueue<? super T> q) {
        this(referent);
    }

    @Override
    public int hashCode() {
        T k = this.get();
        int hash = 7;
        if (k != null) {
            hash = 29 * hash + k.hashCode();
            hash = 29 * hash + k.getClass().hashCode();
        } else {
            hash = this.hash;
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Referrer)) {
            return false;
        }
        T k1 = this.get();
        Object k2 = ((Referrer)o).get();
        if (k1 != null && k1.equals(k2)) {
            return true;
        }
        return k1 == null && k2 == null && this.hashCode() == o.hashCode();
    }

    public String toString() {
        T s = this.get();
        if (s != null) {
            return s.toString();
        }
        return super.toString();
    }

    @Override
    public void clear() {
        this.referent = null;
    }

    final Object writeReplace() throws ObjectStreamException {
        return ReferenceSerializationFactory.create(this.get());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Builder required");
    }

    @Override
    public T get() {
        return this.referent;
    }

    @Override
    public boolean isEnqueued() {
        return false;
    }

    @Override
    public boolean enqueue() {
        return false;
    }
}

