/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.example.browser;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.config.Config;
import com.sun.jini.example.browser.MetalIcons;
import com.sun.jini.example.browser.ServiceBrowser;
import com.sun.jini.example.browser.ServiceEditor;
import com.sun.jini.example.browser.SpaceBrowser;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.JavaSpaceAdmin;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.start.LifeCycle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.rmi.server.ExportException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.DiscoveryAdmin;
import net.jini.lookup.entry.UIDescriptor;
import net.jini.lookup.ui.factory.JFrameFactory;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.space.JavaSpace;
import net.jini.space.JavaSpace05;

public class Browser
extends JFrame {
    static final String BROWSER = "com.sun.jini.example.browser";
    static final Logger logger = Logger.getLogger("com.sun.jini.example.browser");
    private transient SecurityContext ctx;
    private transient ClassLoader ccl;
    transient Configuration config;
    private transient DiscoveryGroupManagement disco;
    private transient ServiceRegistrar lookup = null;
    private transient Object eventSource = null;
    private transient long eventID = 0L;
    private transient long seqNo = Long.MAX_VALUE;
    private transient ActionListener exiter;
    private transient ServiceTemplate tmpl;
    private transient Listener listen;
    private transient LookupListener adder;
    private transient Lease elease = null;
    transient ProxyPreparer leasePreparer;
    transient ProxyPreparer servicePreparer;
    transient ProxyPreparer adminPreparer;
    private transient MethodConstraints locatorConstraints;
    transient LeaseRenewalManager leaseMgr;
    private transient LeaseListener lnotify;
    private transient List ignoreInterfaces;
    private transient JTextArea text;
    private transient JMenu registrars;
    private transient JCheckBoxMenuItem esuper;
    private transient JCheckBoxMenuItem ssuper;
    private transient JCheckBoxMenuItem sclass;
    private transient boolean isAdmin;
    private volatile transient boolean autoConfirm;
    private transient JList list;
    private transient DefaultListModel listModel;
    private transient DefaultListModel dummyModel = new DefaultListModel();
    private transient JScrollPane listScrollPane;
    private static Icon[] icons = new Icon[3];

    public Browser(ActionListener exiter, Configuration config) throws ConfigurationException, IOException {
        if (exiter == null) {
            exiter = new Exit();
        }
        if (config == null) {
            config = EmptyConfiguration.INSTANCE;
        }
        this.init(exiter, config);
    }

    private void init(ActionListener exiter, Configuration config) throws ConfigurationException, IOException {
        this.exiter = exiter = this.wrap((ActionListener)Config.getNonNullEntry(config, BROWSER, "exitActionListener", ActionListener.class, exiter));
        this.config = config;
        this.ctx = Security.getContext();
        this.ccl = Thread.currentThread().getContextClassLoader();
        this.leaseMgr = (LeaseRenewalManager)Config.getNonNullEntry(config, BROWSER, "leaseManager", LeaseRenewalManager.class, new LeaseRenewalManager(config));
        this.isAdmin = (Boolean)config.getEntry(BROWSER, "folderView", Boolean.TYPE, Boolean.TRUE);
        this.leasePreparer = (ProxyPreparer)Config.getNonNullEntry(config, BROWSER, "leasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.servicePreparer = (ProxyPreparer)Config.getNonNullEntry(config, BROWSER, "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.adminPreparer = (ProxyPreparer)Config.getNonNullEntry(config, BROWSER, "adminPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.locatorConstraints = (MethodConstraints)config.getEntry(BROWSER, "locatorConstraints", MethodConstraints.class, null);
        this.ignoreInterfaces = Arrays.asList((String[])Config.getNonNullEntry(config, BROWSER, "uninterestingInterfaces", String[].class, new String[]{"java.io.Serializable", "java.rmi.Remote", "net.jini.admin.Administrable", "net.jini.core.constraint.RemoteMethodControl", "net.jini.id.ReferentUuid", "net.jini.security.proxytrust.TrustEquivalence"}));
        this.autoConfirm = (Boolean)config.getEntry(BROWSER, "autoConfirm", Boolean.TYPE, Boolean.FALSE);
        this.listen = new Listener();
        try {
            DiscoveryManagement disco = (DiscoveryManagement)Config.getNonNullEntry(config, BROWSER, "discoveryManager", DiscoveryManagement.class);
            if (!(disco instanceof DiscoveryGroupManagement)) {
                throw new ConfigurationException("discoveryManager does not  support DiscoveryGroupManagement");
            }
            if (!(disco instanceof DiscoveryLocatorManagement)) {
                throw new ConfigurationException("discoveryManager does not  support DiscoveryLocatorManagement");
            }
            this.disco = (DiscoveryGroupManagement)((Object)disco);
            String[] groups = this.disco.getGroups();
            if (groups == null || groups.length > 0) {
                throw new ConfigurationException("discoveryManager cannot have initial groups");
            }
            if (((DiscoveryLocatorManagement)((Object)disco)).getLocators().length > 0) {
                throw new ConfigurationException("discoveryManager cannot have initial locators");
            }
        }
        catch (NoSuchEntryException e) {
            this.disco = new LookupDiscoveryManager(new String[0], new LookupLocator[0], null, config);
        }
        this.disco.setGroups((String[])config.getEntry(BROWSER, "initialLookupGroups", String[].class, null));
        ((DiscoveryLocatorManagement)((Object)this.disco)).setLocators((LookupLocator[])Config.getNonNullEntry(config, BROWSER, "initialLookupLocators", LookupLocator[].class, new LookupLocator[0]));
        this.tmpl = new ServiceTemplate(null, new Class[0], new Entry[0]);
        this.setTitle("Service Browser");
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem allfind = new JMenuItem("Find All");
        allfind.addActionListener(this.wrap(new AllFind()));
        file.add(allfind);
        JMenuItem pubfind = new JMenuItem("Find Public");
        pubfind.addActionListener(this.wrap(new PubFind()));
        file.add(pubfind);
        JMenuItem multifind = new JMenuItem("Find By Group...");
        multifind.addActionListener(this.wrap(new MultiFind()));
        file.add(multifind);
        JMenuItem unifind = new JMenuItem("Find By Address...");
        unifind.addActionListener(this.wrap(new UniFind()));
        file.add(unifind);
        if (!this.isAdmin) {
            JMenuItem show = new JMenuItem("Show Matches");
            show.addActionListener(this.wrap(new Show()));
            file.add(show);
        }
        JMenuItem reset = new JMenuItem("Reset");
        reset.addActionListener(this.wrap(new Reset()));
        file.add(reset);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(exiter);
        file.add(exit);
        bar.add(file);
        this.addWindowListener(new Exiter());
        this.registrars = new JMenu("Registrar");
        Browser.addNone(this.registrars);
        bar.add(this.registrars);
        JMenu options = new JMenu("Options");
        this.esuper = new JCheckBoxMenuItem("Attribute supertypes", false);
        options.add(this.esuper);
        this.ssuper = new JCheckBoxMenuItem("Service supertypes", false);
        options.add(this.ssuper);
        this.sclass = new JCheckBoxMenuItem("Service classes", false);
        options.add(this.sclass);
        bar.add(options);
        JMenu services = new JMenu("Services");
        services.addMenuListener(this.wrap(new Services(services)));
        bar.add(services);
        JMenu attrs = new JMenu("Attributes");
        attrs.addMenuListener(this.wrap(new Entries(attrs)));
        bar.add(attrs);
        this.setJMenuBar(bar);
        this.getContentPane().setLayout(new BorderLayout());
        int textRows = 8;
        if (this.isAdmin) {
            textRows = 4;
            JPanel bpanel = new JPanel();
            bpanel.setLayout(new BorderLayout());
            TitledBorder border = BorderFactory.createTitledBorder("Matching Services");
            border.setTitlePosition(2);
            border.setTitleJustification(1);
            bpanel.setBorder(border);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.setFixedCellHeight(20);
            this.list.setCellRenderer((ListCellRenderer)this.wrap(new ServiceItemRenderer(), ListCellRenderer.class));
            this.list.addMouseListener(this.wrap(new MouseReceiver(new ServiceListPopup())));
            this.listScrollPane = new JScrollPane(this.list);
            bpanel.add((Component)this.listScrollPane, "Center");
            this.getContentPane().add((Component)bpanel, "South");
        }
        this.text = new JTextArea(this.genText(false), textRows, 40);
        this.text.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.text);
        this.getContentPane().add((Component)scroll, "Center");
        this.validate();
        SwingUtilities.invokeLater(this.wrap(new Runnable(){

            @Override
            public void run() {
                Browser.this.pack();
                Browser.this.show();
            }
        }));
        this.adder = new LookupListener();
        this.lnotify = new LeaseNotify();
        ((DiscoveryManagement)((Object)this.disco)).addDiscoveryListener(this.adder);
    }

    public Browser(String[] args, final LifeCycle lc) throws ConfigurationException, LoginException, IOException {
        final ActionListener exiter = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Browser.this.dispose();
                Browser.this.cancelLease();
                Browser.this.listen.unexport();
                if (lc != null) {
                    lc.unregister(Browser.this);
                }
            }
        };
        final Configuration config = ConfigurationProvider.getInstance(args, Browser.class.getClassLoader());
        LoginContext login = (LoginContext)config.getEntry(BROWSER, "loginContext", LoginContext.class, null);
        if (login == null) {
            this.init(exiter, config);
        } else {
            login.login();
            try {
                Subject.doAsPrivileged(login.getSubject(), new PrivilegedExceptionAction(){

                    public Object run() throws ConfigurationException, IOException {
                        Browser.this.init(exiter, config);
                        return null;
                    }
                }, null);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                if (e instanceof ConfigurationException) {
                    throw (ConfigurationException)e;
                }
                throw (IOException)e;
            }
        }
    }

    private static String typeName(Class type) {
        String name = type.getName();
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        return name;
    }

    private void setText(boolean match) {
        this.text.setText(this.genText(match));
    }

    private String genText(boolean match) {
        StringBuffer buf = new StringBuffer();
        if (this.tmpl.serviceTypes.length > 0) {
            for (int i = 0; i < this.tmpl.serviceTypes.length; ++i) {
                buf.append(this.tmpl.serviceTypes[i].getName());
                buf.append("\n");
            }
        }
        if (this.tmpl.attributeSetTemplates.length > 0) {
            this.genEntries(buf, this.tmpl.attributeSetTemplates, false);
        }
        this.genMatches(buf, match);
        return buf.toString();
    }

    private void genEntries(StringBuffer buf, Entry[] entries, boolean showNulls) {
        for (int i = 0; i < entries.length; ++i) {
            Entry ent = entries[i];
            if (ent == null) {
                buf.append("null\n");
                continue;
            }
            buf.append(Browser.typeName(ent.getClass()));
            buf.append(": ");
            try {
                Field[] fields = ent.getClass().getFields();
                for (int j = 0; j < fields.length; ++j) {
                    Object val;
                    if (!Browser.valid(fields[j]) || (val = fields[j].get(ent)) == null && !showNulls) continue;
                    buf.append(fields[j].getName());
                    buf.append("=");
                    buf.append(val);
                    buf.append(" ");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            buf.append("\n");
        }
    }

    private static boolean valid(Field f) {
        return (f.getModifiers() & 0x18) == 0;
    }

    private void genMatches(StringBuffer buf, boolean match) {
        int i;
        ServiceMatches matches;
        if (this.isAdmin) {
            this.list.setModel(this.dummyModel);
            this.listModel.removeAllElements();
            this.list.clearSelection();
            this.list.ensureIndexIsVisible(0);
            this.list.repaint();
            this.list.revalidate();
            this.listScrollPane.validate();
        }
        if (this.lookup == null) {
            String[] groups = this.disco.getGroups();
            if (groups == null) {
                buf.append("Groups: <all>\n");
            } else if (groups.length > 0) {
                buf.append("Groups:");
                for (int i2 = 0; i2 < groups.length; ++i2) {
                    String group = groups[i2];
                    if (group.length() == 0) {
                        group = "public";
                    }
                    buf.append(" ");
                    buf.append(group);
                }
                buf.append("\n");
            }
            LookupLocator[] locators = ((DiscoveryLocatorManagement)((Object)this.disco)).getLocators();
            if (locators.length > 0) {
                buf.append("Addresses:");
                for (int i3 = 0; i3 < locators.length; ++i3) {
                    buf.append(" ");
                    buf.append(locators[i3].getHost());
                    if (locators[i3].getPort() == 4160) continue;
                    buf.append(":");
                    buf.append(locators[i3].getPort());
                }
                buf.append("\n");
            }
            if (!(this.registrars.getMenuComponent(0) instanceof JRadioButtonMenuItem)) {
                buf.append("No registrars to select");
                return;
            }
            int n = this.registrars.getMenuComponentCount();
            if (n == 1) {
                buf.append("1 registrar, not selected");
            } else {
                buf.append(n);
                buf.append(" registrars, none selected");
            }
            return;
        }
        try {
            matches = this.lookup.lookup(this.tmpl, match || this.isAdmin ? 1000 : 0);
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "lookup failed", t);
            return;
        }
        if (matches.items != null) {
            for (i = 0; i < matches.items.length; ++i) {
                if (matches.items[i].service == null) continue;
                try {
                    matches.items[i].service = this.servicePreparer.prepareProxy(matches.items[i].service);
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "proxy preparation failed", t);
                    matches.items[i].service = null;
                }
            }
        }
        if (this.isAdmin) {
            for (i = 0; i < matches.items.length; ++i) {
                this.listModel.addElement(new ServiceListItem(matches.items[i]));
            }
            this.list.setModel(this.listModel);
            this.list.clearSelection();
            this.list.ensureIndexIsVisible(0);
            this.list.repaint();
            this.list.revalidate();
            this.listScrollPane.validate();
        }
        if (!match && this.tmpl.serviceTypes.length == 0 && this.tmpl.attributeSetTemplates.length == 0) {
            buf.append("Total services registered: ");
            buf.append(matches.totalMatches);
            return;
        }
        buf.append("\nMatching services: ");
        buf.append(matches.totalMatches);
        if (!this.isAdmin) {
            if (!match) {
                return;
            }
            buf.append("\n\n");
            for (i = 0; i < matches.items.length; ++i) {
                ServiceItem item = matches.items[i];
                buf.append("Service ID: ");
                buf.append(item.serviceID);
                buf.append("\n");
                buf.append("Service instance: ");
                buf.append(item.service);
                buf.append("\n");
                this.genEntries(buf, item.attributeSets, true);
                buf.append("\n");
            }
        }
    }

    private static void addNone(JMenu menu) {
        JMenuItem item = new JMenuItem("(none)");
        item.setEnabled(false);
        menu.add(item);
    }

    private void addOne(ServiceRegistrar registrar) {
        LookupLocator loc;
        try {
            loc = registrar.getLocator();
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "obtaining locator failed", t);
            return;
        }
        String host = loc.getHost();
        if (loc.getPort() != 4160) {
            host = host + ":" + loc.getPort();
        }
        RegistrarMenuItem reg = new RegistrarMenuItem(host, registrar.getServiceID());
        reg.addActionListener(this.wrap(new Lookup(registrar)));
        if (!(this.registrars.getMenuComponent(0) instanceof JRadioButtonMenuItem)) {
            this.registrars.removeAll();
        }
        this.registrars.add(reg);
    }

    static Class[] getInterfaces(Class c) {
        HashSet set = new HashSet();
        while (c != null) {
            Class<?>[] ifs = c.getInterfaces();
            int i = ifs.length;
            while (--i >= 0) {
                set.add(ifs[i]);
            }
            c = c.getSuperclass();
        }
        return set.toArray(new Class[set.size()]);
    }

    boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    ActionListener wrap(ActionListener l) {
        return (ActionListener)this.wrap(l, ActionListener.class);
    }

    MenuListener wrap(MenuListener l) {
        return (MenuListener)this.wrap(l, MenuListener.class);
    }

    MouseListener wrap(MouseListener l) {
        return (MouseListener)this.wrap(l, MouseListener.class);
    }

    WindowListener wrap(WindowListener a) {
        return (WindowListener)this.wrap(a, WindowListener.class);
    }

    Runnable wrap(Runnable r) {
        return (Runnable)this.wrap(r, Runnable.class);
    }

    private Object wrap(Object obj, Class iface) {
        return Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new Handler(obj));
    }

    private void resetTmpl() {
        this.tmpl.serviceTypes = new Class[0];
        this.tmpl.attributeSetTemplates = new Entry[0];
        this.update();
    }

    private void reset() {
        this.ssuper.setState(false);
        this.esuper.setState(false);
        this.sclass.setState(false);
        this.resetTmpl();
    }

    private void setGroups(String[] groups) {
        ((DiscoveryLocatorManagement)((Object)this.disco)).setLocators(new LookupLocator[0]);
        try {
            this.disco.setGroups(groups);
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "setting groups failed", t);
        }
        this.resetTmpl();
    }

    private static String[] parseList(String names, boolean groups) {
        StringTokenizer st = new StringTokenizer(names, " \t\n\r\f,");
        String[] elts = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            elts[i] = st.nextToken();
            if (groups && elts[i].equalsIgnoreCase("public")) {
                elts[i] = "";
            }
            ++i;
        }
        return elts;
    }

    private void cancelLease() {
        if (this.elease != null) {
            try {
                this.leaseMgr.cancel(this.elease);
            }
            catch (Throwable t) {
                logger.log(Levels.HANDLED, "lease cancellation failed", t);
            }
            this.elease = null;
            this.eventSource = null;
        }
    }

    private void update() {
        this.setText(false);
        this.cancelLease();
        if (this.lookup == null) {
            return;
        }
        try {
            EventRegistration reg = this.lookup.notify(this.tmpl, 7, this.listen.proxy, null, -1L);
            this.elease = (Lease)this.leasePreparer.prepareProxy(reg.getLease());
            this.leaseMgr.renewUntil(this.elease, -1L, this.lnotify);
            this.eventSource = reg.getSource();
            this.eventID = reg.getID();
            this.seqNo = reg.getSequenceNumber();
        }
        catch (Throwable t) {
            this.failure(t);
        }
    }

    private void failure(Throwable t) {
        logger.log(Level.INFO, "call to lookup service failed", t);
        ((DiscoveryManagement)((Object)this.disco)).discard(this.lookup);
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            final Configuration config = ConfigurationProvider.getInstance(args, Browser.class.getClassLoader());
            LoginContext login = (LoginContext)config.getEntry(BROWSER, "loginContext", LoginContext.class, null);
            if (login != null) {
                login.login();
            }
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new Browser(null, config);
                }
            };
            if (login != null) {
                Subject.doAsPrivileged(login.getSubject(), action, null);
            } else {
                action.run();
            }
        }
        catch (Throwable t) {
            if (t instanceof PrivilegedActionException) {
                t = t.getCause();
            }
            logger.log(Level.SEVERE, "browser initialization failed", t);
        }
    }

    static {
        Browser.icons[0] = MetalIcons.getBlueFolderIcon();
        Browser.icons[1] = MetalIcons.getGrayFolderIcon();
        Browser.icons[2] = MetalIcons.getUnusableFolderIcon();
    }

    public static class Exit
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            Object src = ev.getSource();
            while (!(src instanceof Browser) && src instanceof Component) {
                if (src instanceof JPopupMenu) {
                    src = ((JPopupMenu)src).getInvoker();
                    continue;
                }
                src = ((Component)src).getParent();
            }
            if (src instanceof Browser) {
                ((Browser)src).cancelLease();
            }
            System.exit(0);
        }
    }

    private class Exiter
    extends WindowAdapter {
        private Exiter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Browser.this.exiter.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Exit", System.currentTimeMillis(), 0));
        }
    }

    private class ServiceListPopup
    extends JPopupMenu
    implements ActionListener,
    PopupMenuListener {
        protected JMenuItem infoItem;
        protected JMenuItem browseItem;
        protected JMenuItem adminItem;
        protected JMenuItem spaceItem;
        protected ServiceListItem listItem;
        protected JMenuItem uiItem;
        protected ServiceItem item;

        public ServiceListPopup() {
            ActionListener me = Browser.this.wrap(this);
            this.infoItem = new JMenuItem("Show Info");
            this.infoItem.addActionListener(me);
            this.infoItem.setActionCommand("showInfo");
            this.add(this.infoItem);
            this.browseItem = new JMenuItem("Browse Service");
            this.browseItem.addActionListener(me);
            this.browseItem.setActionCommand("browseService");
            this.add(this.browseItem);
            this.adminItem = new JMenuItem("Admin Service");
            this.adminItem.addActionListener(me);
            this.adminItem.setActionCommand("adminService");
            this.add(this.adminItem);
            this.spaceItem = new JMenuItem("Browse Entries");
            this.spaceItem.addActionListener(me);
            this.spaceItem.setActionCommand("browseEntry");
            this.add(this.spaceItem);
            this.uiItem = new JMenuItem("Show UI");
            this.uiItem.addActionListener(me);
            this.uiItem.setActionCommand("showUI");
            this.add(this.uiItem);
            this.addPopupMenuListener(this);
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
        }

        public void setServiceItem(ServiceListItem listItem) {
            this.listItem = listItem;
            this.item = listItem.getServiceItem();
            this.infoItem.setEnabled(listItem.isAccessible());
            this.browseItem.setEnabled(listItem.isAccessible());
            this.adminItem.setEnabled(listItem.isAdministrable());
            this.spaceItem.setEnabled(listItem.isSpaceBrowsable());
            this.uiItem.setEnabled(listItem.isUI());
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if (command.equals("showInfo")) {
                Class[] infs = Browser.getInterfaces(this.item.service.getClass());
                String[] msg = new String[3 + infs.length];
                msg[0] = "ServiceID: " + this.item.serviceID;
                msg[1] = "Service Instance: " + this.item.service.getClass().getName();
                msg[2] = infs.length == 1 ? "Implemented Interface:" : "Implemented Interfaces:";
                for (int i = 0; i < infs.length; ++i) {
                    msg[3 + i] = infs[i].getName();
                }
                JOptionPane.showMessageDialog(Browser.this, msg, "ServiceItem Information", 1);
            } else if (command.equals("browseService")) {
                new ServiceBrowser(this.item, Browser.this.lookup, Browser.this).setVisible(true);
            } else if (command.equals("adminService")) {
                new ServiceEditor(this.item, this.listItem.getAdmin(), Browser.this.lookup, Browser.this).setVisible(true);
            } else if (command.equals("browseEntry")) {
                new SpaceBrowser(this.item.service instanceof JavaSpace05 ? this.item.service : this.listItem.getAdmin(), Browser.this).setVisible(true);
            } else if (command.equals("showUI")) {
                UIDescriptor uiDescriptor = this.getSelectedUIDescriptor();
                if (uiDescriptor == null) {
                    return;
                }
                try {
                    JFrameFactory uiFactory = (JFrameFactory)uiDescriptor.getUIFactory(Thread.currentThread().getContextClassLoader());
                    JFrame frame = uiFactory.getJFrame(this.item);
                    frame.validate();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "show ui failed", e);
                    JOptionPane.showMessageDialog(Browser.this, e.getMessage(), e.getClass().getName(), 2);
                    return;
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent ev) {
        }

        private UIDescriptor getSelectedUIDescriptor() {
            if (!new ServiceListItem(this.item).isUI()) {
                return null;
            }
            Entry[] attrs = this.item.attributeSets;
            if (attrs != null && attrs.length != 0) {
                for (int i = 0; i < attrs.length; ++i) {
                    if (!(attrs[i] instanceof UIDescriptor)) continue;
                    UIDescriptor desc = (UIDescriptor)attrs[i];
                    if (!"javax.swing".equals(desc.toolkit)) continue;
                    return desc;
                }
            }
            return null;
        }
    }

    private class MouseReceiver
    extends MouseAdapter {
        private ServiceListPopup popup;

        public MouseReceiver(ServiceListPopup popup) {
            this.popup = popup;
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            ServiceListItem listItem;
            if (ev.getClickCount() >= 2 && (listItem = this.getTargetListItem(ev)) != null) {
                ServiceItem item = listItem.getServiceItem();
                if (listItem.isAdministrable()) {
                    new ServiceEditor(item, listItem.getAdmin(), Browser.this.lookup, Browser.this).setVisible(true);
                } else if (listItem.isAccessible()) {
                    new ServiceBrowser(item, Browser.this.lookup, Browser.this).setVisible(true);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger() && this.getTargetListItem(ev) != null) {
                this.popup.setServiceItem(this.getTargetListItem(ev));
                this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (ev.isPopupTrigger() && this.getTargetListItem(ev) != null) {
                this.popup.setServiceItem(this.getTargetListItem(ev));
                this.popup.show(ev.getComponent(), ev.getX(), ev.getY());
            }
        }

        private ServiceListItem getTargetListItem(MouseEvent ev) {
            int index = Browser.this.list.locationToIndex(ev.getPoint());
            if (index >= 0) {
                return (ServiceListItem)Browser.this.listModel.getElementAt(index);
            }
            return null;
        }
    }

    private class ServiceListItem {
        private ServiceItem item;
        private boolean isAccessible;
        private Object admin = null;

        public ServiceListItem(ServiceItem item) {
            this.item = item;
            this.isAccessible = item.service != null;
        }

        public String getTitle() {
            if (this.item.service == null) {
                return "Unknown service";
            }
            HashSet<String> set = new HashSet<String>();
            Class[] infs = Browser.getInterfaces(this.item.service.getClass());
            for (int j = 0; j < infs.length; ++j) {
                set.add(infs[j].getName());
            }
            set.removeAll(Browser.this.ignoreInterfaces);
            String title = null;
            if (set.size() == 1) {
                Iterator iter2 = set.iterator();
                title = (String)iter2.next();
            } else {
                title = this.item.service.getClass().getName();
                title = title + " [";
                Iterator iter3 = set.iterator();
                while (iter3.hasNext()) {
                    title = title + (String)iter3.next();
                    if (!iter3.hasNext()) continue;
                    title = title + ", ";
                }
                title = title + "]";
            }
            if (!this.isAccessible) {
                title = title + " (Stale service)";
            }
            return title;
        }

        public boolean isAccessible() {
            this.getAdmin();
            return this.isAccessible;
        }

        public Object getAdmin() {
            if (this.admin == null && this.isAccessible && this.item.service instanceof Administrable) {
                try {
                    this.admin = Browser.this.adminPreparer.prepareProxy(((Administrable)this.item.service).getAdmin());
                }
                catch (Throwable t) {
                    logger.log(Levels.HANDLED, "failed to get admin proxy", t);
                    this.isAccessible = false;
                }
            }
            return this.admin;
        }

        public boolean isAdministrable() {
            this.getAdmin();
            return this.admin instanceof DestroyAdmin || this.admin instanceof JoinAdmin || this.admin instanceof DiscoveryAdmin;
        }

        public boolean isSpaceBrowsable() {
            return this.item.service instanceof JavaSpace05 || this.item.service instanceof JavaSpace && this.getAdmin() instanceof JavaSpaceAdmin;
        }

        private boolean isUI() {
            Entry[] attrs = this.item.attributeSets;
            if (attrs != null && attrs.length != 0) {
                for (int i = 0; i < attrs.length; ++i) {
                    if (!(attrs[i] instanceof UIDescriptor)) continue;
                    return true;
                }
            }
            return false;
        }

        public ServiceItem getServiceItem() {
            return this.item;
        }

        public Entry[] getAttributes() {
            return this.item.attributeSets;
        }

        public Icon getIcon() {
            if (!this.isAccessible()) {
                return icons[2];
            }
            if (this.isAdministrable()) {
                return icons[0];
            }
            return icons[1];
        }

        public String toString() {
            return this.isAccessible() ? this.item.service.getClass().getName() : "Unknown service";
        }
    }

    class ServiceItemRenderer
    implements ListCellRenderer {
        private JLabel label = new JLabel();

        public ServiceItemRenderer() {
            this.label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ServiceListItem item = null;
            if (value instanceof ServiceListItem) {
                item = (ServiceListItem)value;
            }
            this.label.setFont(list.getFont());
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            if (item != null) {
                this.label.setIcon(item.getIcon());
                this.label.setText(item.getTitle());
            } else {
                this.label.setText(value.toString());
            }
            return this.label;
        }
    }

    static class LeaseNotify
    implements LeaseListener {
        LeaseNotify() {
        }

        @Override
        public void notify(LeaseRenewalEvent ev) {
            if (ev.getException() != null) {
                logger.log(Level.INFO, "lease renewal failed", ev.getException());
            } else {
                logger.log(Level.INFO, "lease renewal failed");
            }
        }
    }

    private class Lookup
    implements ActionListener {
        private ServiceRegistrar registrar;

        public Lookup(ServiceRegistrar registrar) {
            this.registrar = registrar;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (Browser.this.lookup == this.registrar) {
                Browser.this.lookup = null;
            } else {
                Browser.this.lookup = this.registrar;
            }
            Browser.this.seqNo = Long.MAX_VALUE;
            for (int i = 0; i < Browser.this.registrars.getMenuComponentCount(); ++i) {
                JMenuItem item = (JMenuItem)Browser.this.registrars.getMenuComponent(i);
                if (item == ev.getSource()) continue;
                item.setSelected(false);
            }
            Browser.this.resetTmpl();
        }
    }

    private class UniFind
    implements ActionListener {
        private UniFind() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String list = JOptionPane.showInputDialog(Browser.this, (Object)"Enter host[:port] addresses");
            if (list == null) {
                return;
            }
            String[] addrs = Browser.parseList(list, false);
            LookupLocator[] locs = new LookupLocator[addrs.length];
            for (int i = 0; i < addrs.length; ++i) {
                try {
                    locs[i] = new ConstrainableLookupLocator("jini://" + addrs[i], Browser.this.locatorConstraints);
                    continue;
                }
                catch (MalformedURLException e) {
                    JOptionPane.showMessageDialog(Browser.this, "\"" + addrs[i] + "\": " + e.getMessage(), "Bad Address", 0);
                    return;
                }
            }
            try {
                Browser.this.disco.setGroups(new String[0]);
            }
            catch (Throwable t) {
                logger.log(Levels.HANDLED, "setting groups failed", t);
            }
            ((DiscoveryLocatorManagement)((Object)Browser.this.disco)).setLocators(locs);
            Browser.this.resetTmpl();
        }
    }

    private class MultiFind
    implements ActionListener {
        private MultiFind() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String names = JOptionPane.showInputDialog(Browser.this, (Object)"Enter group names");
            if (names == null) {
                return;
            }
            Browser.this.setGroups(Browser.parseList(names, true));
        }
    }

    private class PubFind
    implements ActionListener {
        private PubFind() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Browser.this.setGroups(new String[]{""});
        }
    }

    private class AllFind
    implements ActionListener {
        private AllFind() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Browser.this.setGroups(null);
        }
    }

    private class LookupListener
    implements DiscoveryListener {
        private LookupListener() {
        }

        @Override
        public void discovered(DiscoveryEvent e) {
            final ServiceRegistrar[] newregs = e.getRegistrars();
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < newregs.length; ++i) {
                        Browser.this.addOne(newregs[i]);
                    }
                    if (Browser.this.lookup == null) {
                        Browser.this.setText(false);
                    }
                }
            }));
        }

        @Override
        public void discarded(DiscoveryEvent e) {
            final ServiceRegistrar[] regs = e.getRegistrars();
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                @Override
                public void run() {
                    block0: for (int i = 0; i < regs.length; ++i) {
                        ServiceID id = regs[i].getServiceID();
                        if (Browser.this.lookup != null && id.equals(Browser.this.lookup.getServiceID())) {
                            Browser.this.lookup = null;
                            Browser.this.seqNo = Long.MAX_VALUE;
                        }
                        for (int j = 0; j < Browser.this.registrars.getMenuComponentCount(); ++j) {
                            JMenuItem item = (JMenuItem)Browser.this.registrars.getMenuComponent(j);
                            if (!(item instanceof RegistrarMenuItem) || !id.equals(((RegistrarMenuItem)item).id)) continue;
                            item.setSelected(false);
                            Browser.this.registrars.remove(item);
                            if (Browser.this.registrars.getMenuComponentCount() != 0) continue block0;
                            Browser.addNone(Browser.this.registrars);
                            continue block0;
                        }
                    }
                    if (Browser.this.lookup == null) {
                        Browser.this.resetTmpl();
                    }
                }
            }));
        }
    }

    private class Listener
    implements RemoteEventListener,
    ServerProxyTrust {
        private final Exporter exporter;
        final RemoteEventListener proxy;

        public Listener() throws ConfigurationException, ExportException {
            this.exporter = (Exporter)Config.getNonNullEntry(Browser.this.config, Browser.BROWSER, "listenerExporter", Exporter.class, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, false));
            this.proxy = (RemoteEventListener)this.exporter.export(this);
        }

        @Override
        public void notify(final RemoteEvent ev) {
            SwingUtilities.invokeLater(Browser.this.wrap(new Runnable(){

                @Override
                public void run() {
                    if (Browser.this.eventID == ev.getID() && Browser.this.seqNo < ev.getSequenceNumber() && Browser.this.eventSource != null && Browser.this.eventSource.equals(ev.getSource())) {
                        Browser.this.seqNo = ev.getSequenceNumber();
                        Browser.this.setText(false);
                    }
                }
            }));
        }

        @Override
        public TrustVerifier getProxyVerifier() {
            return new BasicProxyTrustVerifier(this.proxy);
        }

        void unexport() {
            this.exporter.unexport(true);
        }
    }

    private class Value
    implements ActionListener {
        private int index;
        private Field field;
        private Object value;

        public Value(int index, Field field, Object value) {
            this.index = index;
            this.field = field;
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                this.field.set(((Browser)Browser.this).tmpl.attributeSetTemplates[this.index], this.value);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "setting attribute value failed", t);
            }
            Browser.this.update();
        }
    }

    private class Values
    implements MenuListener {
        private JMenu menu;
        private int index;
        private Field field;

        public Values(JMenu menu, int index, Field field) {
            this.menu = menu;
            this.index = index;
            this.field = field;
        }

        @Override
        public void menuSelected(MenuEvent ev) {
            Object[] values;
            try {
                values = Browser.this.lookup.getFieldValues(Browser.this.tmpl, this.index, this.field.getName());
            }
            catch (Throwable t) {
                Browser.this.failure(t);
                return;
            }
            if (values == null) {
                Browser.addNone(this.menu);
                return;
            }
            for (int i = 0; i < values.length; ++i) {
                JMenuItem item = new JMenuItem(values[i].toString());
                item.addActionListener(Browser.this.wrap(new Value(this.index, this.field, values[i])));
                this.menu.add(item);
            }
        }

        @Override
        public void menuDeselected(MenuEvent ev) {
            this.menu.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent ev) {
            this.menu.removeAll();
        }
    }

    private class Unmatch
    implements ActionListener {
        private int index;

        public Unmatch(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            int z = ((Browser)Browser.this).tmpl.attributeSetTemplates.length;
            Entry[] newSets = new Entry[z - 1];
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, 0, newSets, 0, this.index);
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, this.index + 1, newSets, this.index, z - this.index - 1);
            ((Browser)Browser.this).tmpl.attributeSetTemplates = newSets;
            Browser.this.update();
        }
    }

    private class Fields
    implements MenuListener {
        private JMenu menu;
        private int index;

        public Fields(JMenu menu, int index) {
            this.menu = menu;
            this.index = index;
        }

        @Override
        public void menuSelected(MenuEvent ev) {
            JRadioButtonMenuItem match = new JRadioButtonMenuItem("(match)");
            match.setSelected(true);
            match.addActionListener(Browser.this.wrap(new Unmatch(this.index)));
            this.menu.add(match);
            Entry ent = ((Browser)Browser.this).tmpl.attributeSetTemplates[this.index];
            Field[] fields = ent.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Browser.valid(field)) continue;
                try {
                    JMenuItem item;
                    if (field.get(ent) != null) {
                        item = new JCheckBoxMenuItem(field.getName(), true);
                        item.addActionListener(Browser.this.wrap(new Value(this.index, field, null)));
                        this.menu.add(item);
                        continue;
                    }
                    item = new JMenu(field.getName());
                    ((JMenu)item).addMenuListener(Browser.this.wrap(new Values((JMenu)item, this.index, field)));
                    this.menu.add(item);
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "getting fields failed", t);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent ev) {
            this.menu.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent ev) {
            this.menu.removeAll();
        }
    }

    private class AttrSet
    implements ActionListener {
        private Class type;

        public AttrSet(Class type) {
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Entry ent;
            try {
                ent = (Entry)this.type.newInstance();
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "creating entry failed", t);
                return;
            }
            int z = ((Browser)Browser.this).tmpl.attributeSetTemplates.length;
            Entry[] newSets = new Entry[z + 1];
            System.arraycopy(((Browser)Browser.this).tmpl.attributeSetTemplates, 0, newSets, 0, z);
            newSets[z] = ent;
            ((Browser)Browser.this).tmpl.attributeSetTemplates = newSets;
            Browser.this.update();
        }
    }

    private class Entries
    implements MenuListener {
        private JMenu menu;

        public Entries(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void menuSelected(MenuEvent ev) {
            Class[] types;
            if (Browser.this.lookup == null) {
                Browser.addNone(this.menu);
                return;
            }
            Entry[] attrs = ((Browser)Browser.this).tmpl.attributeSetTemplates;
            for (int i = 0; i < attrs.length; ++i) {
                Class<?> type = attrs[i].getClass();
                JMenu item = new JMenu(Browser.typeName(type));
                item.addMenuListener(new Fields(item, i));
                this.menu.add(item);
            }
            try {
                types = Browser.this.lookup.getEntryClasses(Browser.this.tmpl);
            }
            catch (Throwable t) {
                Browser.this.failure(t);
                return;
            }
            if (types == null) {
                if (attrs.length == 0) {
                    Browser.addNone(this.menu);
                }
                return;
            }
            Vector all = new Vector();
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    this.menu.add(new JMenuItem("null"));
                    continue;
                }
                this.addType(types[i], all);
            }
        }

        private void addType(Class type, Vector all) {
            if (all.contains(type)) {
                return;
            }
            all.addElement(type);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(Browser.typeName(type), false);
            item.addActionListener(Browser.this.wrap(new AttrSet(type)));
            this.menu.add(item);
            if (Browser.this.esuper.getState() && Entry.class.isAssignableFrom(type.getSuperclass())) {
                this.addType(type.getSuperclass(), all);
            }
        }

        @Override
        public void menuDeselected(MenuEvent ev) {
            this.menu.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent ev) {
            this.menu.removeAll();
        }
    }

    private class Service
    implements ActionListener {
        private Class type;
        private int index;

        public Service(Class type, int index) {
            this.type = type;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Class[] newTypes;
            int z = ((Browser)Browser.this).tmpl.serviceTypes.length;
            if (this.index < 0) {
                newTypes = new Class[z + 1];
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, 0, newTypes, 0, z);
                newTypes[z] = this.type;
            } else {
                newTypes = new Class[z - 1];
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, 0, newTypes, 0, this.index);
                System.arraycopy(((Browser)Browser.this).tmpl.serviceTypes, this.index + 1, newTypes, this.index, z - this.index - 1);
            }
            ((Browser)Browser.this).tmpl.serviceTypes = newTypes;
            Browser.this.update();
        }
    }

    private class Reset
    implements ActionListener {
        private Reset() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Browser.this.reset();
        }
    }

    private class Show
    implements ActionListener {
        private Show() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Browser.this.setText(true);
        }
    }

    private class Handler
    implements InvocationHandler {
        private final Object obj;

        Handler(Object obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if ("equals".equals(method.getName())) {
                    return proxy == args[0];
                }
                if ("hashCode".equals(method.getName())) {
                    return System.identityHashCode(proxy);
                }
            }
            try {
                return AccessController.doPrivileged(Browser.this.ctx.wrap(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Thread t = Thread.currentThread();
                        ClassLoader occl = t.getContextClassLoader();
                        try {
                            t.setContextClassLoader(Browser.this.ccl);
                            try {
                                Object object = method.invoke(Handler.this.obj, args);
                                return object;
                            }
                            catch (InvocationTargetException e) {
                                Throwable tt = e.getCause();
                                if (tt instanceof Error) {
                                    throw (Error)tt;
                                }
                                throw (Exception)tt;
                            }
                        }
                        finally {
                            t.setContextClassLoader(occl);
                        }
                    }
                }), Browser.this.ctx.getAccessControlContext());
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    private class Services
    implements MenuListener {
        private JMenu menu;

        public Services(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void menuSelected(MenuEvent ev) {
            int i;
            if (Browser.this.lookup == null) {
                Browser.addNone(this.menu);
                return;
            }
            Vector<Serializable> all = new Vector<Serializable>();
            Class[] types = ((Browser)Browser.this).tmpl.serviceTypes;
            for (i = 0; i < types.length; ++i) {
                all.addElement(types[i]);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(types[i].getName(), true);
                item.addActionListener(Browser.this.wrap(new Service(types[i], i)));
                this.menu.add(item);
            }
            try {
                types = Browser.this.lookup.getServiceTypes(Browser.this.tmpl, "");
            }
            catch (Throwable t) {
                Browser.this.failure(t);
                return;
            }
            if (types == null) {
                if (all.isEmpty()) {
                    Browser.addNone(this.menu);
                }
                return;
            }
            for (i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    all.addElement(new JMenuItem("null"));
                    continue;
                }
                Class[] stypes = types[i].isInterface() || Browser.this.sclass.getState() ? new Class[]{types[i]} : Browser.getInterfaces(types[i]);
                for (int j = 0; j < stypes.length; ++j) {
                    this.addType(stypes[j], all);
                }
            }
        }

        private void addType(Class type, Vector all) {
            if (all.contains(type)) {
                return;
            }
            all.addElement(type);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(type.getName(), false);
            item.addActionListener(Browser.this.wrap(new Service(type, -1)));
            this.menu.add(item);
            if (!Browser.this.ssuper.getState()) {
                return;
            }
            if (Browser.this.sclass.getState() && type.getSuperclass() != null) {
                this.addType(type.getSuperclass(), all);
            }
            Class<?>[] stypes = type.getInterfaces();
            for (int i = 0; i < stypes.length; ++i) {
                this.addType(stypes[i], all);
            }
        }

        @Override
        public void menuDeselected(MenuEvent ev) {
            this.menu.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent ev) {
            this.menu.removeAll();
        }
    }

    private static class RegistrarMenuItem
    extends JRadioButtonMenuItem {
        ServiceID id;

        RegistrarMenuItem(String host, ServiceID id) {
            super(host);
            this.id = id;
        }
    }
}

