/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.TimedConnection;
import com.sun.jini.jeri.internal.http.TimedMap;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.security.AccessController;

public class ConnectionTimer {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private final TimeoutMap timeouts;

    public ConnectionTimer(long timeout) {
        this.timeouts = new TimeoutMap(timeout);
    }

    public void scheduleTimeout(TimedConnection conn, boolean force) {
        if (conn == null) {
            throw new NullPointerException();
        }
        this.timeouts.put(conn, force);
    }

    public boolean cancelTimeout(TimedConnection conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        return this.timeouts.remove(conn) != null;
    }

    private static class TimeoutMap
    extends TimedMap {
        TimeoutMap(long timeout) {
            super(systemThreadPool, timeout);
        }

        @Override
        void evicted(Object key, Object value) {
            boolean force = (Boolean)value;
            ((TimedConnection)key).shutdown(force);
        }
    }
}

