/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.runtime;

import com.sun.jini.thread.NewThreadAction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JvmLifeSupport {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock rl = this.rwl.readLock();
    private final Lock wl = this.rwl.writeLock();
    private final AtomicInteger keepAliveCount = new AtomicInteger();
    private volatile Thread keeper = null;

    JvmLifeSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementKeepAliveCount() {
        int value;
        this.rl.lock();
        try {
            value = this.keepAliveCount.getAndIncrement();
        }
        finally {
            this.rl.unlock();
        }
        if (value < 3) {
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementKeepAliveCount() {
        int value;
        this.rl.lock();
        try {
            value = this.keepAliveCount.decrementAndGet();
        }
        finally {
            this.rl.unlock();
        }
        if (value < 3) {
            this.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        this.wl.lock();
        try {
            int count = this.keepAliveCount.get();
            if (count == 0) {
                assert (this.keeper != null);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        JvmLifeSupport.this.keeper.interrupt();
                        return null;
                    }
                });
                this.keeper = null;
            } else if (count > 0 && this.keeper == null) {
                this.keeper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (!Thread.currentThread().isInterrupted()) {
                                Thread.sleep(Long.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }, "KeepAlive", false));
                this.keeper.start();
            }
        }
        finally {
            this.wl.unlock();
        }
    }
}

