/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.MailboxBackEnd;
import com.sun.jini.mercury.RemoteEventData;
import com.sun.jini.proxy.ThrowThis;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import net.jini.core.event.RemoteEvent;
import net.jini.event.InvalidIteratorException;
import net.jini.event.RemoteEventIterator;
import net.jini.id.Uuid;

class RemoteEventIteratorImpl
implements RemoteEventIterator {
    final Uuid registrationID;
    final Uuid iteratorID;
    final MailboxBackEnd mailbox;
    private Iterator iter = null;
    private Object lastEventCookie = null;
    private Object invalidatedLock = new Object();
    private boolean invalidated = false;

    RemoteEventIteratorImpl(Uuid id, Uuid regId, MailboxBackEnd srv, Collection evts) {
        if (id == null || regId == null || srv == null || evts == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.registrationID = regId;
        this.iteratorID = id;
        this.mailbox = srv;
        this.iter = evts.iterator();
    }

    @Override
    public RemoteEvent next(long timeout) throws RemoteException, InvalidIteratorException {
        this.checkState();
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout value must non-negative");
        }
        RemoteEvent re = null;
        LocalRemoteEventData lred = this.getNextValidLocalRemoteEventData(this.iter);
        if (lred != null) {
            re = lred.re;
            this.lastEventCookie = lred.cookie;
        } else {
            try {
                Collection events = this.mailbox.getNextBatch(this.registrationID, this.iteratorID, timeout, this.lastEventCookie);
                this.iter = events.iterator();
                lred = this.getNextValidLocalRemoteEventData(this.iter);
                if (lred != null) {
                    re = lred.re;
                    this.lastEventCookie = lred.cookie;
                }
            }
            catch (InvalidIteratorException iie) {
                this.invalidate();
                throw iie;
            }
            catch (ThrowThis tt) {
                tt.throwRemoteException();
            }
        }
        return re;
    }

    private LocalRemoteEventData getNextValidLocalRemoteEventData(Iterator i) {
        RemoteEventData rd = null;
        LocalRemoteEventData lrd = null;
        try {
            if (i != null && i.hasNext()) {
                rd = (RemoteEventData)i.next();
                lrd = new LocalRemoteEventData(rd.getRemoteEvent(), rd.getCookie());
            }
        }
        catch (ClassNotFoundException cnfe) {
            lrd = this.getNextValidLocalRemoteEventData(i);
        }
        return lrd;
    }

    @Override
    public void close() throws InvalidIteratorException {
        this.checkState();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws InvalidIteratorException {
        Object object = this.invalidatedLock;
        synchronized (object) {
            if (this.invalidated) {
                throw new InvalidIteratorException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        Object object = this.invalidatedLock;
        synchronized (object) {
            this.invalidated = true;
        }
    }

    private static class LocalRemoteEventData {
        RemoteEvent re = null;
        Object cookie = null;

        LocalRemoteEventData(RemoteEvent re, Object cookie) {
            this.re = re;
            this.cookie = cookie;
        }
    }
}

