/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.norm.AbstractProxy;
import com.sun.jini.norm.NormServer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import net.jini.admin.JoinAdmin;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class AdminProxy
extends AbstractProxy
implements JoinAdmin,
DestroyAdmin {
    private static final long serialVersionUID = 1L;

    static AdminProxy create(NormServer server, Uuid serverUuid) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableAdminProxy(server, serverUuid);
        }
        return new AdminProxy(server, serverUuid);
    }

    AdminProxy(NormServer server, Uuid serverUuid) {
        super(server, serverUuid);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server and uuid must be non-null");
    }

    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        return this.server.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.server.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.server.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() throws RemoteException {
        return this.server.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        this.server.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.server.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        this.server.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.server.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.server.setLookupLocators(locators);
    }

    @Override
    public void destroy() throws RemoteException {
        this.server.destroy();
    }

    static final class ConstrainableAdminProxy
    extends AdminProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        ConstrainableAdminProxy(NormServer server, Uuid serverUuid) {
            super(server, serverUuid);
            if (!(server instanceof RemoteMethodControl)) {
                throw new IllegalArgumentException("server must implement RemoteMethodControl");
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (!(this.server instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("server must implement RemoteMethodControl");
            }
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            NormServer constrainedServer = (NormServer)((Object)((RemoteMethodControl)((Object)this.server)).setConstraints(constraints));
            return new ConstrainableAdminProxy(constrainedServer, this.uuid);
        }

        @Override
        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)((Object)this.server)).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }
    }
}

