/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.collection.WeakTable;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.WakeupManager;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LeaseExpirationMgr
implements WeakTable.KeyGCHandler {
    static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private WeakTable ticketMap = new WeakTable(this);
    private NormServerBaseImpl server;
    private WakeupManager runQueue = new WakeupManager();
    final List expireQueue = new LinkedList();
    private final Thread expireThread = new ExpirationThread();

    LeaseExpirationMgr(NormServerBaseImpl server) {
        this.server = server;
        this.expireThread.start();
    }

    void terminate() {
        this.runQueue.stop();
        this.runQueue.cancelAll();
        this.expireThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(LeasedResource resource) {
        LeasedResource leasedResource = resource;
        synchronized (leasedResource) {
            this.schedule(resource);
        }
    }

    void reschedule(LeasedResource resource) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)this.ticketMap.remove(resource);
        if (ticket != null) {
            this.runQueue.cancel(ticket);
        }
        this.schedule(resource);
    }

    void schedule(LeasedResource resource) {
        WakeupManager.Ticket ticket;
        MgrTask task;
        LeaseSet set = (LeaseSet)resource;
        if (set.haveWarningRegistration()) {
            task = new SendWarning(set);
            ticket = this.runQueue.schedule(set.getWarningTime(), task);
        } else {
            task = new QueueExpiration(set);
            ticket = this.runQueue.schedule(set.getExpiration(), task);
        }
        task.setTicket(ticket);
        this.ticketMap.getOrAdd(set, ticket);
    }

    @Override
    public void keyGC(Object value) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)value;
        this.runQueue.cancel(ticket);
    }

    private class SendWarning
    extends MgrTask {
        private SendWarning(LeaseSet set) {
            super(set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LeaseSet s = (LeaseSet)this.resourceRef.get();
            if (s == null) {
                return;
            }
            LeaseSet leaseSet = s;
            synchronized (leaseSet) {
                LeaseSet set = this.removeOurTicket();
                if (set == null) {
                    return;
                }
                LeaseExpirationMgr.this.server.sendWarningEvent(set);
                QueueExpiration task = new QueueExpiration(set);
                WakeupManager.Ticket newTicket = LeaseExpirationMgr.this.runQueue.schedule(set.getExpiration(), task);
                ((MgrTask)task).setTicket(newTicket);
                LeaseExpirationMgr.this.ticketMap.getOrAdd(set, newTicket);
            }
        }
    }

    private class Expiration
    implements Runnable {
        private LeaseSet set;

        private Expiration(LeaseSet set) {
            this.set = set;
        }

        @Override
        public void run() {
            LeaseExpirationMgr.this.server.expireIfTime(this.set);
        }
    }

    private class QueueExpiration
    extends MgrTask {
        QueueExpiration(LeaseSet set) {
            super(set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LeaseSet set = this.removeOurTicket();
            if (set != null) {
                List list = LeaseExpirationMgr.this.expireQueue;
                synchronized (list) {
                    LeaseExpirationMgr.this.expireQueue.add(new Expiration(set));
                    LeaseExpirationMgr.this.expireQueue.notifyAll();
                }
            }
        }
    }

    private abstract class MgrTask
    implements Runnable {
        protected final WeakReference resourceRef;
        private WakeupManager.Ticket ticket;

        protected MgrTask(LeaseSet set) {
            this.resourceRef = new WeakReference<LeaseSet>(set);
        }

        private void setTicket(WakeupManager.Ticket ticket) {
            this.ticket = ticket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LeaseSet removeOurTicket() {
            LeaseSet set = (LeaseSet)this.resourceRef.get();
            if (set != null) {
                LeaseSet leaseSet = set;
                synchronized (leaseSet) {
                    WakeupManager.Ticket currentTicket = (WakeupManager.Ticket)LeaseExpirationMgr.this.ticketMap.get(set);
                    if (!this.ticket.equals(currentTicket)) {
                        return null;
                    }
                    LeaseExpirationMgr.this.ticketMap.remove(set);
                }
            }
            return set;
        }

        @Override
        public abstract void run();
    }

    private class ExpirationThread
    extends InterruptedStatusThread {
        ExpirationThread() {
            super("expire lease sets thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.hasBeenInterrupted()) {
                try {
                    Runnable task;
                    List list = LeaseExpirationMgr.this.expireQueue;
                    synchronized (list) {
                        if (LeaseExpirationMgr.this.expireQueue.isEmpty()) {
                            LeaseExpirationMgr.this.expireQueue.wait();
                            continue;
                        }
                        task = (Runnable)LeaseExpirationMgr.this.expireQueue.remove(0);
                    }
                    task.run();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "Exception in lease set expiration thread -- attempting to continue", t);
                }
            }
        }
    }
}

