/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.EventSender;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.event.UnknownEventException;
import net.jini.security.ProxyPreparer;
import net.jini.space.JavaSpace;

class Notifier
implements TimeConstants {
    private final JavaSpace source;
    private final ProxyPreparer recoveredListenerPreparer;
    private final WakeupManager wakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
    private final TaskManager pending;
    private static final int MAX_ATTEMPTS = 10;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.event");
    private static final long MAX_TIME = 86400000L;
    private static final long[] delays = new long[]{1000L, 5000L, 10000L, 60000L, 60000L};

    Notifier(JavaSpace source, ProxyPreparer recoveredListenerPreparer, Configuration config) throws ConfigurationException {
        if (source == null) {
            throw new NullPointerException("source must be non-null");
        }
        this.source = source;
        this.recoveredListenerPreparer = recoveredListenerPreparer;
        this.pending = (TaskManager)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "notificationsTaskManager", TaskManager.class, new TaskManager());
    }

    void terminate() {
        this.pending.terminate();
        this.wakeupMgr.stop();
        this.wakeupMgr.cancelAll();
    }

    void enqueueDelivery(EventSender sender) {
        this.pending.add(new NotifyTask(sender));
    }

    static {
        for (int i = 1; i < delays.length; ++i) {
            int n = i;
            delays[n] = delays[n] + delays[i - 1];
        }
    }

    private class NotifyTask
    extends RetryTask {
        private final EventSender sender;

        NotifyTask(EventSender sender) {
            super(Notifier.this.pending, Notifier.this.wakeupMgr);
            if (sender == null) {
                throw new NullPointerException("sender must be non-null");
            }
            this.sender = sender;
        }

        @Override
        public boolean tryOnce() {
            long curTime = System.currentTimeMillis();
            if (curTime - this.startTime() > 86400000L) {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "giving up on delivering event, keeping registration");
                }
                return true;
            }
            boolean successful = true;
            try {
                this.sender.sendEvent(Notifier.this.source, curTime, Notifier.this.recoveredListenerPreparer);
            }
            catch (UnknownEventException e) {
                this.logFailure("UnknownEventException", Level.FINER, true, e);
                this.sender.cancelRegistration();
            }
            catch (RemoteException e) {
                int cat = ThrowableConstants.retryable(e);
                if (cat == 1 || cat == 2) {
                    this.logFailure("definite exception", Level.INFO, true, e);
                    this.sender.cancelRegistration();
                } else if (cat == 0) {
                    this.logFailure("indefinite exception", Levels.FAILED, false, e);
                    successful = false;
                } else if (cat == 3) {
                    this.logFailure("uncategorized exception", Level.INFO, false, e);
                    successful = false;
                } else {
                    logger.log(Level.WARNING, "ThrowableConstants.retryable returned out of range value, " + cat, (Throwable)((Object)new AssertionError((Object)e)));
                    successful = false;
                }
            }
            catch (IOException e) {
                this.logFailure("IOException", Level.INFO, true, e);
                this.sender.cancelRegistration();
            }
            catch (ClassNotFoundException e) {
                this.logFailure("ClassNotFoundException", Levels.FAILED, false, e);
                successful = false;
            }
            catch (RuntimeException e) {
                this.logFailure("RuntimeException", Level.INFO, true, e);
                this.sender.cancelRegistration();
            }
            if (!successful && this.attempt() > 10) {
                if (logger.isLoggable(Levels.FAILED)) {
                    logger.log(Levels.FAILED, "giving up on delivering event, keeping registration");
                }
                return true;
            }
            return successful;
        }

        @Override
        public boolean runAfter(List list, int max) {
            for (int i = 0; i < max; ++i) {
                Object task = list.get(i);
                if (!(task instanceof NotifyTask)) continue;
                NotifyTask nt = (NotifyTask)task;
                if (!this.sender.runAfter(nt.sender)) continue;
                return true;
            }
            return false;
        }

        private void logFailure(String exceptionDescription, Level level, boolean terminal, Throwable t) {
            if (logger.isLoggable(level)) {
                logger.log(level, "Encountered " + exceptionDescription + "while preparing to send/sending event, " + (terminal ? "dropping" : "keeping") + " registration", t);
            }
        }
    }
}

