/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.MatchSetData;
import com.sun.jini.outrigger.MatchSetProxy;
import com.sun.jini.outrigger.OutriggerServer;
import com.sun.jini.outrigger.SnapshotRep;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.entry.UnusableEntriesException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.security.Security;
import net.jini.space.JavaSpace05;
import net.jini.space.MatchSet;

class SpaceProxy2
implements JavaSpace05,
Administrable,
ReferentUuid,
Serializable {
    static final long serialVersionUID = 1L;
    final OutriggerServer space;
    final Uuid spaceUuid;
    final long serverMaxServerQueryTimeout;
    private transient long maxServerQueryTimeout;
    private static final long maxServerQueryTimeoutPropertyValue = SpaceProxy2.getMaxServerQueryTimeoutPropertyValue();
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.proxy");

    SpaceProxy2(OutriggerServer space, Uuid spaceUuid, long serverMaxServerQueryTimeout) {
        if (space == null) {
            throw new NullPointerException("space must be non-null");
        }
        if (spaceUuid == null) {
            throw new NullPointerException("spaceUuid must be non-null");
        }
        if (serverMaxServerQueryTimeout <= 0L) {
            throw new IllegalArgumentException("serverMaxServerQueryTimeout must be positive");
        }
        this.space = space;
        this.spaceUuid = spaceUuid;
        this.serverMaxServerQueryTimeout = serverMaxServerQueryTimeout;
        this.setMaxServerQueryTimeout();
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.spaceUuid + " (through " + this.space + ")";
    }

    public boolean equals(Object other) {
        return ReferentUuids.compare(this, other);
    }

    public int hashCode() {
        return this.spaceUuid.hashCode();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.spaceUuid;
    }

    private static long getMaxServerQueryTimeoutPropertyValue() {
        try {
            String propValue = (String)Security.doPrivileged(new ReadProperityPrivilegedAction("com.sun.jini.outrigger.maxServerQueryTimeout"));
            if (propValue == null) {
                return -1L;
            }
            return Long.parseLong(propValue);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    private void setMaxServerQueryTimeout() {
        if (maxServerQueryTimeoutPropertyValue > 0L) {
            this.maxServerQueryTimeout = maxServerQueryTimeoutPropertyValue;
        } else if (this.serverMaxServerQueryTimeout > 0L) {
            this.maxServerQueryTimeout = this.serverMaxServerQueryTimeout;
        } else {
            throw new AssertionError((Object)("serverMaxServerQueryTimeout invalid:" + this.serverMaxServerQueryTimeout));
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Outrigger proxy using {0} ms for maxServerQueryTimeout", this.maxServerQueryTimeout);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.space == null) {
            throw new InvalidObjectException("null server reference");
        }
        if (this.spaceUuid == null) {
            throw new InvalidObjectException("null Uuid");
        }
        if (this.serverMaxServerQueryTimeout <= 0L) {
            throw new InvalidObjectException("Bad serverMaxServerQueryTimeout value:" + this.serverMaxServerQueryTimeout);
        }
        this.setMaxServerQueryTimeout();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("SpaceProxy2 should always have data");
    }

    @Override
    public Lease write(Entry entry, Transaction txn, long lease) throws TransactionException, RemoteException {
        if (entry == null) {
            throw new NullPointerException("Cannot write null Entry");
        }
        long[] leaseData = this.space.write(SpaceProxy2.repFor(entry), txn, lease);
        if (leaseData == null || leaseData.length != 3) {
            throw new AssertionError((Object)("space.write returned malformed data" + leaseData));
        }
        return this.newLease(UuidFactory.create(leaseData[1], leaseData[2]), leaseData[0]);
    }

    @Override
    public Entry read(Entry tmpl, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        long endTime = this.calcEndTime(timeout);
        long remaining = timeout;
        OutriggerServer.QueryCookie queryCookie = null;
        do {
            long serverTimeout = Math.min(remaining, this.maxServerQueryTimeout);
            this.logQuery("read", serverTimeout, queryCookie, remaining);
            Object rslt = this.space.read(SpaceProxy2.repFor(tmpl), txn, serverTimeout, queryCookie);
            if (rslt == null) {
                throw new AssertionError((Object)"space.read() returned null");
            }
            if (rslt instanceof EntryRep) {
                return SpaceProxy2.entryFrom((EntryRep)rslt);
            }
            if (!(rslt instanceof OutriggerServer.QueryCookie)) {
                throw new AssertionError((Object)"Unexpected return type from space.read()");
            }
            queryCookie = (OutriggerServer.QueryCookie)rslt;
        } while ((remaining = endTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    @Override
    public Entry readIfExists(Entry tmpl, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        long endTime = this.calcEndTime(timeout);
        long remaining = timeout;
        OutriggerServer.QueryCookie queryCookie = null;
        do {
            long serverTimeout = Math.min(remaining, this.maxServerQueryTimeout);
            this.logQuery("readIfExists", serverTimeout, queryCookie, remaining);
            Object rslt = this.space.readIfExists(SpaceProxy2.repFor(tmpl), txn, serverTimeout, queryCookie);
            if (rslt == null) {
                return null;
            }
            if (rslt instanceof EntryRep) {
                return SpaceProxy2.entryFrom((EntryRep)rslt);
            }
            if (!(rslt instanceof OutriggerServer.QueryCookie)) {
                throw new AssertionError((Object)"Unexpected return type from space.readIfExists()");
            }
            queryCookie = (OutriggerServer.QueryCookie)rslt;
        } while ((remaining = endTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    @Override
    public Entry take(Entry tmpl, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        long endTime = this.calcEndTime(timeout);
        long remaining = timeout;
        OutriggerServer.QueryCookie queryCookie = null;
        do {
            long serverTimeout = Math.min(remaining, this.maxServerQueryTimeout);
            this.logQuery("take", serverTimeout, queryCookie, remaining);
            Object rslt = this.space.take(SpaceProxy2.repFor(tmpl), txn, serverTimeout, queryCookie);
            if (rslt == null) {
                throw new AssertionError((Object)"space.take() returned null");
            }
            if (rslt instanceof EntryRep) {
                return SpaceProxy2.entryFrom((EntryRep)rslt);
            }
            if (!(rslt instanceof OutriggerServer.QueryCookie)) {
                throw new AssertionError((Object)"Unexpected return type from space.take()");
            }
            queryCookie = (OutriggerServer.QueryCookie)rslt;
        } while ((remaining = endTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    @Override
    public Entry takeIfExists(Entry tmpl, Transaction txn, long timeout) throws UnusableEntryException, TransactionException, InterruptedException, RemoteException {
        long endTime = this.calcEndTime(timeout);
        long remaining = timeout;
        OutriggerServer.QueryCookie queryCookie = null;
        do {
            long serverTimeout = Math.min(remaining, this.maxServerQueryTimeout);
            this.logQuery("takeIfExists", serverTimeout, queryCookie, remaining);
            Object rslt = this.space.takeIfExists(SpaceProxy2.repFor(tmpl), txn, serverTimeout, queryCookie);
            if (rslt == null) {
                return null;
            }
            if (rslt instanceof EntryRep) {
                return SpaceProxy2.entryFrom((EntryRep)rslt);
            }
            if (!(rslt instanceof OutriggerServer.QueryCookie)) {
                throw new AssertionError((Object)"Unexpected return type from space.takeIfExists()");
            }
            queryCookie = (OutriggerServer.QueryCookie)rslt;
        } while ((remaining = endTime - System.currentTimeMillis()) > 0L);
        return null;
    }

    @Override
    public Entry snapshot(Entry entry) throws MarshalException {
        if (entry == null) {
            return null;
        }
        return new SnapshotRep(entry);
    }

    @Override
    public EventRegistration notify(Entry tmpl, Transaction txn, RemoteEventListener listener, long lease, MarshalledObject handback) throws TransactionException, RemoteException {
        return this.space.notify(SpaceProxy2.repFor(tmpl), txn, listener, lease, handback);
    }

    @Override
    public List write(List entries, Transaction txn, List leaseDurations) throws RemoteException, TransactionException {
        long[] leases = new long[leaseDurations.size()];
        int j = 0;
        for (Object l : leaseDurations) {
            if (l == null) {
                throw new NullPointerException("leaseDurations contatins a null element");
            }
            if (!(l instanceof Long)) {
                throw new IllegalArgumentException("leaseDurations contatins an element which is not a Long");
            }
            leases[j++] = (Long)l;
        }
        long[] leaseData = this.space.write(SpaceProxy2.repFor(entries, "entries"), txn, leases);
        if (leaseData == null) {
            throw new AssertionError((Object)"space.write<multiple> returned null");
        }
        ArrayList<Lease> rslt = new ArrayList<Lease>(leaseData.length / 3);
        try {
            int m = 0;
            while (m < leaseData.length) {
                long duration = leaseData[m++];
                long high = leaseData[m++];
                long low = leaseData[m++];
                Uuid uuid = UuidFactory.create(high, low);
                rslt.add(this.newLease(uuid, duration));
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)"space.write<multiple> returned malformed data");
        }
        return rslt;
    }

    @Override
    public Collection take(Collection tmpls, Transaction txn, long timeout, long maxEntries) throws UnusableEntriesException, TransactionException, RemoteException {
        long endTime = this.calcEndTime(timeout);
        long remaining = timeout;
        OutriggerServer.QueryCookie queryCookie = null;
        EntryRep[] treps = SpaceProxy2.repFor(tmpls, "tmpls");
        if (maxEntries < 1L) {
            throw new IllegalArgumentException("maxEntries must be positive");
        }
        int limit = maxEntries <= Integer.MAX_VALUE ? (int)maxEntries : Integer.MAX_VALUE;
        do {
            long serverTimeout = Math.min(remaining, this.maxServerQueryTimeout);
            this.logQuery("take(multiple)", serverTimeout, queryCookie, remaining);
            Object rslt = this.space.take(treps, txn, serverTimeout, limit, queryCookie);
            if (rslt == null) {
                throw new AssertionError((Object)"space.take<multiple>() returned null");
            }
            if (rslt instanceof EntryRep[]) {
                EntryRep[] reps = (EntryRep[])rslt;
                LinkedList<Entry> entries = new LinkedList<Entry>();
                LinkedList<UnusableEntryException> exceptions = null;
                for (int i = 0; i < reps.length; ++i) {
                    try {
                        entries.add(SpaceProxy2.entryFrom(reps[i]));
                        continue;
                    }
                    catch (UnusableEntryException e) {
                        if (exceptions == null) {
                            exceptions = new LinkedList<UnusableEntryException>();
                        }
                        exceptions.add(e);
                    }
                }
                if (exceptions == null) {
                    return entries;
                }
                throw new UnusableEntriesException("some of the removed entries could not be unmarshalled", entries, exceptions);
            }
            if (!(rslt instanceof OutriggerServer.QueryCookie)) {
                throw new AssertionError((Object)"Unexpected return type from space.take<multiple>()");
            }
            queryCookie = (OutriggerServer.QueryCookie)rslt;
        } while ((remaining = endTime - System.currentTimeMillis()) > 0L);
        return Collections.EMPTY_LIST;
    }

    @Override
    public EventRegistration registerForAvailabilityEvent(Collection tmpls, Transaction txn, boolean visibilityOnly, RemoteEventListener listener, long leaseDuration, MarshalledObject handback) throws TransactionException, RemoteException {
        return this.space.registerForAvailabilityEvent(SpaceProxy2.repFor(tmpls, "tmpls"), txn, visibilityOnly, listener, leaseDuration, handback);
    }

    @Override
    public MatchSet contents(Collection tmpls, Transaction txn, long leaseDuration, long maxEntries) throws RemoteException, TransactionException {
        MatchSetData msd = this.space.contents(SpaceProxy2.repFor(tmpls, "tmpls"), txn, leaseDuration, maxEntries);
        return new MatchSetProxy(msd, this, this.space);
    }

    protected final Lease newLease(Uuid uuid, long duration) {
        long expiration = duration + System.currentTimeMillis();
        if (expiration < 0L) {
            expiration = Long.MAX_VALUE;
        }
        return this.constructLease(uuid, expiration);
    }

    protected Lease constructLease(Uuid uuid, long expiration) {
        return new LandlordLease(uuid, this.space, this.spaceUuid, expiration);
    }

    @Override
    public Object getAdmin() throws RemoteException {
        return this.space.getAdmin();
    }

    private long calcEndTime(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be non-negative");
        }
        long now = System.currentTimeMillis();
        if (Long.MAX_VALUE - timeout <= now) {
            return Long.MAX_VALUE;
        }
        return now + timeout;
    }

    static EntryRep[] repFor(Collection entries, String argName) throws MarshalException {
        EntryRep[] reps = new EntryRep[entries.size()];
        int j = 0;
        for (Object e : entries) {
            if (e != null && !(e instanceof Entry)) {
                throw new IllegalArgumentException(argName + " contatins an element which is not an Entry");
            }
            reps[j++] = SpaceProxy2.repFor((Entry)e);
        }
        return reps;
    }

    static EntryRep repFor(Entry entry) throws MarshalException {
        if (entry == null) {
            return null;
        }
        if (entry instanceof SnapshotRep) {
            return ((SnapshotRep)entry).rep();
        }
        return new EntryRep(entry);
    }

    static Entry entryFrom(EntryRep rep) throws UnusableEntryException {
        if (rep == null) {
            return null;
        }
        return rep.entry();
    }

    private void logQuery(String op, long serverTimeout, OutriggerServer.QueryCookie cookie, long remaining) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Outrigger calling {0} on server with timeout of {1} ms for serverTimeout, using QueryCookie {2}, {3} ms remaining on query", new Object[]{op, serverTimeout, cookie, remaining});
        }
    }

    private static class ReadProperityPrivilegedAction
    implements PrivilegedAction {
        private final String propName;

        ReadProperityPrivilegedAction(String propName) {
            this.propName = propName;
        }

        public Object run() {
            try {
                return System.getProperty(this.propName);
            }
            catch (SecurityException e) {
                return null;
            }
        }
    }
}

