/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.EventRegistrationWatcher;
import com.sun.jini.outrigger.StorableReference;
import com.sun.jini.outrigger.StorableResource;
import com.sun.jini.outrigger.TemplateHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.security.ProxyPreparer;

class StorableEventWatcher
extends EventRegistrationWatcher
implements StorableResource {
    private StorableReference listener;

    StorableEventWatcher(long timestamp, long startOrdinal, long currentSeqNum) {
        super(timestamp, startOrdinal, currentSeqNum);
    }

    StorableEventWatcher(long timestamp, long startOrdinal, Uuid cookie, MarshalledObject handback, long eventID, RemoteEventListener listener) {
        super(timestamp, startOrdinal, cookie, handback, eventID);
        if (listener == null) {
            throw new NullPointerException("listener must be non-null");
        }
        this.listener = new StorableReference(listener);
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        return ordinal > this.startOrdinal && transition.getTxn() == null && transition.isNewEntry();
    }

    @Override
    RemoteEventListener getListener(ProxyPreparer preparer) throws ClassNotFoundException, IOException {
        return (RemoteEventListener)this.listener.get(preparer);
    }

    @Override
    void cleanup(TemplateHandle owner, boolean expired) {
        if (expired) {
            owner.getServer().scheduleCancelOp(this.cookie);
        } else {
            owner.getServer().cancelOp(this.cookie, false);
        }
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        this.cookie.write(out);
        out.writeLong(this.expiration);
        out.writeLong(this.eventID);
        out.writeObject(this.handback);
        out.writeObject(this.listener);
    }

    @Override
    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cookie = UuidFactory.read(in);
        this.expiration = in.readLong();
        this.eventID = in.readLong();
        this.handback = (MarshalledObject)in.readObject();
        this.listener = (StorableReference)in.readObject();
        if (this.listener == null) {
            throw new StreamCorruptedException("Stream corrupted, should not be null");
        }
    }
}

