/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHolder;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

class TxnState {
    private Object mgrs;
    private int state;
    private final EntryHolder holder;
    private static final Logger matchingLogger = Logger.getLogger("com.sun.jini.outrigger.entryMatching");
    private static final Logger txnLogger = Logger.getLogger("com.sun.jini.outrigger.transactions");
    private final TransactableMgr[] rslt = new TransactableMgr[1];

    TxnState(TransactableMgr mgr, int state, EntryHolder holder) {
        this.mgrs = mgr;
        this.state = state;
        this.holder = holder;
        txnLogger.log(Level.FINER, "TxnState: TxnState: state = {0}", TransactableMgr.stateNames[state]);
    }

    int prepare(TransactableMgr mgr, OutriggerServerImpl space, EntryHandle owner) {
        txnLogger.log(Level.FINEST, "TxnState: prepare: state = {0}", TransactableMgr.stateNames[this.state]);
        if (this.state == 2) {
            int locksLeft = this.removeMgr(mgr);
            if (locksLeft <= 1 && !owner.removed()) {
                if (locksLeft == 1) {
                    space.recordTransition(new EntryTransition(owner, this.mgr(), true, false, false));
                } else if (locksLeft == 0) {
                    space.recordTransition(new EntryTransition(owner, null, true, false, false));
                } else {
                    throw new AssertionError((Object)"Fewer than 0 locks left");
                }
            }
            return 4;
        }
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean abort(TransactableMgr mgr, OutriggerServerImpl space, EntryHandle owner) {
        boolean rslt = true;
        txnLogger.log(Level.FINEST, "TxnState: abort: state = {0}", TransactableMgr.stateNames[this.state]);
        if (this.state == 2 || this.state == 3) {
            int locksLeft = this.removeMgr(mgr);
            boolean bl = rslt = locksLeft == 0;
            if (locksLeft > 1 || owner.removed()) return rslt;
            if (locksLeft == 1) {
                assert (this.state == 2);
                space.recordTransition(new EntryTransition(owner, this.mgr(), true, false, false));
                return rslt;
            } else {
                if (locksLeft != 0) throw new AssertionError((Object)"Fewer than 0 locks left");
                boolean visibility = this.state == 3;
                space.recordTransition(new EntryTransition(owner, null, true, visibility, false));
            }
            return rslt;
        } else {
            this.holder.remove(owner, false);
        }
        return rslt;
    }

    boolean commit(TransactableMgr mgr, OutriggerServerImpl space, EntryHandle owner) {
        txnLogger.log(Level.FINEST, "TxnState: commit: state = {0}", TransactableMgr.stateNames[this.state]);
        switch (this.state) {
            case 1: {
                if (owner.removed()) {
                    return true;
                }
                space.recordTransition(new EntryTransition(owner, null, true, true, true));
                return this.removeMgr(mgr) == 0;
            }
            case 2: {
                throw new InternalSpaceException("committing a read locked entry");
            }
            case 3: {
                this.holder.remove(owner, false);
                return true;
            }
        }
        throw new InternalSpaceException("unexpected state in TxnState.commit(): " + this.state);
    }

    private int removeMgr(TransactableMgr mgr) {
        if (this.mgrs == null) {
            return 0;
        }
        if (mgr == this.mgrs) {
            this.mgrs = null;
            return 0;
        }
        HashSet tab = (HashSet)this.mgrs;
        tab.remove(mgr);
        return tab.size();
    }

    void add(TransactableMgr mgr, int op) {
        if (mgr == this.mgrs) {
            return;
        }
        if (this.mgrs instanceof TransactableMgr) {
            Object origMgr = this.mgrs;
            this.mgrs = new HashSet(7);
            ((HashSet)this.mgrs).add(origMgr);
        }
        ((HashSet)this.mgrs).add(mgr);
        this.monitor(mgr);
        this.state = op;
    }

    private void monitor(TransactableMgr mgr) {
        Txn txn = (Txn)mgr;
        for (Txn otherTxn : (HashSet)this.mgrs) {
            if (otherTxn == mgr || otherTxn.monitorTask() == null) continue;
            otherTxn.monitorTask().addSibling(txn);
            return;
        }
    }

    boolean promoteToTakeIfNeeded() {
        if (this.state == 1) {
            return false;
        }
        this.state = 3;
        return true;
    }

    boolean canPerform(TransactableMgr mgr, int op) {
        if (matchingLogger.isLoggable(Level.FINER)) {
            matchingLogger.log(Level.FINER, "TxnState: canPerform({0}, {1}): state = {2}", new Object[]{mgr, op, TransactableMgr.stateNames[this.state]});
        }
        switch (this.state) {
            case 2: {
                if (op == 2) {
                    return true;
                }
                return this.onlyMgr(mgr);
            }
            case 1: {
                if (op == 2 || op == 3) {
                    return this.onlyMgr(mgr);
                }
                return false;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    boolean knownMgr(TransactableMgr mgr) {
        if (mgr == null) {
            return false;
        }
        if (mgr == this.mgrs) {
            return true;
        }
        if (this.mgrs instanceof HashSet) {
            return ((HashSet)this.mgrs).contains(mgr);
        }
        return false;
    }

    boolean onlyMgr(TransactableMgr mgr) {
        if (mgr == null) {
            return false;
        }
        if (mgr == this.mgrs) {
            return true;
        }
        if (this.mgrs instanceof HashSet) {
            HashSet tab = (HashSet)this.mgrs;
            return tab.size() == 1 && tab.contains(mgr);
        }
        return false;
    }

    void addTxns(Collection collection) {
        if (this.mgrs == null) {
            return;
        }
        if (this.mgrs instanceof HashSet) {
            HashSet tab = (HashSet)this.mgrs;
            collection.addAll((HashSet)this.mgrs);
            return;
        }
        collection.add(this.mgrs);
    }

    boolean empty() {
        if (this.mgrs == null) {
            return true;
        }
        if (this.mgrs instanceof HashSet) {
            return ((HashSet)this.mgrs).isEmpty();
        }
        return false;
    }

    private TransactableMgr mgr() {
        if (this.mgrs == null) {
            throw new AssertionError((Object)"mgr() called on a TxnState with no manager");
        }
        if (this.mgrs instanceof HashSet) {
            HashSet tab = (HashSet)this.mgrs;
            if (tab.size() != 1) {
                throw new AssertionError((Object)"mgr() called on TxnState with more than one manager");
            }
            tab.toArray(this.rslt);
            return this.rslt[0];
        }
        return (TransactableMgr)this.mgrs;
    }
}

