/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import java.io.Serializable;
import java.util.Arrays;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

class ByteArrayWrapper
implements Serializable {
    private byte[] uuid;
    private int hash;

    ByteArrayWrapper(byte[] v) {
        this.uuid = v;
        this.hash = ByteArrayWrapper.hashFor(v);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteArrayWrapper)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        byte[] ouuid = ((ByteArrayWrapper)o).uuid;
        return Arrays.equals(this.uuid, ouuid);
    }

    public int hashCode() {
        return this.hash;
    }

    static byte[] toByteArray(Uuid uuid) {
        byte[] rslt = new byte[16];
        long bits0 = uuid.getMostSignificantBits();
        for (int i = 7; i >= 0; --i) {
            rslt[i] = (byte)bits0;
            bits0 >>>= 8;
        }
        long bits1 = uuid.getLeastSignificantBits();
        for (int i = 15; i >= 8; --i) {
            rslt[i] = (byte)bits1;
            bits1 >>>= 8;
        }
        return rslt;
    }

    static Uuid toUuid(byte[] bits) {
        if (bits.length != 16) {
            throw new IllegalArgumentException("uuid.length must be 16");
        }
        long bits0 = 0L;
        for (int i = 0; i < 7; ++i) {
            bits0 |= (long)(bits[i] & 0xFF);
            bits0 <<= 8;
        }
        bits0 |= (long)(bits[7] & 0xFF);
        long bits1 = 0L;
        for (int i = 8; i < 15; ++i) {
            bits1 |= (long)(bits[i] & 0xFF);
            bits1 <<= 8;
        }
        return UuidFactory.create(bits0, bits1 |= (long)(bits[15] & 0xFF));
    }

    static int hashFor(byte[] uuid) {
        if (uuid.length != 16) {
            throw new IllegalArgumentException("uuid.length must be 16");
        }
        return (uuid[15] ^ uuid[11] ^ uuid[7] ^ uuid[3]) << 24 | (uuid[14] ^ uuid[10] ^ uuid[6] ^ uuid[2]) << 16 | (uuid[13] ^ uuid[9] ^ uuid[5] ^ uuid[1]) << 8 | (uuid[12] ^ uuid[8] ^ uuid[4] ^ uuid[0]) << 0;
    }
}

