/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.ExecOptionPermission;
import com.sun.jini.phoenix.ExecPermission;
import com.sun.jini.phoenix.GroupPolicy;
import java.rmi.activation.ActivationGroupDesc;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Enumeration;
import java.util.Properties;
import net.jini.jeri.BasicInvocationDispatcher;

public class DefaultGroupPolicy
implements GroupPolicy {
    @Override
    public void checkGroup(ActivationGroupDesc desc) {
        ActivationGroupDesc.CommandEnvironment cmdenv;
        String groupClassName = desc.getClassName();
        if (groupClassName != null && !groupClassName.equals("com.sun.jini.phoenix.ActivationGroupImpl") || desc.getLocation() != null || desc.getData() != null) {
            throw new AccessControlException("access denied (custom group implementation not allowed)");
        }
        Properties props = desc.getPropertyOverrides();
        if (props != null) {
            Enumeration<?> p = props.propertyNames();
            while (p.hasMoreElements()) {
                String name = (String)p.nextElement();
                String option = "\"-D" + name + "=" + props.getProperty(name) + "\"";
                this.checkPermission(new ExecOptionPermission(option));
            }
        }
        if ((cmdenv = desc.getCommandEnvironment()) != null) {
            String[] options;
            String path = cmdenv.getCommandPath();
            if (path != null) {
                this.checkPermission(new ExecPermission(path));
            }
            if ((options = cmdenv.getCommandOptions()) != null) {
                for (int i = 0; i < options.length; ++i) {
                    this.checkPermission(new ExecOptionPermission("\"" + options[i] + "\""));
                }
            }
        }
    }

    protected void checkPermission(Permission p) {
        BasicInvocationDispatcher.checkClientPermission(p);
    }
}

