/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AbstractSystem;
import com.sun.jini.phoenix.ActivationAdmin;
import com.sun.jini.phoenix.DefaultGroupPolicy;
import com.sun.jini.phoenix.GroupPolicy;
import com.sun.jini.phoenix.LocalAccess;
import com.sun.jini.phoenix.SunJrmpExporter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.server.ExportException;
import java.util.Map;
import net.jini.export.Exporter;

public class SystemAccessExporter
implements Exporter {
    private final Exporter exporter;
    private final GroupPolicy policy;
    private Remote wrapped;

    public SystemAccessExporter() {
        this(1098);
    }

    public SystemAccessExporter(GroupPolicy policy) {
        this(1098, policy);
    }

    public SystemAccessExporter(int port) {
        this(port, (GroupPolicy)new DefaultGroupPolicy());
    }

    public SystemAccessExporter(int port, GroupPolicy policy) {
        this(new SunJrmpExporter(4, port), policy);
    }

    public SystemAccessExporter(Exporter exporter) {
        this(exporter, (GroupPolicy)new DefaultGroupPolicy());
    }

    public SystemAccessExporter(Exporter exporter, GroupPolicy policy) {
        this.exporter = exporter;
        this.policy = policy;
    }

    @Override
    public Remote export(Remote impl) throws ExportException {
        if (!(impl instanceof ActivationSystem)) {
            throw new IllegalArgumentException("not an ActivationSystem");
        }
        if (!(impl instanceof ActivationAdmin)) {
            throw new IllegalArgumentException("not an ActivationAdmin");
        }
        SystemImpl wrapped = new SystemImpl((ActivationSystem)impl, this.policy);
        Remote proxy = this.exporter.export(wrapped);
        this.wrapped = wrapped;
        return proxy;
    }

    @Override
    public boolean unexport(boolean force) {
        return this.exporter.unexport(force);
    }

    private static class SystemImpl
    extends AbstractSystem {
        private final ActivationSystem impl;
        private final GroupPolicy policy;

        SystemImpl(ActivationSystem impl, GroupPolicy policy) {
            this.impl = impl;
            this.policy = policy;
        }

        public ActivationID registerObject(ActivationDesc desc) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.registerObject(desc);
        }

        public void unregisterObject(ActivationID id) throws ActivationException, RemoteException {
            LocalAccess.check();
            this.impl.unregisterObject(id);
        }

        public ActivationGroupID registerGroup(ActivationGroupDesc desc) throws ActivationException, RemoteException {
            LocalAccess.check();
            if (this.policy != null) {
                this.policy.checkGroup(desc);
            }
            return this.impl.registerGroup(desc);
        }

        public ActivationMonitor activeGroup(ActivationGroupID id, ActivationInstantiator group, long incarnation) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.activeGroup(id, group, incarnation);
        }

        public void unregisterGroup(ActivationGroupID id) throws ActivationException, RemoteException {
            LocalAccess.check();
            this.impl.unregisterGroup(id);
        }

        public ActivationDesc setActivationDesc(ActivationID id, ActivationDesc desc) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.setActivationDesc(id, desc);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID id, ActivationGroupDesc desc) throws ActivationException, RemoteException {
            LocalAccess.check();
            if (this.policy != null) {
                this.policy.checkGroup(desc);
            }
            return this.impl.setActivationGroupDesc(id, desc);
        }

        public ActivationDesc getActivationDesc(ActivationID id) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.getActivationDesc(id);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID id) throws ActivationException, RemoteException {
            LocalAccess.check();
            return this.impl.getActivationGroupDesc(id);
        }

        public void shutdown() throws RemoteException {
            LocalAccess.check();
            this.impl.shutdown();
        }

        @Override
        public Map getActivationGroups() throws RemoteException {
            LocalAccess.check();
            return ((ActivationAdmin)this.impl).getActivationGroups();
        }

        @Override
        public Map getActivatableObjects(ActivationGroupID id) throws UnknownGroupException, RemoteException {
            LocalAccess.check();
            return ((ActivationAdmin)this.impl).getActivatableObjects(id);
        }
    }
}

