/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import net.jini.io.MarshalledInstance;
import net.jini.io.ObjectStreamContext;
import net.jini.io.context.IntegrityEnforcement;

public class MarshalledWrapper
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final MarshalledInstance instance;
    private transient boolean integrity = false;

    public static boolean integrityEnforced(ObjectInputStream stream) {
        if (stream instanceof ObjectStreamContext) {
            Collection ctx = ((ObjectStreamContext)((Object)stream)).getObjectStreamContext();
            for (Object obj : ctx) {
                if (!(obj instanceof IntegrityEnforcement)) continue;
                return ((IntegrityEnforcement)obj).integrityEnforced();
            }
        }
        return false;
    }

    public MarshalledWrapper(Object obj) throws IOException {
        this.instance = new MarshalledInstance(obj);
    }

    public MarshalledWrapper(MarshalledInstance instance) {
        if (instance == null) {
            throw new NullPointerException();
        }
        this.instance = instance;
    }

    public Object get() throws IOException, ClassNotFoundException {
        return this.instance.get(this.integrity);
    }

    public MarshalledInstance getMarshalledInstance() {
        return this.instance;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public int hashCode() {
        return MarshalledWrapper.class.hashCode() ^ this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.instance.equals(((MarshalledWrapper)obj).instance);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.instance == null) {
            throw new InvalidObjectException("null instance");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(in);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

