/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.http;

import com.sun.jini.jeri.internal.http.ConnectionTimer;
import com.sun.jini.jeri.internal.http.HttpClientConnection;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpSettings;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.http.Constraints;
import net.jini.security.proxytrust.TrustEquivalence;

public final class HttpEndpoint
implements Endpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -7094180943307123931L;
    private static final Map internTable = new WeakHashMap();
    private static final HttpClientManager clientManager;
    private static final ConnectionTimer connTimer;
    private static final Logger logger;
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private transient Set connections;
    private transient String proxyHost;
    private transient int proxyPort;
    private transient boolean persist;
    private transient long timeLastVerified;

    public static HttpEndpoint getInstance(String host, int port) {
        return HttpEndpoint.intern(new HttpEndpoint(host, port, null));
    }

    public static HttpEndpoint getInstance(String host, int port, SocketFactory sf) {
        return HttpEndpoint.intern(new HttpEndpoint(host, port, sf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpEndpoint intern(HttpEndpoint endpoint) {
        Map map = internTable;
        synchronized (map) {
            HttpEndpoint canonical;
            SoftReference ref = (SoftReference)internTable.get(endpoint);
            if (ref != null && (canonical = (HttpEndpoint)((Reference)ref).get()) != null) {
                return canonical;
            }
            endpoint.init();
            internTable.put(endpoint, new SoftReference<HttpEndpoint>(endpoint));
            return endpoint;
        }
    }

    private HttpEndpoint(String host, int port, SocketFactory sf) {
        if (host == null) {
            throw new NullPointerException();
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.sf = sf;
    }

    private Object readResolve() {
        return HttpEndpoint.intern(this);
    }

    private void init() {
        this.connections = new HashSet(5);
        this.proxyHost = "";
        this.proxyPort = -1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    @Override
    public OutboundRequestIterator newRequest(final InvocationConstraints constraints) {
        if (constraints == null) {
            throw new NullPointerException();
        }
        return new OutboundRequestIterator(){
            private boolean nextCalled = false;
            private OutboundRequest currentRequest;

            @Override
            public OutboundRequest next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextCalled = true;
                this.currentRequest = HttpEndpoint.this.nextRequest(constraints);
                return this.currentRequest;
            }

            @Override
            public boolean hasNext() {
                return !this.nextCalled;
            }
        };
    }

    private OutboundRequest nextRequest(InvocationConstraints constraints) throws IOException {
        final Constraints.Distilled distilled = Constraints.distill(constraints, false);
        final OutboundRequest request = this.nextRequest(distilled);
        return new OutboundRequest(){

            @Override
            public void populateContext(Collection context) {
                request.populateContext(context);
            }

            @Override
            public InvocationConstraints getUnfulfilledConstraints() {
                return distilled.getUnfulfilledConstraints();
            }

            @Override
            public OutputStream getRequestOutputStream() {
                return request.getRequestOutputStream();
            }

            @Override
            public InputStream getResponseInputStream() {
                return request.getResponseInputStream();
            }

            @Override
            public boolean getDeliveryStatus() {
                return request.getDeliveryStatus();
            }

            @Override
            public void abort() {
                request.abort();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object connectionAction(final Constraints.Distilled distilled, final String phost, final int pport, final boolean ppersist, ConnectionAction action) throws IOException {
        Connection conn;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "about to perform nextRequest on {0}", this);
        }
        boolean usingProxy = phost.length() != 0;
        Set set = this.connections;
        synchronized (set) {
            if (!this.proxyHost.equals(phost) || this.proxyPort != pport || this.persist != ppersist) {
                this.proxyHost = phost;
                this.proxyPort = pport;
                this.persist = ppersist;
                this.shedConnections();
            }
            boolean checkedResolvePermission = false;
            Iterator i = this.connections.iterator();
            while (i.hasNext()) {
                block23: {
                    conn = (Connection)i.next();
                    if (!usingProxy) {
                        if (!checkedResolvePermission) {
                            try {
                                this.checkResolvePermission();
                            }
                            catch (SecurityException e) {
                                if (logger.isLoggable(Levels.FAILED)) {
                                    LogUtil.logThrow(logger, Levels.FAILED, HttpEndpoint.class, "nextRequest", "exception resolving host {0}", new Object[]{this.host}, e);
                                }
                                throw e;
                            }
                            checkedResolvePermission = true;
                        }
                        try {
                            conn.checkConnectPermission();
                        }
                        catch (SecurityException e) {
                            if (!logger.isLoggable(Levels.HANDLED)) continue;
                            LogUtil.logThrow(logger, Levels.HANDLED, HttpEndpoint.class, "nextRequest", "access to reuse connection {0} denied", new Object[]{conn.getSocket()}, e);
                            continue;
                        }
                    }
                    i.remove();
                    if (connTimer.cancelTimeout(conn)) {
                        try {
                            Object obj = action.run(conn);
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "nextRequest on existing connection {0}", conn.getSocket());
                            }
                            return obj;
                        }
                        catch (IOException ex) {
                            if (!logger.isLoggable(Levels.HANDLED)) break block23;
                            LogUtil.logThrow(logger, Levels.HANDLED, HttpEndpoint.class, "nextRequest", "nextRequest on existing connection {0} throws", new Object[]{this}, ex);
                        }
                    }
                }
                conn.shutdown(true);
            }
        }
        try {
            conn = !usingProxy ? new Connection(this.host, this.port, distilled) : (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Connection(HttpEndpoint.this.host, HttpEndpoint.this.port, phost, pport, ppersist, distilled);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
        try {
            Object obj = action.run(conn);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "nextRequest on new connection {0}", this);
            }
            return obj;
        }
        catch (IOException ex) {
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, HttpEndpoint.class, "nextRequest", "nextRequest on new connection {0} throws IOException", new Object[]{this}, ex);
            }
            throw ex;
        }
    }

    private OutboundRequest nextRequest(Constraints.Distilled distilled) throws IOException {
        boolean ppersist;
        int pport;
        boolean usingProxy;
        HttpSettings settings = HttpEndpoint.getHttpSettings();
        String phost = settings.getProxyHost(this.host);
        boolean bl = usingProxy = phost.length() != 0;
        if (!usingProxy) {
            pport = -1;
            ppersist = true;
        } else {
            pport = settings.getProxyPort();
            ppersist = !settings.getDisableProxyPersistentConnections();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkConnect(this.host, this.port);
            }
            long now = System.currentTimeMillis();
            if (settings.getPingProxyConnections() && now - this.timeLastVerified > settings.getPingProxyConnectionTimeout()) {
                Object obj = this.connectionAction(distilled, phost, pport, ppersist, new ConnectionAction(){

                    @Override
                    public Object run(Connection conn) throws IOException {
                        return conn.ping();
                    }
                });
                if (!((Boolean)obj).booleanValue()) {
                    throw new IOException("HTTP ping via proxy failed.");
                }
                this.timeLastVerified = System.currentTimeMillis();
            }
        }
        Object obj = this.connectionAction(distilled, phost, pport, ppersist, new ConnectionAction(){

            @Override
            public Object run(Connection conn) throws IOException {
                return conn.newRequest();
            }
        });
        return (OutboundRequest)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shedConnections() {
        Set set = this.connections;
        synchronized (set) {
            Object[] conns = this.connections.toArray();
            this.connections.clear();
            for (int i = 0; i < conns.length; ++i) {
                ((Connection)conns[i]).shutdown(true);
            }
        }
    }

    private void checkResolvePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(this.host, -1);
        }
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ (this.sf != null ? this.sf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpEndpoint)) {
            return false;
        }
        HttpEndpoint other = (HttpEndpoint)obj;
        return this.host.equals(other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf);
    }

    @Override
    public boolean checkTrustEquivalence(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpEndpoint)) {
            return false;
        }
        HttpEndpoint other = (HttpEndpoint)obj;
        return this.host.equals(other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf);
    }

    public String toString() {
        return "HttpEndpoint[" + this.host + ":" + this.port + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.host == null) {
            throw new InvalidObjectException("null host");
        }
        if (this.port < 1 || this.port > 65535) {
            throw new InvalidObjectException("port number out of range: " + this.port);
        }
    }

    static HttpSettings getHttpSettings() {
        return (HttpSettings)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return HttpSettings.getHttpSettings(false);
            }
        });
    }

    private static void setSocketOptions(Socket socket) {
        block5: {
            block4: {
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    LogUtil.logThrow(logger, Levels.HANDLED, HttpEndpoint.class, "setSocketOptions", "exception setting TCP_NODELAY on socket {0}", new Object[]{socket}, e);
                }
            }
            try {
                socket.setKeepAlive(true);
            }
            catch (SocketException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block5;
                LogUtil.logThrow(logger, Levels.HANDLED, HttpEndpoint.class, "setSocketOptions", "exception setting SO_KEEPALIVE on socket {0}", new Object[]{socket}, e);
            }
        }
    }

    static {
        HttpSettings hs = HttpEndpoint.getHttpSettings();
        clientManager = new HttpClientManager(hs.getResponseAckTimeout());
        connTimer = new ConnectionTimer(hs.getConnectionTimeout());
        logger = Logger.getLogger("net.jini.jeri.http.client");
    }

    private final class Connection
    extends HttpClientConnection {
        private final String proxyHost;
        private final int proxyPort;

        Connection(String host, int port, Constraints.Distilled distilled) throws IOException {
            super(host, port, new SocketFactoryAdapter(HttpEndpoint.this.sf, distilled), clientManager);
            this.proxyHost = "";
            this.proxyPort = -1;
        }

        Connection(String host, int port, String proxyHost, int proxyPort, boolean persist, Constraints.Distilled distilled) throws IOException {
            super(host, port, proxyHost, proxyPort, false, persist, new SocketFactoryAdapter(HttpEndpoint.this.sf, distilled), clientManager);
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void idle() {
            Set set = HttpEndpoint.this.connections;
            synchronized (set) {
                if (this.proxyHost.equals(HttpEndpoint.this.proxyHost) && this.proxyPort == HttpEndpoint.this.proxyPort && HttpEndpoint.this.persist == HttpEndpoint.this.persist) {
                    HttpEndpoint.this.connections.add(this);
                    connTimer.scheduleTimeout(this, false);
                } else {
                    super.shutdown(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shutdown(boolean force) {
            boolean socketClosed;
            Socket sock = this.getSocket();
            Set set = HttpEndpoint.this.connections;
            synchronized (set) {
                socketClosed = super.shutdown(force);
                if (socketClosed) {
                    HttpEndpoint.this.connections.remove(this);
                    connTimer.cancelTimeout(this);
                }
            }
            if (socketClosed) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "closed socket {0}", sock);
                }
                return true;
            }
            return false;
        }

        void checkConnectPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                Socket socket = this.getSocket();
                InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
                if (address.isUnresolved()) {
                    sm.checkConnect(address.getHostName(), socket.getPort());
                } else {
                    sm.checkConnect(address.getAddress().getHostAddress(), socket.getPort());
                }
            }
        }
    }

    private static final class SocketFactoryAdapter
    implements HttpClientSocketFactory {
        private final SocketFactory sf;
        private final Constraints.Distilled distilled;

        SocketFactoryAdapter(SocketFactory sf, Constraints.Distilled distilled) {
            this.sf = sf;
            this.distilled = distilled;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = this.connectToHost(host, port, this.distilled);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "connected socket {0}", socket);
            }
            HttpEndpoint.setSocketOptions(socket);
            return socket;
        }

        private Socket connectToHost(String host, int port, Constraints.Distilled distilled) throws IOException {
            InetAddress[] addresses;
            try {
                addresses = InetAddress.getAllByName(host);
            }
            catch (UnknownHostException uhe) {
                try {
                    return this.connectToSocketAddress(new InetSocketAddress(host, port), distilled);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{host + ":" + port}, e);
                    }
                    throw e;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        LogUtil.logThrow(logger, Levels.FAILED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{host + ":" + port}, e);
                    }
                    throw e;
                }
            }
            catch (SecurityException e) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, SocketFactoryAdapter.class, "connectToHost", "exception resolving host {0}", new Object[]{host}, e);
                }
                throw e;
            }
            IOException lastIOException = null;
            SecurityException lastSecurityException = null;
            for (int i = 0; i < addresses.length; ++i) {
                InetSocketAddress socketAddress = new InetSocketAddress(addresses[i], port);
                try {
                    return this.connectToSocketAddress(socketAddress, distilled);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastIOException = e;
                    if (!(e instanceof SocketTimeoutException)) continue;
                    break;
                }
                catch (SecurityException e) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        LogUtil.logThrow(logger, Levels.HANDLED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                    }
                    lastSecurityException = e;
                }
            }
            if (lastIOException != null) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to {0}", new Object[]{host + ":" + port}, lastIOException);
                }
                throw lastIOException;
            }
            assert (lastSecurityException != null);
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, SocketFactoryAdapter.class, "connectToHost", "exception connecting to {0}", new Object[]{host + ":" + port}, lastSecurityException);
            }
            throw lastSecurityException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Socket connectToSocketAddress(SocketAddress socketAddress, Constraints.Distilled distilled) throws IOException {
            int timeout;
            if (distilled.hasConnectDeadline()) {
                long now = System.currentTimeMillis();
                long deadline = distilled.getConnectDeadline();
                if (deadline <= now) {
                    throw new SocketTimeoutException("deadline past before connect attempt");
                }
                assert (now > 0L);
                long delta = deadline - now;
                timeout = delta > Integer.MAX_VALUE ? 0 : (int)delta;
            } else {
                timeout = 0;
            }
            Socket socket = this.newSocket();
            boolean ok = false;
            try {
                socket.connect(socketAddress, timeout);
                ok = true;
                Socket socket2 = socket;
                return socket2;
            }
            finally {
                if (!ok) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private Socket newSocket() throws IOException {
            Socket socket = this.sf != null ? this.sf.createSocket() : new Socket();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, this.sf == null ? "created socket {0}" : "created socket {0} using factory {1}", new Object[]{socket, this.sf});
            }
            return socket;
        }

        @Override
        public Socket createTunnelSocket(Socket s) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static interface ConnectionAction {
        public Object run(Connection var1) throws IOException;
    }
}

