/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ClientAuthManager;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.Security;

class SslConnection
extends Utilities
implements Connection {
    private final long maxClientSessionDuration = (Long)Security.doPrivileged(new GetLongAction("com.sun.jini.jeri.ssl.maxClientSessionDuration", 84600000L));
    private static final Logger logger = clientLogger;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    final CallContext callContext;
    private final SSLContext sslContext;
    final SSLSocketFactory sslSocketFactory;
    private final ClientAuthManager authManager;
    volatile SSLSocket sslSocket;
    private volatile String activeCipherSuite;
    private volatile SSLSession session;
    volatile boolean closed;

    SslConnection(CallContext callContext, String serverHost, int port, SocketFactory socketFactory) {
        this.serverHost = serverHost;
        this.port = port;
        this.socketFactory = socketFactory;
        if (callContext == null) {
            throw new NullPointerException("Call context cannot be null");
        }
        this.callContext = callContext;
        Utilities.SSLContextInfo info = SslConnection.getClientSSLContextInfo(callContext);
        this.sslContext = info.sslContext;
        this.sslSocketFactory = this.sslContext.getSocketFactory();
        this.authManager = (ClientAuthManager)info.authManager;
    }

    final void establishCallContext() throws IOException {
        Exception exception;
        block12: {
            try {
                this.establishNewSocket();
                if (this.callContext.clientAuthRequired && !this.authManager.getClientAuthenticated()) {
                    Exception credExcept = this.authManager.getClientCredentialException();
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        try {
                            sm.checkPermission(getSubjectPermission);
                        }
                        catch (SecurityException e) {
                            credExcept = null;
                        }
                    }
                    exception = credExcept instanceof SecurityException ? (SecurityException)credExcept : new UnsupportedConstraintException("Client not authenticated", credExcept);
                    break block12;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "new connection for {0}\ncreates {1}", new Object[]{this.callContext, this});
                }
                return;
            }
            catch (SSLProtocolException e) {
                exception = e;
            }
            catch (SSLException e) {
                exception = new UnsupportedConstraintException(e.getMessage(), e);
            }
            catch (IOException e) {
                exception = e;
            }
            catch (SecurityException e) {
                exception = e;
            }
        }
        if (logger.isLoggable(Levels.FAILED)) {
            SslConnection.logThrow(logger, Levels.FAILED, SslConnection.class, "establishCallContext", "new connection for {0}\nthrows", new Object[]{this.callContext}, exception);
        }
        this.closeSocket();
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw (SecurityException)exception;
    }

    private void closeSocket() {
        if (this.sslSocket != null) {
            try {
                this.sslSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sslSocket = null;
            this.session = null;
            this.activeCipherSuite = null;
        }
    }

    void establishNewSocket() throws IOException {
        Socket socket = this.createPlainSocket(this.serverHost, this.port);
        this.sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, this.serverHost, this.port, true);
        this.establishSuites();
    }

    final void establishSuites() throws IOException {
        this.sslSocket.setEnabledCipherSuites(this.callContext.cipherSuites);
        this.sslSocket.startHandshake();
        this.session = this.sslSocket.getSession();
        this.activeCipherSuite = this.session.getCipherSuite();
        this.sslSocket.setEnableSessionCreation(false);
        SslConnection.releaseClientSSLContextInfo(this.callContext, this.sslContext, this.authManager);
    }

    final Socket createPlainSocket(String host, int port) throws IOException {
        Socket socket = !this.callContext.endpointImpl.disableSocketConnect ? this.connectToHost(host, port, this.callContext.connectionTime) : this.newSocket();
        return socket;
    }

    private static int computeTimeout(long connectionTime) throws IOException {
        int timeout;
        long current = System.currentTimeMillis();
        if (connectionTime == -1L) {
            timeout = 0;
        } else {
            if (connectionTime < current) {
                throw new IOException("Connection not made within specified time");
            }
            timeout = connectionTime - current > Integer.MAX_VALUE ? 0 : (int)(connectionTime - current);
        }
        return timeout;
    }

    private Socket connectToHost(String host, int port, long connectionTime) throws IOException {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException uhe) {
            try {
                return this.connectToSocketAddress(new InetSocketAddress(host, port), connectionTime);
            }
            catch (IOException e) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, SslConnection.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{host + ":" + port}, e);
                }
                throw e;
            }
            catch (SecurityException e) {
                if (logger.isLoggable(Levels.FAILED)) {
                    LogUtil.logThrow(logger, Levels.FAILED, SslConnection.class, "connectToHost", "exception connecting to unresolved host {0}", new Object[]{host + ":" + port}, e);
                }
                throw e;
            }
        }
        catch (SecurityException e) {
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, SslConnection.class, "connectToHost", "exception resolving host {0}", new Object[]{host}, e);
            }
            throw e;
        }
        IOException lastIOException = null;
        SecurityException lastSecurityException = null;
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress socketAddress = new InetSocketAddress(addresses[i], port);
            try {
                return this.connectToSocketAddress(socketAddress, connectionTime);
            }
            catch (IOException e) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    LogUtil.logThrow(logger, Levels.HANDLED, SslConnection.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                }
                lastIOException = e;
                if (!(e instanceof SocketTimeoutException)) continue;
                break;
            }
            catch (SecurityException e) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    LogUtil.logThrow(logger, Levels.HANDLED, SslConnection.class, "connectToHost", "exception connecting to {0}", new Object[]{socketAddress}, e);
                }
                lastSecurityException = e;
            }
        }
        if (lastIOException != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                LogUtil.logThrow(logger, Levels.FAILED, SslConnection.class, "connectToHost", "exception connecting to {0}", new Object[]{host + ":" + port}, lastIOException);
            }
            throw lastIOException;
        }
        assert (lastSecurityException != null);
        if (logger.isLoggable(Levels.FAILED)) {
            LogUtil.logThrow(logger, Levels.FAILED, SslConnection.class, "connectToHost", "exception connecting to {0}", new Object[]{host + ":" + port}, lastSecurityException);
        }
        throw lastSecurityException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connectToSocketAddress(SocketAddress socketAddress, long connectionTime) throws IOException {
        int timeout = SslConnection.computeTimeout(connectionTime);
        Socket socket = this.newSocket();
        boolean ok = false;
        try {
            socket.connect(socketAddress, timeout);
            ok = true;
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (!ok) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private Socket newSocket() throws IOException {
        Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            // empty catch block
        }
        try {
            socket.setKeepAlive(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return socket;
    }

    public String toString() {
        String sessionString = this.session == null ? "" : this.session + ", ";
        return SslConnection.getClassName(this) + "[" + sessionString + (this.sslSocket == null ? "???" : Integer.toString(this.sslSocket.getLocalPort())) + "=>" + this.serverHost + ":" + this.port + "]";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.sslSocket != null) {
            return this.sslSocket.getInputStream();
        }
        throw new IOException("No socket established");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.sslSocket != null) {
            return this.sslSocket.getOutputStream();
        }
        throw new IOException("No socket established");
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public void populateContext(OutboundRequestHandle handle, Collection context) {
        CallContext.coerce(handle, this.callContext.endpoint);
        if (context == null) {
            throw new NullPointerException("Context cannot be null");
        }
    }

    @Override
    public InvocationConstraints getUnfulfilledConstraints(OutboundRequestHandle handle) {
        CallContext callContext = CallContext.coerce(handle, this.callContext.endpoint);
        return callContext.getUnfulfilledConstraints();
    }

    @Override
    public void writeRequestData(OutboundRequestHandle handle, OutputStream stream) {
        CallContext.coerce(handle, this.callContext.endpoint);
        if (stream == null) {
            throw new NullPointerException("Stream cannot be null");
        }
    }

    @Override
    public IOException readResponseData(OutboundRequestHandle handle, InputStream stream) {
        CallContext.coerce(handle, this.callContext.endpoint);
        if (stream == null) {
            throw new NullPointerException("Stream cannot be null");
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            logger.log(Level.FINE, "closing {0}", this);
            this.closed = true;
            this.closeSocket();
        }
    }

    final boolean useFor(CallContext otherCallContext) {
        X500Principal serverPrincipal;
        assert (this.callContext.endpoint.equals(otherCallContext.endpoint));
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "try {0}\nwith {1}\nfor {2}", new Object[]{this, this.callContext, otherCallContext});
        }
        if (this.session == null) {
            logger.log(Level.FINEST, "connection {0} is not established", this);
            return false;
        }
        if (this.checkSessionExpired()) {
            logger.log(Level.FINE, "connection {0} session is expired", this);
            return false;
        }
        if (this.callContext.clientSubject != otherCallContext.clientSubject) {
            logger.log(Level.FINEST, "connection has wrong subject");
            return false;
        }
        X500Principal clientPrincipal = this.authManager.getClientPrincipal();
        if (clientPrincipal == null) {
            if (otherCallContext.clientAuthRequired) {
                logger.log(Level.FINEST, "connection has no client authentication");
                return false;
            }
        } else if (otherCallContext.clientPrincipals != null && !otherCallContext.clientPrincipals.contains(clientPrincipal)) {
            logger.log(Level.FINEST, "connection has wrong client principal");
            return false;
        }
        if ((serverPrincipal = this.authManager.getServerPrincipal()) != null && otherCallContext.serverPrincipals != null && !otherCallContext.serverPrincipals.contains(serverPrincipal)) {
            logger.log(Level.FINEST, "connection has wrong server principal");
            return false;
        }
        String[] requestedSuites = otherCallContext.cipherSuites;
        int requestedPos = SslConnection.position(this.activeCipherSuite, requestedSuites);
        if (requestedPos < 0) {
            logger.log(Level.FINEST, "connection has wrong suite");
            return false;
        }
        String[] connectionSuites = this.callContext.cipherSuites;
        int connectionPos = SslConnection.position(this.activeCipherSuite, connectionSuites);
        assert (connectionPos >= 0) : "Couldn't find connection suite";
        int i = requestedPos;
        while (--i >= 0) {
            String suite = requestedSuites[i];
            int p = SslConnection.position(suite, connectionSuites);
            if (p >= 0 && p < connectionPos) continue;
            logger.log(Level.FINEST, "connection did not try all better suites");
            return false;
        }
        if (clientPrincipal != null) {
            Exception exception;
            try {
                this.authManager.checkAuthentication();
                exception = null;
            }
            catch (SecurityException e) {
                exception = e;
            }
            catch (UnsupportedConstraintException e) {
                exception = e;
            }
            if (exception != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    SslConnection.logThrow(logger, Level.FINEST, SslConnection.class, "useFor", "connection {0} has missing subject credentials", new Object[]{this}, exception);
                }
                return false;
            }
        }
        logger.log(Level.FINEST, "connection OK");
        return true;
    }

    private boolean checkSessionExpired() {
        long create = this.session.getCreationTime();
        long expiration = create + this.maxClientSessionDuration;
        if (expiration < create) {
            expiration = Long.MAX_VALUE;
        }
        if (expiration <= System.currentTimeMillis()) {
            this.session.invalidate();
            return true;
        }
        return false;
    }

    protected String getProxyHost() {
        return "";
    }

    boolean checkConnectPermission() {
        SSLSocket socket = this.sslSocket;
        if (socket == null) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
            if (address.isUnresolved()) {
                sm.checkConnect(address.getHostName(), socket.getPort());
            } else {
                sm.checkConnect(address.getAddress().getHostAddress(), socket.getPort());
            }
        }
        return true;
    }
}

