/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.action.GetPropertyAction;
import com.sun.jini.collection.WeakSoftTable;
import java.lang.ref.ReferenceQueue;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ssl.AuthManager;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ClientAuthManager;
import net.jini.jeri.ssl.ServerAuthManager;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.security.Security;

abstract class Utilities {
    private static final String[] ANONYMOUS_KEY_EXCHANGE_ALGORITHMS = new String[]{"DH_anon", "DH_anon_EXPORT"};
    private static final String[] RSA_KEY_EXCHANGE_ALGORITHMS = new String[]{"DHE_RSA", "DHE_RSA_EXPORT", "DH_RSA", "DH_RSA_EXPORT", "RSA", "RSA_EXPORT"};
    private static final String[] DSA_KEY_EXCHANGE_ALGORITHMS = new String[]{"DHE_DSS", "DHE_DSS_EXPORT", "DH_DSS", "DH_DSS_EXPORT"};
    private static final String[] SUPPORTED_KEY_EXCHANGE_ALGORITHMS = new String[]{"DH_anon", "DH_anon_EXPORT", "DHE_RSA", "DHE_RSA_EXPORT", "DH_RSA", "DH_RSA_EXPORT", "RSA", "RSA_EXPORT", "DHE_DSS", "DHE_DSS_EXPORT", "DH_DSS", "DH_DSS_EXPORT"};
    private static final String NO_INTEGRITY_MIC_ALGORITHM = "NULL";
    private static final String NO_ENCRYPTION_CIPHER_ALGORITHM = "NULL";
    private static final String[] STRONG_ENCRYPTION_CIPHERS = new String[]{"3DES_EDE_CBC", "AES_128_CBC", "AES_256_CBC", "IDEA_CBC", "RC4_128"};
    private static final String[] SUPPORTED_ENCRYPTION_CIPHERS = new String[]{"3DES_EDE_CBC", "AES_128_CBC", "AES_256_CBC", "DES40_CBC", "DES_CBC", "IDEA_CBC", "NULL", "RC2_CBC_40", "RC4_128", "RC4_40"};
    static final Logger clientLogger = Logger.getLogger("net.jini.jeri.ssl.client");
    static final Logger serverLogger = Logger.getLogger("net.jini.jeri.ssl.server");
    static final Logger initLogger = Logger.getLogger("net.jini.jeri.ssl.init");
    static final int ANY_KEY_ALGORITHM = -1;
    static final int DSA_KEY_ALGORITHM = 1;
    static final int RSA_KEY_ALGORITHM = 2;
    private static final WeakSoftTable sslContextMap = new WeakSoftTable();
    private static String[] supportedCipherSuitesInternal = null;
    private static String[] requestedCipherSuites;
    private static CertificateFactory certFactory;
    static final Principal UNKNOWN_PRINCIPAL;
    static final InvocationConstraints INTEGRITY_REQUIRED;
    static final InvocationConstraints INTEGRITY_PREFERRED;
    private static final String sslProtocol;
    static final AuthPermission getSubjectPermission;

    Utilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getSupportedCipherSuites() {
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            if (supportedCipherSuitesInternal == null) {
                SSLContextInfo info = Utilities.getServerSSLContextInfo(null, null);
                SSLSocketFactory factory = info.sslContext.getSocketFactory();
                supportedCipherSuitesInternal = Utilities.getSupportedCipherSuites(factory);
            }
            return supportedCipherSuitesInternal;
        }
    }

    private static String[] getSupportedCipherSuites(SSLSocketFactory factory) {
        String[] suites;
        if (requestedCipherSuites == null) {
            suites = factory.getSupportedCipherSuites();
        } else if (requestedCipherSuites.length == 0) {
            initLogger.log(Level.WARNING, "Problem with requested cipher suites: No suites specified -- using default suites");
            suites = factory.getSupportedCipherSuites();
        } else {
            try {
                SSLSocket socket = (SSLSocket)factory.createSocket();
                socket.setEnabledCipherSuites(requestedCipherSuites);
                suites = requestedCipherSuites;
            }
            catch (Exception e) {
                initLogger.log(Level.WARNING, "Problem with requested cipher suites -- using default suites", e);
                suites = factory.getSupportedCipherSuites();
            }
        }
        return Utilities.getSupportedCipherSuites(suites);
    }

    private static String[] getSupportedCipherSuites(String[] suites) {
        int max = suites.length;
        int i = suites.length;
        while (--i >= 0) {
            if (Utilities.supportedCipherSuite(suites[i])) continue;
            if (i < max - 1) {
                System.arraycopy(suites, i + 1, suites, i, max - i - 1);
            }
            --max;
        }
        if (max == suites.length) {
            return suites;
        }
        String[] copy = new String[max];
        System.arraycopy(suites, 0, copy, 0, max);
        return copy;
    }

    static Set getClientPrincipals(InvocationConstraints constraints) {
        return Utilities.getPrincipals(constraints, true);
    }

    static Set getClientPrincipals(Set constraints) {
        return Utilities.getPrincipals(constraints, true);
    }

    static Set getServerPrincipals(InvocationConstraints constraints) {
        return Utilities.getPrincipals(constraints, false);
    }

    private static Set getPrincipals(InvocationConstraints constraints, boolean client) {
        Set requirements = Utilities.getPrincipals(constraints.requirements(), client);
        Set preferences = Utilities.getPrincipals(constraints.preferences(), client);
        if (requirements == null) {
            return preferences;
        }
        if (preferences == null) {
            return requirements;
        }
        requirements.addAll(preferences);
        return requirements;
    }

    private static Set getPrincipals(Set constraints, boolean client) {
        HashSet result = null;
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Set eltResult = Utilities.getPrincipals((InvocationConstraint)i.next(), client);
            if (eltResult == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(eltResult);
        }
        return result;
    }

    private static Set getPrincipals(InvocationConstraint constraint, boolean client) {
        Set principals;
        if (constraint instanceof ConstraintAlternatives) {
            Set alts = ((ConstraintAlternatives)constraint).elements();
            return Utilities.getPrincipals(alts, client);
        }
        if (constraint instanceof ServerMinPrincipal) {
            if (client) {
                return null;
            }
            principals = ((ServerMinPrincipal)constraint).elements();
        } else {
            if (!client) {
                return null;
            }
            if (constraint instanceof ClientMinPrincipal) {
                principals = ((ClientMinPrincipal)constraint).elements();
            } else if (constraint instanceof ClientMaxPrincipal) {
                principals = ((ClientMaxPrincipal)constraint).elements();
            } else {
                return null;
            }
        }
        HashSet result = new HashSet(principals.size());
        for (Object elt : principals) {
            if (!(elt instanceof X500Principal)) continue;
            result.add(elt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContextInfo getClientSSLContextInfo(CallContext callContext) {
        ClientAuthManager authManager;
        SSLContext sslContext;
        ClientKey key = new ClientKey(callContext);
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            Value value;
            int i = 0;
            while ((value = (Value)sslContextMap.get(key, i)) != null) {
                block16: {
                    SSLContext sslContext2 = value.getSSLContext();
                    if (sslContext2 != null) {
                        ClientAuthManager authManager2 = (ClientAuthManager)value.authManager;
                        try {
                            authManager2.checkAuthentication();
                        }
                        catch (SecurityException e) {
                            break block16;
                        }
                        catch (UnsupportedConstraintException e) {
                            break block16;
                        }
                        sslContextMap.remove(key, i);
                        if (clientLogger.isLoggable(Level.FINEST)) {
                            clientLogger.log(Level.FINEST, "get client SSL context for {0}\nreturns existing {1}", new Object[]{callContext, sslContext2});
                        }
                        return new SSLContextInfo(sslContext2, authManager2);
                    }
                }
                ++i;
            }
        }
        try {
            sslContext = SSLContext.getInstance(sslProtocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw Utilities.initializationError(e, "finding SSL context");
        }
        try {
            authManager = new ClientAuthManager(callContext.clientSubject, callContext.clientPrincipals, callContext.serverPrincipals);
        }
        catch (NoSuchAlgorithmException e) {
            throw Utilities.initializationError(e, "creating key or trust manager");
        }
        try {
            sslContext.init(new KeyManager[]{authManager}, new TrustManager[]{authManager}, null);
        }
        catch (KeyManagementException e) {
            throw Utilities.initializationError(e, "initializing SSL context");
        }
        if (clientLogger.isLoggable(Level.FINEST)) {
            clientLogger.log(Level.FINEST, "get client SSL context for {0}\nreturns new {1}", new Object[]{callContext, sslContext});
        }
        return new SSLContextInfo(sslContext, authManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SSLContextInfo getServerSSLContextInfo(Subject serverSubject, Set serverPrincipals) {
        ServerKey key = new ServerKey(serverSubject, serverPrincipals);
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            ServerAuthManager authManager;
            SSLContext sslContext;
            Value value = (Value)sslContextMap.get(key, 0);
            if (value != null && (sslContext = value.getSSLContext()) != null) {
                if (serverLogger.isLoggable(Level.FINEST)) {
                    serverLogger.log(Level.FINEST, "get server SSL context for {0}\nand principals {1}\nreturns existing {2}", new Object[]{Utilities.subjectString(serverSubject), serverPrincipals, sslContext});
                }
                return new SSLContextInfo(sslContext, value.authManager);
            }
            try {
                sslContext = SSLContext.getInstance(sslProtocol);
            }
            catch (NoSuchAlgorithmException e) {
                throw Utilities.initializationError(e, "finding SSL context");
            }
            try {
                authManager = new ServerAuthManager(serverSubject, serverPrincipals, sslContext.getServerSessionContext());
            }
            catch (NoSuchAlgorithmException e) {
                throw Utilities.initializationError(e, "creating key or trust manager");
            }
            try {
                sslContext.init(new KeyManager[]{authManager}, new TrustManager[]{authManager}, null);
            }
            catch (KeyManagementException e) {
                throw Utilities.initializationError(e, "initializing SSL context");
            }
            sslContextMap.add(key, new Value(key, sslContext, authManager));
            if (serverLogger.isLoggable(Level.FINEST)) {
                serverLogger.log(Level.FINEST, "get server SSL context for {0}\nand principals {1}\nreturns new {2}", new Object[]{Utilities.subjectString(serverSubject), serverPrincipals, sslContext});
            }
            return new SSLContextInfo(sslContext, authManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseClientSSLContextInfo(CallContext callContext, SSLContext sslContext, ClientAuthManager authManager) {
        ClientKey key = new ClientKey(callContext);
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            sslContextMap.add(key, new Value(key, sslContext, authManager));
        }
    }

    private static RuntimeException initializationError(Exception error, String contextString) {
        RuntimeException e = new RuntimeException("Error during initialization of SSL or HTTPS provider, while " + contextString + ": " + error.getMessage(), error);
        initLogger.log(Level.WARNING, "Initialization error", e);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CertificateFactory getCertFactory() {
        WeakSoftTable weakSoftTable = sslContextMap;
        synchronized (weakSoftTable) {
            if (certFactory == null) {
                try {
                    certFactory = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException e) {
                    throw Utilities.initializationError(e, "getting certificate factory");
                }
            }
            return certFactory;
        }
    }

    static X509Certificate firstX509Cert(CertPath certPath) {
        return (X509Certificate)certPath.getCertificates().get(0);
    }

    static void checkValidity(CertPath x509CertPath, X500Principal[] issuers) throws CertificateException {
        boolean issuerOK = issuers == null;
        List<? extends Certificate> certs = x509CertPath.getCertificates();
        int i = certs.size();
        block0: while (--i >= 0) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            cert.checkValidity();
            if (issuerOK) continue;
            X500Principal certIssuer = cert.getIssuerX500Principal();
            int j = issuers.length;
            while (--j >= 0) {
                if (!certIssuer.equals(issuers[j])) continue;
                issuerOK = true;
                continue block0;
            }
        }
        if (!issuerOK) {
            throw new CertificateException("No match for permitted issuers: " + Utilities.toString(issuers) + "\nCertificate chain: " + x509CertPath);
        }
    }

    static boolean doesServerAuthentication(String cipherSuite) {
        String alg = Utilities.getKeyExchangeAlgorithm(cipherSuite);
        return Utilities.position(alg, ANONYMOUS_KEY_EXCHANGE_ALGORITHMS) == -1;
    }

    static boolean doesEncryption(String cipherSuite) {
        return !Utilities.getCipherAlgorithm(cipherSuite).equals("NULL");
    }

    static boolean maintainsIntegrity(String cipherSuite) {
        return !Utilities.getMICAlgorithm(cipherSuite).equals("NULL");
    }

    static String getKeyExchangeAlgorithm(String cipherSuite) {
        int end;
        int start = cipherSuite.indexOf(95) + 1;
        if (start >= 1 && (end = cipherSuite.indexOf("_WITH_", start)) >= start) {
            return cipherSuite.substring(start, end);
        }
        return "NULL";
    }

    static String getKeyAlgorithm(String cipherSuite) {
        String alg = Utilities.getKeyExchangeAlgorithm(cipherSuite);
        if (Utilities.position(alg, RSA_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "RSA";
        }
        if (Utilities.position(alg, DSA_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "DSA";
        }
        if (Utilities.position(alg, ANONYMOUS_KEY_EXCHANGE_ALGORITHMS) != -1) {
            return "NULL";
        }
        throw new IllegalArgumentException("Unrecognized key exchange algorithm: " + alg);
    }

    static int getPermittedKeyAlgorithms(String cipherSuite, boolean client) {
        String keyAlgorithm = Utilities.getKeyAlgorithm(cipherSuite);
        if (keyAlgorithm.equals("RSA")) {
            return client ? 3 : 2;
        }
        if (keyAlgorithm.equals("DSA")) {
            return client ? 3 : 1;
        }
        if (keyAlgorithm.equals("NULL")) {
            return 0;
        }
        throw new AssertionError((Object)("Unrecognized key algorithm: " + keyAlgorithm));
    }

    static boolean permittedKeyAlgorithm(String keyAlgorithm, int permittedKeyAlgorithms) {
        if (permittedKeyAlgorithms == -1) {
            return true;
        }
        if ("DSA".equals(keyAlgorithm)) {
            return (permittedKeyAlgorithms & 1) != 0;
        }
        if ("RSA".equals(keyAlgorithm)) {
            return (permittedKeyAlgorithms & 2) != 0;
        }
        return false;
    }

    static String getCipherAlgorithm(String cipherSuite) {
        int end;
        int start = cipherSuite.indexOf("_WITH_") + 6;
        if (start >= 6 && (end = cipherSuite.lastIndexOf(95)) >= start) {
            return cipherSuite.substring(start, end);
        }
        return "NULL";
    }

    static boolean hasStrongCipherAlgorithm(String cipherSuite) {
        String cipher = Utilities.getCipherAlgorithm(cipherSuite);
        return Utilities.position(cipher, STRONG_ENCRYPTION_CIPHERS) != -1;
    }

    private static String getMICAlgorithm(String cipherSuite) {
        return cipherSuite.substring(cipherSuite.lastIndexOf(95));
    }

    private static boolean supportedCipherSuite(String cipherSuite) {
        return Utilities.position(Utilities.getKeyExchangeAlgorithm(cipherSuite), SUPPORTED_KEY_EXCHANGE_ALGORITHMS) != -1 && Utilities.position(Utilities.getCipherAlgorithm(cipherSuite), SUPPORTED_ENCRYPTION_CIPHERS) != -1;
    }

    static String subjectString(Subject subject) {
        if (subject == null) {
            return "null subject";
        }
        return "Subject@" + Integer.toHexString(System.identityHashCode(subject)) + "{\n" + SubjectCredentials.credentialsString(subject) + "}";
    }

    static boolean safeEquals(Object x, Object y) {
        return x == null ? y == null : x.equals(y);
    }

    static boolean contains(Object[] array, Object element) {
        int i = array.length;
        while (--i >= 0) {
            if (!Utilities.safeEquals(array[i], element)) continue;
            return true;
        }
        return false;
    }

    static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(array[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    static boolean equals(Object[] x, Object[] y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        int i = x.length;
        while (--i >= 0) {
            if (Utilities.safeEquals(x[i], y[i])) continue;
            return false;
        }
        return true;
    }

    static String getClassName(Object object) {
        String className = object.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        className = className.substring(className.lastIndexOf(36) + 1);
        return className;
    }

    static int position(String string, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!string.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    static void logThrow(Logger logger, Level level, Class sourceClass, String sourceMethod, String msg, Object[] params, Throwable e) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(sourceClass.getName());
        r.setSourceMethodName(sourceMethod);
        r.setParameters(params);
        r.setThrown(e);
        logger.log(r);
    }

    static {
        String value = Security.doPrivileged(new GetPropertyAction("com.sun.jini.jeri.ssl.cipherSuites"));
        if (value == null) {
            requestedCipherSuites = null;
        } else {
            StringTokenizer tokens = new StringTokenizer(value, ",");
            int count = tokens.countTokens();
            requestedCipherSuites = new String[count];
            for (int i = 0; i < count; ++i) {
                Utilities.requestedCipherSuites[i] = tokens.nextToken();
            }
        }
        UNKNOWN_PRINCIPAL = new Principal(){

            @Override
            public String toString() {
                return "UNKNOWN_PRINCIPAL";
            }

            @Override
            public String getName() {
                return this.toString();
            }
        };
        INTEGRITY_REQUIRED = new InvocationConstraints(Integrity.YES, null);
        INTEGRITY_PREFERRED = new InvocationConstraints(null, Integrity.YES);
        sslProtocol = Security.doPrivileged(new GetPropertyAction("com.sun.jini.jeri.ssl.sslProtocol", "TLS"));
        getSubjectPermission = new AuthPermission("getSubject");
    }

    private static final class Value
    extends WeakSoftTable.SoftValue {
        final AuthManager authManager;

        Value(ServerKey key, SSLContext sslContext, AuthManager authManager) {
            super(key, sslContext);
            this.authManager = authManager;
        }

        private Value(Value value, ReferenceQueue queue) {
            super(value, queue);
            this.authManager = value.authManager;
        }

        @Override
        public WeakSoftTable.RemovableReference copy(ReferenceQueue queue) {
            return new Value(this, queue);
        }

        SSLContext getSSLContext() {
            return (SSLContext)this.get();
        }
    }

    private static final class ClientKey
    extends ServerKey {
        final Set permittedRemotePrincipals;
        final Endpoint endpoint;
        final boolean clientAuthRequired;
        final String[] cipherSuites;

        ClientKey(CallContext callContext) {
            super(callContext.clientSubject, callContext.clientPrincipals);
            this.permittedRemotePrincipals = callContext.serverPrincipals;
            this.endpoint = callContext.endpoint;
            this.clientAuthRequired = callContext.clientAuthRequired;
            this.cipherSuites = callContext.cipherSuites;
            assert (this.cipherSuites != null && this.cipherSuites.length > 0 && this.cipherSuites[0] != null);
        }

        private ClientKey(ClientKey clientKey, ReferenceQueue queue) {
            super(clientKey, queue);
            this.permittedRemotePrincipals = clientKey.permittedRemotePrincipals;
            this.endpoint = clientKey.endpoint;
            this.clientAuthRequired = clientKey.clientAuthRequired;
            this.cipherSuites = clientKey.cipherSuites;
        }

        @Override
        public WeakSoftTable.RemovableReference copy(ReferenceQueue queue) {
            return new ClientKey(this, queue);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.permittedRemotePrincipals == null ? 2 : this.permittedRemotePrincipals.hashCode()) ^ this.endpoint.hashCode() ^ (this.clientAuthRequired ? 4 : 0) ^ this.cipherSuites[0].hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (!super.equals(other)) {
                return false;
            }
            ClientKey clientKey = (ClientKey)other;
            return Utilities.safeEquals(this.permittedRemotePrincipals, clientKey.permittedRemotePrincipals) && this.endpoint.equals(clientKey.endpoint) && this.clientAuthRequired == clientKey.clientAuthRequired && Arrays.equals(this.cipherSuites, clientKey.cipherSuites);
        }
    }

    private static class ServerKey
    extends WeakSoftTable.WeakKey {
        final Set permittedLocalPrincipals;

        ServerKey(Subject subject, Set permittedLocalPrincipals) {
            super(subject);
            this.permittedLocalPrincipals = permittedLocalPrincipals;
        }

        ServerKey(ServerKey serverKey, ReferenceQueue queue) {
            super(serverKey, queue);
            this.permittedLocalPrincipals = serverKey.permittedLocalPrincipals;
        }

        @Override
        public WeakSoftTable.RemovableReference copy(ReferenceQueue queue) {
            return new ServerKey(this, queue);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ (this.permittedLocalPrincipals == null ? 1 : this.permittedLocalPrincipals.hashCode());
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && Utilities.safeEquals(this.permittedLocalPrincipals, ((ServerKey)other).permittedLocalPrincipals);
        }
    }

    static class SSLContextInfo {
        final SSLContext sslContext;
        final AuthManager authManager;

        SSLContextInfo(SSLContext sslContext, AuthManager authManager) {
            this.sslContext = sslContext;
            this.authManager = authManager;
        }
    }
}

