/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.RelativeTimeConstraint;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;

class Constraints {
    private static final int NO_SUPPORT = 0;
    private static final int FULL_SUPPORT = 1;
    private static final int PARTIAL_SUPPORT = 2;
    private static final Map supportedValues = new HashMap();
    private static final Map supportedClasses;

    private static int getSupport(InvocationConstraint c) {
        Boolean support = (Boolean)supportedValues.get(c);
        if (support == null) {
            support = (Boolean)supportedClasses.get(c.getClass());
        }
        return support == null ? 0 : (support != false ? 2 : 1);
    }

    static InvocationConstraints check(InvocationConstraints constraints, boolean relativeOK) throws UnsupportedConstraintException {
        return Constraints.distill(constraints, relativeOK).getUnfulfilledConstraints();
    }

    static Distilled distill(InvocationConstraints constraints, boolean relativeOK) throws UnsupportedConstraintException {
        return new Distilled(constraints, relativeOK);
    }

    private Constraints() {
        throw new AssertionError();
    }

    static {
        supportedValues.put(Integrity.NO, Boolean.TRUE);
        supportedValues.put(Confidentiality.NO, Boolean.FALSE);
        supportedValues.put(ClientAuthentication.NO, Boolean.FALSE);
        supportedValues.put(ServerAuthentication.NO, Boolean.FALSE);
        supportedValues.put(Delegation.NO, Boolean.FALSE);
        supportedClasses = new HashMap();
        supportedClasses.put(ConnectionAbsoluteTime.class, Boolean.FALSE);
        supportedClasses.put(ConnectionRelativeTime.class, Boolean.FALSE);
        supportedClasses.put(ClientMaxPrincipal.class, Boolean.FALSE);
        supportedClasses.put(ClientMaxPrincipalType.class, Boolean.FALSE);
        supportedClasses.put(ClientMinPrincipal.class, Boolean.FALSE);
        supportedClasses.put(ClientMinPrincipalType.class, Boolean.FALSE);
        supportedClasses.put(ServerMinPrincipal.class, Boolean.FALSE);
        supportedClasses.put(DelegationAbsoluteTime.class, Boolean.FALSE);
        supportedClasses.put(DelegationRelativeTime.class, Boolean.FALSE);
    }

    static class Distilled {
        private final boolean relativeOK;
        private Collection unfulfilledRequirements = null;
        private Collection unfulfilledPreferences = null;
        private boolean hasConnectDeadline = false;
        private long connectDeadline;

        Distilled(InvocationConstraints constraints, boolean relativeOK) throws UnsupportedConstraintException {
            this.relativeOK = relativeOK;
            Iterator i = constraints.requirements().iterator();
            while (i.hasNext()) {
                this.addConstraint((InvocationConstraint)i.next(), true);
            }
            i = constraints.preferences().iterator();
            while (i.hasNext()) {
                this.addConstraint((InvocationConstraint)i.next(), false);
            }
        }

        InvocationConstraints getUnfulfilledConstraints() {
            if (this.unfulfilledRequirements == null && this.unfulfilledPreferences == null) {
                return InvocationConstraints.EMPTY;
            }
            return new InvocationConstraints(this.unfulfilledRequirements, this.unfulfilledPreferences);
        }

        boolean hasConnectDeadline() {
            return this.hasConnectDeadline;
        }

        long getConnectDeadline() {
            assert (this.hasConnectDeadline);
            return this.connectDeadline;
        }

        private void addConstraint(InvocationConstraint constraint, boolean isRequirement) throws UnsupportedConstraintException {
            if (!(constraint instanceof ConstraintAlternatives)) {
                int support = Constraints.getSupport(constraint);
                if (support == 0 || !this.relativeOK && constraint instanceof RelativeTimeConstraint) {
                    if (isRequirement) {
                        throw new UnsupportedConstraintException("cannot satisfy constraint: " + constraint);
                    }
                    return;
                }
                if (support == 2) {
                    if (isRequirement) {
                        if (this.unfulfilledRequirements == null) {
                            this.unfulfilledRequirements = new ArrayList();
                        }
                        this.unfulfilledRequirements.add(constraint);
                    } else {
                        if (this.unfulfilledPreferences == null) {
                            this.unfulfilledPreferences = new ArrayList();
                        }
                        this.unfulfilledPreferences.add(constraint);
                    }
                }
                if (constraint instanceof ConnectionAbsoluteTime) {
                    this.addConnectDeadline(((ConnectionAbsoluteTime)constraint).getTime());
                }
            } else {
                this.addAlternatives((ConstraintAlternatives)constraint, isRequirement);
            }
        }

        private void addAlternatives(ConstraintAlternatives constraint, boolean isRequirement) throws UnsupportedConstraintException {
            Set alts = constraint.elements();
            boolean supported = false;
            long maxConnectDeadline = Long.MIN_VALUE;
            ArrayList<InvocationConstraint> unfulfilledAlts = null;
            boolean forgetUnfulfilled = false;
            for (InvocationConstraint c : alts) {
                int support = Constraints.getSupport(c);
                if (support == 0 || !this.relativeOK && c instanceof RelativeTimeConstraint) continue;
                supported = true;
                if (!forgetUnfulfilled) {
                    if (support == 2) {
                        if (unfulfilledAlts == null) {
                            unfulfilledAlts = new ArrayList<InvocationConstraint>();
                        }
                        unfulfilledAlts.add(c);
                    } else {
                        assert (support == 1);
                        unfulfilledAlts = null;
                        forgetUnfulfilled = true;
                    }
                }
                if (c instanceof ConnectionAbsoluteTime) {
                    assert (support == 1);
                    maxConnectDeadline = Math.max(maxConnectDeadline, ((ConnectionAbsoluteTime)c).getTime());
                    continue;
                }
                maxConnectDeadline = Long.MAX_VALUE;
            }
            if (!supported) {
                if (isRequirement) {
                    throw new UnsupportedConstraintException("cannot satisfy constraint: " + constraint);
                }
                return;
            }
            if (!forgetUnfulfilled && unfulfilledAlts != null) {
                if (isRequirement) {
                    if (this.unfulfilledRequirements == null) {
                        this.unfulfilledRequirements = new ArrayList();
                    }
                    this.unfulfilledRequirements.add(ConstraintAlternatives.create(unfulfilledAlts));
                } else {
                    if (this.unfulfilledPreferences == null) {
                        this.unfulfilledPreferences = new ArrayList();
                    }
                    this.unfulfilledPreferences.add(ConstraintAlternatives.create(unfulfilledAlts));
                }
            }
            if (maxConnectDeadline < Long.MAX_VALUE) {
                assert (maxConnectDeadline != Long.MIN_VALUE);
                this.addConnectDeadline(maxConnectDeadline);
            }
        }

        private void addConnectDeadline(long deadline) {
            if (!this.hasConnectDeadline) {
                this.hasConnectDeadline = true;
                this.connectDeadline = deadline;
            } else {
                this.connectDeadline = Math.min(this.connectDeadline, deadline);
            }
        }
    }
}

