/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.logging.LogUtil;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.connection.ServerConnectionManager;
import net.jini.jeri.tcp.Constraints;
import net.jini.jeri.tcp.TcpEndpoint;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import org.apache.river.config.LocalHostLookup;

public final class TcpServerEndpoint
implements ServerEndpoint {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final ServerConnectionManager serverConnectionManager = new ServerConnectionManager();
    private static final Logger logger = Logger.getLogger("net.jini.jeri.tcp.server");
    private static final boolean useNIO = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.jini.jeri.tcp.useNIO"));
    private final String host;
    private final int port;
    private final SocketFactory sf;
    private final ServerSocketFactory ssf;

    public static TcpServerEndpoint getInstance(int port) {
        return TcpServerEndpoint.getInstance(null, port, null, null);
    }

    public static TcpServerEndpoint getInstance(String host, int port) {
        return TcpServerEndpoint.getInstance(host, port, null, null);
    }

    public static TcpServerEndpoint getInstance(String host, int port, SocketFactory sf, ServerSocketFactory ssf) {
        return new TcpServerEndpoint(host, port, sf, ssf);
    }

    private TcpServerEndpoint(String host, int port, SocketFactory sf, ServerSocketFactory ssf) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number out of range: " + port);
        }
        this.host = host;
        this.port = port;
        this.sf = sf;
        this.ssf = ssf;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public SocketFactory getSocketFactory() {
        return this.sf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    @Override
    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        return Constraints.check(constraints, true);
    }

    @Override
    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        LE listenEndpoint;
        ServerEndpoint.ListenCookie listenCookie;
        if (listenContext == null) {
            throw new NullPointerException();
        }
        String localHost = this.host;
        if (localHost == null) {
            InetAddress localAddr;
            try {
                localAddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return LocalHostLookup.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                LocalHostLookup.getLocalHost();
                throw new UnknownHostException("access to resolve local host denied");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkConnect(localAddr.getHostName(), -1);
                }
                catch (SecurityException e) {
                    throw new SecurityException("access to resolve local host denied");
                }
            }
            localHost = localAddr.getHostAddress();
        }
        if (!((listenCookie = listenContext.addListenEndpoint(listenEndpoint = new LE())) instanceof LE.Cookie)) {
            throw new IllegalArgumentException();
        }
        LE.Cookie cookie = (LE.Cookie)listenCookie;
        if (!listenEndpoint.equals(cookie.getLE())) {
            throw new IllegalArgumentException();
        }
        return TcpEndpoint.getInstance(localHost, cookie.getPort(), this.sf);
    }

    public int hashCode() {
        return this.port ^ (this.host != null ? this.host.hashCode() : 0) ^ (this.sf != null ? this.sf.hashCode() : 0) ^ (this.ssf != null ? this.ssf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TcpServerEndpoint)) {
            return false;
        }
        TcpServerEndpoint other = (TcpServerEndpoint)obj;
        return Util.equals(this.host, other.host) && this.port == other.port && Util.sameClassAndEquals(this.sf, other.sf) && Util.sameClassAndEquals(this.ssf, other.ssf);
    }

    public String toString() {
        return "TcpServerEndpoint[" + (this.host != null ? this.host + ":" : "") + this.port + (this.ssf != null ? "," + this.ssf : "") + (this.sf != null ? "," + this.sf : "") + "]";
    }

    private static void setSocketOptions(Socket socket) {
        block5: {
            block4: {
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    LogUtil.logThrow(logger, Levels.HANDLED, TcpServerEndpoint.class, "setSocketOptions", "exception setting TCP_NODELAY on socket {0}", new Object[]{socket}, e);
                }
            }
            try {
                socket.setKeepAlive(true);
            }
            catch (SocketException e) {
                if (!logger.isLoggable(Levels.HANDLED)) break block5;
                LogUtil.logThrow(logger, Levels.HANDLED, TcpServerEndpoint.class, "setSocketOptions", "exception setting SO_KEEPALIVE on socket {0}", new Object[]{socket}, e);
            }
        }
    }

    private static class LH
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher requestDispatcher;
        private final ServerSocket serverSocket;
        private final SecurityContext securityContext;
        private final ServerEndpoint.ListenCookie cookie;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;
        private final Object lock = new Object();
        private boolean closed = false;
        private final Set connections = new HashSet();

        LH(RequestDispatcher requestDispatcher, ServerSocket serverSocket, SecurityContext securityContext, ServerEndpoint.ListenCookie cookie) {
            this.requestDispatcher = requestDispatcher;
            this.serverSocket = serverSocket;
            this.securityContext = securityContext;
            this.cookie = cookie;
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LH.this.executeAcceptLoop();
                    }
                    finally {
                        try {
                            LH.this.serverSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, this.toString() + " accept loop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAcceptLoop() {
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "accepted socket {0} from server socket {1}", new Object[]{socket, this.serverSocket});
                    }
                    TcpServerEndpoint.setSocketOptions(socket);
                    final ServerConnectionImpl serverConnection = new ServerConnectionImpl(socket);
                    AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

                        public Object run() {
                            serverConnectionManager.handleConnection(serverConnection, LH.this.requestDispatcher);
                            return null;
                        }
                    }), this.securityContext.getAccessControlContext());
                    continue;
                }
                catch (Throwable t) {
                    try {
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.closed) {
                                return;
                            }
                        }
                        try {
                            if (logger.isLoggable(Level.WARNING)) {
                                LogUtil.logThrow(logger, Level.WARNING, TcpServerEndpoint.class, "executeAcceptLoop", "accept loop for {0} throws", new Object[]{this.serverSocket}, t);
                            }
                        }
                        catch (Throwable tt) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!(t instanceof SecurityException)) {
                        // empty if block
                    }
                    boolean knownFailure = t instanceof Exception || t instanceof OutOfMemoryError || t instanceof NoClassDefFoundError;
                    if (!knownFailure) throw (Error)t;
                    if (!this.continueAfterAcceptFailure(t)) return;
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "closed server socket {0}", this.serverSocket);
            }
            Iterator i = this.connections.iterator();
            while (i.hasNext()) {
                ((ServerConnectionImpl)i.next()).close();
            }
        }

        @Override
        public ServerEndpoint.ListenCookie getCookie() {
            return this.cookie;
        }

        public String toString() {
            return "TcpServerEndpoint.LH[" + this.serverSocket + "]";
        }

        private boolean continueAfterAcceptFailure(Throwable t) {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            return true;
        }

        private class ServerConnectionImpl
        implements ServerConnection {
            private final Socket socket;
            private final InetAddress socketInetAddress;
            private final int socketPort;

            ServerConnectionImpl(Socket socket) {
                this.socket = socket;
                this.socketInetAddress = socket.getInetAddress();
                this.socketPort = socket.getPort();
                this.addToConnectionSet();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return this.socket.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return this.socket.getOutputStream();
            }

            @Override
            public SocketChannel getChannel() {
                return this.socket.getChannel();
            }

            @Override
            public InboundRequestHandle processRequestData(InputStream in, OutputStream out) {
                return new InboundRequestHandle(){};
            }

            @Override
            public void checkPermissions(InboundRequestHandle handle) {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkAccept(this.socketInetAddress.getHostAddress(), this.socketPort);
                }
            }

            @Override
            public InvocationConstraints checkConstraints(InboundRequestHandle handle, InvocationConstraints constraints) throws UnsupportedConstraintException {
                return Constraints.check(constraints, true);
            }

            @Override
            public void populateContext(InboundRequestHandle handle, Collection context) {
                Util.populateContext(context, this.socketInetAddress);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "closed socket {0}", this.socket);
                }
                Object object = LH.this.lock;
                synchronized (object) {
                    if (!LH.this.closed) {
                        LH.this.connections.remove(this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addToConnectionSet() {
                boolean needClose = false;
                Object object = LH.this.lock;
                synchronized (object) {
                    if (LH.this.closed) {
                        needClose = true;
                    } else {
                        LH.this.connections.add(this);
                    }
                }
                if (needClose) {
                    this.close();
                }
            }
        }
    }

    private class LE
    implements ServerEndpoint.ListenEndpoint {
        LE() {
        }

        @Override
        public void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkListen(TcpServerEndpoint.this.port);
            }
        }

        @Override
        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            ServerSocket serverSocket;
            if (requestDispatcher == null) {
                throw new NullPointerException();
            }
            if (TcpServerEndpoint.this.ssf != null) {
                serverSocket = TcpServerEndpoint.this.ssf.createServerSocket(TcpServerEndpoint.this.port);
            } else if (useNIO) {
                serverSocket = ServerSocketChannel.open().socket();
                serverSocket.bind(new InetSocketAddress(TcpServerEndpoint.this.port));
            } else {
                serverSocket = new ServerSocket(TcpServerEndpoint.this.port);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, TcpServerEndpoint.this.ssf == null ? "created server socket {0}" : "created server socket {0} using factory {1}", new Object[]{serverSocket, TcpServerEndpoint.this.ssf});
            }
            Cookie cookie = new Cookie(serverSocket.getLocalPort());
            LH listenHandle = new LH(requestDispatcher, serverSocket, Security.getContext(), cookie);
            listenHandle.startAccepting();
            return listenHandle;
        }

        private int getPort() {
            return TcpServerEndpoint.this.port;
        }

        private ServerSocketFactory getSSF() {
            return TcpServerEndpoint.this.ssf;
        }

        public int hashCode() {
            return TcpServerEndpoint.this.port ^ (TcpServerEndpoint.this.ssf != null ? TcpServerEndpoint.this.ssf.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LE)) {
                return false;
            }
            LE other = (LE)obj;
            return TcpServerEndpoint.this.port == other.getPort() && Util.sameClassAndEquals(TcpServerEndpoint.this.ssf, other.getSSF());
        }

        public String toString() {
            return "TcpServerEndpoint.LE[" + TcpServerEndpoint.this.port + (TcpServerEndpoint.this.ssf != null ? "," + TcpServerEndpoint.this.ssf : "") + "]";
        }

        private class Cookie
        implements ServerEndpoint.ListenCookie {
            private final int port;

            Cookie(int port) {
                this.port = port;
            }

            LE getLE() {
                return LE.this;
            }

            int getPort() {
                return this.port;
            }

            public String toString() {
                return "TcpServerEndpoint.LE.Cookie[" + this.port + "]";
            }
        }
    }
}

