/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.policy;

import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.GrantPermission;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;
import org.apache.river.api.security.AbstractPolicy;
import org.apache.river.api.security.CachingSecurityManager;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.PermissionGrantBuilder;
import org.apache.river.api.security.RemotePolicy;
import org.apache.river.api.security.RevocablePolicy;
import org.apache.river.api.security.ScalableNestedPolicy;

public class DynamicPolicyProvider
extends AbstractPolicy
implements RevocablePolicy,
ScalableNestedPolicy {
    private static final String basePolicyClassProperty = "net.jini.security.policy.DynamicPolicyProvider.basePolicyClass";
    private static final String defaultBasePolicyClass = "org.apache.river.api.security.ConcurrentPolicyFile";
    private static final String revocationSupported = "net.jini.security.policy.DynamicPolicyProvider.revocation";
    private static final Logger logger = Logger.getLogger("net.jini.security.policy");
    private static final ProtectionDomain policyDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return DynamicPolicyProvider.class.getProtectionDomain();
        }
    });
    private final Policy basePolicy;
    private final Collection<PermissionGrant> dynamicPolicyGrants;
    private final boolean basePolicyIsDynamic;
    private final boolean revokeable;
    private final boolean basePolicyIsRemote;
    private final boolean loggable;
    private final PermissionCollection policyPermissions;

    public DynamicPolicyProvider() throws PolicyInitializationException {
        String cname = Security.getProperty(basePolicyClassProperty);
        if (cname == null) {
            cname = defaultBasePolicyClass;
        }
        String tRue = "TRUE";
        String revoke = Security.getProperty(revocationSupported);
        if (revoke == null) {
            revoke = tRue;
        }
        try {
            this.basePolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct base policy", e);
        }
        this.dynamicPolicyGrants = Collections.newSetFromMap(new ConcurrentHashMap(64));
        this.loggable = logger.isLoggable(Level.FINEST);
        if (this.basePolicy instanceof DynamicPolicy) {
            DynamicPolicy dp = (DynamicPolicy)((Object)this.basePolicy);
            this.basePolicyIsDynamic = dp.grantSupported();
            if (this.basePolicy instanceof RevocablePolicy) {
                RevocablePolicy rp = (RevocablePolicy)((Object)this.basePolicy);
                this.revokeable = rp.revokeSupported();
            } else {
                this.revokeable = false;
            }
        } else {
            this.basePolicyIsDynamic = false;
            this.revokeable = revoke.equals(tRue);
        }
        this.basePolicyIsRemote = this.basePolicy instanceof RemotePolicy;
        this.policyPermissions = this.basePolicy.getPermissions(policyDomain);
        this.policyPermissions.setReadOnly();
    }

    public DynamicPolicyProvider(Policy basePolicy) {
        if (basePolicy == null) {
            throw new NullPointerException("null basePolicy prohibited");
        }
        this.basePolicy = basePolicy;
        this.dynamicPolicyGrants = Collections.newSetFromMap(new ConcurrentHashMap(64));
        this.loggable = logger.isLoggable(Level.FINEST);
        if (basePolicy instanceof DynamicPolicy) {
            DynamicPolicy dp = (DynamicPolicy)((Object)basePolicy);
            this.basePolicyIsDynamic = dp.grantSupported();
            if (basePolicy instanceof RevocablePolicy) {
                RevocablePolicy rp = (RevocablePolicy)((Object)basePolicy);
                this.revokeable = rp.revokeSupported();
            } else {
                this.revokeable = false;
            }
        } else {
            this.basePolicyIsDynamic = false;
            this.revokeable = true;
        }
        this.basePolicyIsRemote = basePolicy instanceof RemotePolicy;
        this.policyPermissions = basePolicy.getPermissions(policyDomain);
        this.policyPermissions.setReadOnly();
    }

    @Override
    public boolean revokeSupported() {
        return this.revokeable;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return this.basePolicy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Collection<PermissionGrant> pgc = this.getPermissionGrants(domain);
        TreeSet<Permission> permissions = new TreeSet<Permission>(this.comparator);
        this.processGrants(pgc, null, true, permissions);
        PermissionCollection pc = this.convert(permissions, 32, 0.75f, 1, 8);
        this.expandUmbrella(pc);
        return pc;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        Class<?> permClass;
        if (domain == policyDomain) {
            return this.policyPermissions.implies(permission);
        }
        if ((this.basePolicyIsDynamic || this.basePolicyIsRemote) && this.basePolicy.implies(domain, permission)) {
            return true;
        }
        if (permission == null) {
            throw new NullPointerException("permission not allowed to be null");
        }
        TreeSet<Permission> permissions = new TreeSet<Permission>(this.comparator);
        Class<?> clazz = permClass = permission instanceof GrantPermission ? null : permission.getClass();
        if (!(this.basePolicy instanceof ScalableNestedPolicy)) {
            PermissionCollection pc = this.basePolicy.getPermissions(domain);
            Enumeration<Permission> enu = pc.elements();
            while (enu.hasMoreElements()) {
                Permission p = enu.nextElement();
                if (p instanceof AllPermission) {
                    return true;
                }
                if (permClass == null) {
                    permissions.add(p);
                    continue;
                }
                if (!permClass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                permissions.add(p);
            }
        } else {
            Collection<PermissionGrant> grants = ((ScalableNestedPolicy)((Object)this.basePolicy)).getPermissionGrants(domain);
            this.processGrants(grants, permClass, true, permissions);
            if (permissions.contains(this.ALL_PERMISSION)) {
                return true;
            }
        }
        for (PermissionGrant g : this.dynamicPolicyGrants) {
            if (!g.implies(domain)) continue;
            Collection<Permission> perms = g.getPermissions();
            for (Permission p : perms) {
                if (permClass == null) {
                    permissions.add(p);
                    continue;
                }
                if (!permClass.isInstance(permission) && !(permission instanceof UnresolvedPermission)) continue;
                permissions.add(p);
            }
        }
        PermissionCollection pc = null;
        if (permClass != null) {
            pc = this.convert(permissions, 4, 0.75f, 1, 2);
        } else {
            pc = this.convert(permissions, 4, 0.75f, 1, 2);
            this.expandUmbrella(pc);
        }
        return pc.implies(permission);
    }

    @Override
    public void refresh() {
        this.basePolicy.refresh();
        LinkedList<PermissionGrant> remove = new LinkedList<PermissionGrant>();
        for (PermissionGrant p : this.dynamicPolicyGrants) {
            if (!p.isVoid()) continue;
            remove.add(p);
        }
        this.dynamicPolicyGrants.removeAll(remove);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && sm instanceof CachingSecurityManager) {
            ((CachingSecurityManager)((Object)sm)).clearCache();
        }
    }

    @Override
    public boolean grantSupported() {
        return true;
    }

    @Override
    public void grant(final Class cl, Principal[] principals, Permission[] permissions) {
        if (principals == null) {
            principals = new Principal[]{};
        }
        this.checkNullElements(principals);
        if (permissions == null || permissions.length == 0) {
            return;
        }
        this.checkNullElements(permissions);
        GrantPermission g = new GrantPermission(permissions);
        g.checkGuard(null);
        final PermissionGrantBuilder pgb = PermissionGrantBuilder.newBuilder();
        pgb.principals(principals).permissions(permissions).context(0);
        if (cl != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    pgb.clazz(cl);
                    return null;
                }
            });
        }
        PermissionGrant pe = pgb.build();
        this.dynamicPolicyGrants.add(pe);
        if (this.loggable) {
            logger.log(Level.FINEST, "Granting: {0}", pe.toString());
        }
    }

    @Override
    public Permission[] getGrants(Class cl, Principal[] principals) {
        ClassLoader loader = null;
        if (cl != null) {
            loader = cl.getClassLoader();
        }
        if (principals != null && principals.length > 0) {
            principals = (Principal[])principals.clone();
            this.checkNullElements(principals);
        }
        HashSet<Permission> dPerms = new HashSet<Permission>();
        for (PermissionGrant g : this.dynamicPolicyGrants) {
            if (!g.implies(loader, principals)) continue;
            dPerms.addAll(g.getPermissions());
        }
        Permission[] perms = dPerms.toArray(new Permission[dPerms.size()]);
        return perms;
    }

    @Override
    public Collection<PermissionGrant> getPermissionGrants(ProtectionDomain domain) {
        LinkedList<PermissionGrant> grants = null;
        if (this.basePolicy instanceof ScalableNestedPolicy) {
            grants = ((ScalableNestedPolicy)((Object)this.basePolicy)).getPermissionGrants(domain);
        } else {
            grants = new LinkedList<PermissionGrant>();
            grants.add(this.extractGrantFromPolicy(this.basePolicy, domain));
        }
        Iterator<PermissionGrant> it = this.dynamicPolicyGrants.iterator();
        while (it.hasNext()) {
            grants.add(it.next());
        }
        return grants;
    }

    @Override
    public boolean grant(PermissionGrant p) {
        Collection<Permission> perms = p.getPermissions();
        GrantPermission guard = new GrantPermission(perms.toArray(new Permission[perms.size()]));
        guard.checkGuard(null);
        return this.dynamicPolicyGrants.add(p);
    }
}

