/*
 * Decompiled with CFR 0.152.
 */
package org.apache.river.api.security;

import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.river.api.security.DefaultPolicyScanner;
import org.apache.river.api.security.DelegateSecurityManager;
import org.apache.river.api.security.PermissionComparator;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public final class DelegatePermission
extends Permission {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentMap<String, DelegatePermission> instances = RC.concurrentMap(new NonBlockingHashMap(), Ref.STRONG, Ref.WEAK, 1000L, 1000L);
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};
    private final Permission permission;
    private final int hashCode;

    public static DelegatePermission get(Permission p) {
        DelegatePermission existed;
        String name = DelegatePermission.constructName(p);
        DelegatePermission del = (DelegatePermission)instances.get(name);
        if (del == null && (existed = instances.putIfAbsent(name, del = new DelegatePermission(p))) != null) {
            del = existed;
        }
        return del;
    }

    private DelegatePermission(Permission p) {
        super(DelegatePermission.constructName(p));
        this.permission = p;
        int hash = 5;
        this.hashCode = hash = 41 * hash + (this.permission != null ? this.permission.hashCode() : 0);
    }

    public DelegatePermission(String name) {
        this(DelegatePermission.initFromName(name));
    }

    private static String constructName(Permission p) {
        StringBuilder sb = new StringBuilder(60);
        if (p instanceof UnresolvedPermission) {
            UnresolvedPermission u = (UnresolvedPermission)p;
            String t = u.getUnresolvedType();
            String n = u.getUnresolvedName();
            String a = u.getUnresolvedActions();
            sb.append(t);
            if (n != null) {
                sb.append(" ").append(DelegatePermission.quote(n));
                if (a != null) {
                    sb.append(", ").append(DelegatePermission.quote(a));
                }
            }
            sb.append("; ");
        } else {
            Class<?> cl = p.getClass();
            int nargs = DelegatePermission.maxConsArgs(cl);
            String t = cl.getName();
            String n = p.getName();
            String a = p.getActions();
            if (nargs == 2 && a != null) {
                sb.append(t).append(" ").append(DelegatePermission.quote(n)).append(", ").append(DelegatePermission.quote(a)).append("; ");
            } else if (nargs >= 1 && n != null) {
                sb.append(t).append(" ").append(DelegatePermission.quote(n)).append("; ");
            } else {
                sb.append(t).append("; ");
            }
        }
        return sb.toString().trim();
    }

    private static int maxConsArgs(Class cl) {
        try {
            cl.getConstructor(PARAMS2);
            return 2;
        }
        catch (Exception ex) {
            try {
                cl.getConstructor(PARAMS1);
                return 1;
            }
            catch (Exception ex2) {
                try {
                    cl.getConstructor(PARAMS0);
                    return 0;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        }
    }

    private static String quote(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append('\"');
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c == '\\' || c == '\"') {
                sb.append("\\").append(c);
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c < ' ') {
                sb.append("\\").append(Integer.toOctalString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    private static Permission initFromName(String name) {
        Class<?> cl;
        DefaultPolicyScanner.PermissionEntry pi;
        block15: {
            block14: {
                int d;
                pi = DelegatePermission.parsePermission(name);
                SecurityManager sm = System.getSecurityManager();
                if (sm != null && (d = pi.getKlass().lastIndexOf(46)) != -1) {
                    sm.checkPackageAccess(pi.getKlass().substring(0, d));
                }
                try {
                    cl = Class.forName(pi.getKlass());
                }
                catch (ClassNotFoundException ex) {
                    return new UnresolvedPermission(pi.getKlass(), pi.getName(), pi.getActions(), null);
                }
                if (!Permission.class.isAssignableFrom(cl)) {
                    throw new IllegalArgumentException("not a permission class: " + cl);
                }
                if (!Modifier.isPublic(cl.getModifiers())) {
                    throw new IllegalArgumentException("non-public permission class: " + cl);
                }
                if (pi.getName() == null) {
                    try {
                        Constructor<?> c = cl.getConstructor(PARAMS0);
                        return (Permission)c.newInstance(new Object[0]);
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof RuntimeException)) break block14;
                        throw (RuntimeException)ex;
                    }
                }
            }
            if (pi.getActions() == null) {
                try {
                    Constructor<?> c = cl.getConstructor(PARAMS1);
                    return (Permission)c.newInstance(pi.getName());
                }
                catch (Exception ex) {
                    if (!(ex instanceof RuntimeException)) break block15;
                    throw (RuntimeException)ex;
                }
            }
        }
        try {
            Constructor<?> c = cl.getConstructor(PARAMS2);
            return (Permission)c.newInstance(pi.getName(), pi.getActions());
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalArgumentException("uninstantiable permission class: " + cl);
        }
    }

    private static DefaultPolicyScanner.PermissionEntry parsePermission(String s) {
        try {
            StreamTokenizer st = DelegatePermission.createTokenizer(s);
            int delim = 34;
            if (st.nextToken() == -3 && st.sval.equals("delim")) {
                if (st.nextToken() == 61) {
                    if (st.nextToken() == -3) {
                        if (st.sval.length() > 1) {
                            throw new IllegalArgumentException("excess delimiter characters");
                        }
                        delim = st.sval.charAt(0);
                    } else {
                        delim = (char)st.ttype;
                    }
                    if (delim == 59) {
                        throw new IllegalArgumentException("illegal delimiter ';'");
                    }
                } else {
                    st = DelegatePermission.createTokenizer(s);
                }
                st.nextToken();
            }
            st.quoteChar(delim);
            String name = null;
            String actions = null;
            if (st.ttype != -3) {
                throw new IllegalArgumentException("expected permission type");
            }
            String type = st.sval;
            st.nextToken();
            if (st.ttype == -1 || st.ttype == 59) {
                return new DefaultPolicyScanner.PermissionEntry(type, null, null, null);
            }
            if (st.ttype != delim) {
                throw new IllegalArgumentException("expected permission name or ';'");
            }
            name = st.sval;
            st.nextToken();
            if (st.ttype == -1 || st.ttype == 59) {
                return new DefaultPolicyScanner.PermissionEntry(type, name, null, null);
            }
            if (st.ttype != 44) {
                throw new IllegalArgumentException("expected ',' or ';'");
            }
            if (st.nextToken() != delim) {
                throw new IllegalArgumentException("expected permission actions");
            }
            actions = st.sval;
            st.nextToken();
            if (st.ttype == -1 || st.ttype == 59) {
                return new DefaultPolicyScanner.PermissionEntry(type, name, actions, null);
            }
            throw new IllegalArgumentException("expected ';'");
        }
        catch (IOException ex) {
            throw (Error)new InternalError().initCause(ex);
        }
    }

    private static StreamTokenizer createTokenizer(String s) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.lowerCaseMode(false);
        st.ordinaryChar(47);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        return st;
    }

    @Override
    public void checkGuard(Object object) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm instanceof DelegateSecurityManager) {
            sm.checkPermission(this);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (!(permission instanceof DelegatePermission)) {
            return false;
        }
        if (permission.getClass() != this.getClass()) {
            return false;
        }
        return this.permission.implies(((DelegatePermission)permission).getPermission());
    }

    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.hashCode() != this.hashCode) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getName().equals(((Permission)obj).getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new DelegatePermissionCollection();
    }

    private Object writeReplace() {
        return new SerializationProxy(this.permission);
    }

    private void readObject(ObjectInputStream in) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class DelegatePermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private final transient PermissionCollection candidates = new Permissions();
        private final Set<Permission> delegates = new TreeSet<Permission>(new PermissionComparator());

        DelegatePermissionCollection() {
        }

        @Override
        public void add(Permission permission) {
            if (!(permission instanceof DelegatePermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            this.delegates.add(permission);
            this.candidates.add(((DelegatePermission)permission).getPermission());
        }

        @Override
        public boolean implies(Permission permission) {
            if (!(permission instanceof DelegatePermission)) {
                return false;
            }
            return this.candidates.implies(((DelegatePermission)permission).getPermission());
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.delegates);
        }

        private Object writeReplace() {
            return new CollectionSerializationProxy(this.delegates);
        }

        private void readObject(ObjectInputStream in) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static class CollectionSerializationProxy
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Permission[] perms;

            CollectionSerializationProxy(Set<Permission> p) {
                this.perms = p.toArray(new Permission[p.size()]);
            }

            private Object readResolve() {
                DelegatePermissionCollection dpc = new DelegatePermissionCollection();
                int l = this.perms.length;
                for (int i = 0; i < l; ++i) {
                    dpc.add(this.perms[i]);
                }
                return dpc;
            }
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String perm;

        SerializationProxy(Permission p) {
            this.perm = DelegatePermission.constructName(p);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
        }

        private Object readResolve() {
            Permission p = (Permission)instances.get(this.perm);
            if (p != null) {
                return p;
            }
            return new DelegatePermission(this.perm);
        }
    }
}

